/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.jatmi;

import com.bea.core.jatmi.common.Utilities;
import com.bea.core.jatmi.common.ntrace;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import weblogic.socket.MuxableSocket;
import weblogic.socket.NIOConnection;
import weblogic.socket.SocketInfo;
import weblogic.socket.SocketMuxer;
import weblogic.wtc.WTCLogger;
import weblogic.wtc.jatmi.TdomTcb;
import weblogic.wtc.jatmi.rdsession;
import weblogic.wtc.jatmi.tcb;
import weblogic.wtc.jatmi.tcm;
import weblogic.wtc.jatmi.tfmh;
import weblogic.wtc.jatmi.tplle;

public final class TuxedoMuxableSocket
implements MuxableSocket {
    private rdsession myTuxReadSession;
    private Socket in;
    private SocketMuxer myMuxer;
    private InputStream in_stream;
    private int in_timeout;
    private boolean opened = false;
    private MuxableSocket filter = null;
    private int elevel = 0;
    private tplle lle = null;
    private int myProtocol = 10;
    private static final int INITIAL_SIZE = 1000;
    private byte[] myTuxBuf;
    private int myOffset = 0;
    private int myDecryptOffset = 0;
    private ByteArrayInputStream myInputStream;
    private DataInputStream myDataStream;
    private SocketInfo sockInfo;
    private boolean canDispatch;

    public TuxedoMuxableSocket() {
        this.myTuxBuf = new byte[1000];
        this.myInputStream = new ByteArrayInputStream(this.myTuxBuf);
        this.myInputStream.mark(0);
        this.myDataStream = new DataInputStream(this.myInputStream);
        this.myMuxer = SocketMuxer.getMuxer();
        try {
            this.myMuxer.register(this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.setSocketFilter(this);
    }

    public DataInputStream getInputStream() {
        return this.myDataStream;
    }

    public TuxedoMuxableSocket(Socket socket, boolean bl) throws IOException, SocketException {
        this.in = socket;
        this.in_stream = this.in.getInputStream();
        this.in_timeout = this.in.getSoTimeout();
        this.opened = true;
        this.canDispatch = false;
        this.myTuxBuf = new byte[1000];
        this.myInputStream = new ByteArrayInputStream(this.myTuxBuf);
        this.myInputStream.mark(0);
        this.myDataStream = new DataInputStream(this.myInputStream);
        this.myMuxer = SocketMuxer.getMuxer();
        if (!bl) {
            this.canDispatch = true;
            this.myMuxer.register(this);
        }
        this.setSocketFilter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecvSession(rdsession rdsession2) {
        this.myTuxReadSession = rdsession2;
        TuxedoMuxableSocket tuxedoMuxableSocket = this;
        synchronized (tuxedoMuxableSocket) {
            this.canDispatch = true;
        }
        this.myMuxer.read(this.getSocketFilter());
    }

    public byte[] getBuffer() {
        if (this.myOffset >= this.myTuxBuf.length) {
            byte[] byArray = new byte[this.myTuxBuf.length + 1000];
            System.arraycopy(this.myTuxBuf, 0, byArray, 0, this.myOffset);
            this.myTuxBuf = byArray;
            this.myInputStream = new ByteArrayInputStream(this.myTuxBuf);
            this.myInputStream.mark(0);
            this.myDataStream = new DataInputStream(this.myInputStream);
        }
        return this.myTuxBuf;
    }

    public int getBufferOffset() {
        return this.myOffset;
    }

    public void setBufferOffset(int n) {
        this.myOffset = n;
    }

    public void incrementBufferOffset(int n) {
        this.myOffset += n;
    }

    public boolean isMessageComplete() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        boolean bl = ntrace.isTraceEnabled((int)4);
        if (bl) {
            ntrace.doTrace((String)"[/TuxedoMuxableSocket/dispatch/");
        }
        int n = 0;
        if (bl) {
            ntrace.doTrace((String)("/TuxedoMuxableSocket/dispatch/myOffset=" + this.myOffset + "/myDecryptOffset=" + this.myDecryptOffset + "/myProtocol=" + this.myProtocol));
        }
        TuxedoMuxableSocket tuxedoMuxableSocket = this;
        synchronized (tuxedoMuxableSocket) {
            if (!this.canDispatch) {
                if (bl) {
                    ntrace.doTrace((String)"/TuxedoMuxableSocket/dispatch/no dispatch yet");
                }
                this.myInputStream.reset();
                this.myMuxer.read(this.getSocketFilter());
                this.notify();
                return;
            }
        }
        if (this.myOffset < 32) {
            this.myMuxer.read(this.getSocketFilter());
            if (bl) {
                ntrace.doTrace((String)"]/TuxedoMuxableSocket/dispatch/10");
            }
            return;
        }
        if (this.lle != null && this.elevel != 0 && this.myDecryptOffset < this.myOffset) {
            if (this.lle.crypGetRBuf(this.myTuxBuf, this.myDecryptOffset, this.myOffset - this.myDecryptOffset) != 0) {
                this.myMuxer.closeSocket(this.getSocketFilter());
                this.opened = false;
                if (this.myTuxReadSession != null) {
                    this.myTuxReadSession.connectionHasTerminated();
                }
                if (bl) {
                    ntrace.doTrace((String)"]/TuxedoMuxableSocket/dispatch/20");
                }
                return;
            }
            this.myDecryptOffset = this.myOffset;
        }
        this.myInputStream.reset();
        while (n <= this.myOffset) {
            int n2;
            int n3;
            int n4 = this.myOffset - n;
            if (n4 < 32) {
                for (int i = n; i < this.myOffset; ++i) {
                    this.myTuxBuf[i - n] = this.myTuxBuf[i];
                }
                this.myOffset = n4;
                this.myDecryptOffset = n4;
                this.myMuxer.read(this.getSocketFilter());
                if (bl) {
                    ntrace.doTrace((String)"]/TuxedoMuxableSocket/dispatch/30/");
                }
                return;
            }
            if (this.myProtocol <= 13) {
                if (Utilities.baReadInt((byte[])this.myTuxBuf, (int)0) != 1938831426) {
                    this.myMuxer.closeSocket(this.getSocketFilter());
                    this.opened = false;
                    if (this.myTuxReadSession != null) {
                        this.myTuxReadSession.connectionHasTerminated();
                    }
                    if (bl) {
                        ntrace.doTrace((String)"]/TuxedoMuxableSocket/dispatch/35/Invalid MagicNumber");
                    }
                    WTCLogger.logErrorInvalidMagicNumber();
                    return;
                }
                n3 = Utilities.baReadInt((byte[])this.myTuxBuf, (int)(n + 28));
            } else {
                n3 = Utilities.baReadInt((byte[])this.myTuxBuf, (int)(n + 16));
            }
            if (n3 < 32) {
                this.myMuxer.closeSocket(this.getSocketFilter());
                this.opened = false;
                if (this.myTuxReadSession != null) {
                    this.myTuxReadSession.connectionHasTerminated();
                }
                if (bl) {
                    ntrace.doTrace((String)("]/TuxedoMuxableSocket/dispatch/40/invalid size=" + n3));
                }
                return;
            }
            if (bl) {
                ntrace.doTrace((String)("/TuxedoMuxableSocket/dispatch/size=" + n3));
            }
            if (n3 > this.myTuxBuf.length) {
                byte[] byArray = new byte[n3];
                System.arraycopy(this.myTuxBuf, n, byArray, 0, n4);
                this.myTuxBuf = byArray;
                this.myInputStream = new ByteArrayInputStream(this.myTuxBuf);
                this.myInputStream.mark(0);
                this.myDataStream = new DataInputStream(this.myInputStream);
                this.myOffset = n4;
                this.myDecryptOffset = n4;
                this.myMuxer.read(this.getSocketFilter());
                if (bl) {
                    ntrace.doTrace((String)"]/TuxedoMuxableSocket/dispatch/50");
                }
                return;
            }
            if (n3 > n4) {
                if (n != 0) {
                    for (int i = n; i < this.myOffset; ++i) {
                        this.myTuxBuf[i - n] = this.myTuxBuf[i];
                    }
                    this.myOffset = n4;
                    this.myDecryptOffset = n4;
                }
                this.myMuxer.read(this.getSocketFilter());
                if (bl) {
                    ntrace.doTrace((String)"]/TuxedoMuxableSocket/dispatch/60");
                }
                return;
            }
            tfmh tfmh2 = this.myTuxReadSession.allocTfmh();
            if (ntrace.isTraceEnabled((int)64)) {
                tfmh2.dumpUData(true);
            }
            try {
                n2 = this.myProtocol <= 13 ? tfmh2.read_dom_65_tfmh(this.myDataStream, this.myProtocol) : tfmh2.read_tfmh(this.myDataStream);
            }
            catch (IOException iOException) {
                this.myMuxer.closeSocket(this.getSocketFilter());
                this.opened = false;
                if (this.myTuxReadSession != null) {
                    this.myTuxReadSession.connectionHasTerminated();
                }
                if (bl) {
                    ntrace.doTrace((String)("]/TuxedoMuxableSocket/dispatch/70/" + iOException));
                }
                return;
            }
            switch (n2) {
                case 0: {
                    break;
                }
                case -2: {
                    TdomTcb tdomTcb;
                    WTCLogger.logDroppedMessage();
                    if (bl) {
                        ntrace.doTrace((String)"/TuxedoMuxableSocket/dispatch/dropped message");
                    }
                    int n5 = tfmh2.tdom == null || (tdomTcb = (TdomTcb)tfmh2.tdom.body) == null ? 0 : tdomTcb.get_reqid();
                    TdomTcb tdomTcb2 = new TdomTcb(3, n5, 0, null);
                    tdomTcb2.set_diagnostic(12);
                    tfmh tfmh3 = new tfmh(1);
                    tfmh3.tdom = new tcm(7, (tcb)tdomTcb2);
                    tfmh2 = tfmh3;
                    break;
                }
                default: {
                    this.myMuxer.closeSocket(this.getSocketFilter());
                    this.opened = false;
                    if (this.myTuxReadSession != null) {
                        this.myTuxReadSession.connectionHasTerminated();
                    }
                    if (bl) {
                        ntrace.doTrace((String)("]/TuxedoMuxableSocket/dispatch/90/failure=" + n2));
                    }
                    return;
                }
            }
            this.myTuxReadSession.dispatch(tfmh2);
            n += n3;
        }
        this.myMuxer.closeSocket(this.getSocketFilter());
        this.opened = false;
        if (this.myTuxReadSession != null) {
            this.myTuxReadSession.connectionHasTerminated();
        }
        if (bl) {
            ntrace.doTrace((String)("]/TuxedoMuxableSocket/dispatch/100/metahdrOffset=" + n + "/myOffset=" + this.myOffset));
        }
    }

    public Socket getSocket() {
        return this.in;
    }

    public boolean closeSocketOnError() {
        return true;
    }

    public InputStream getSocketInputStream() {
        return this.in_stream;
    }

    public void setSoTimeout(int n) throws SocketException {
        if (n == this.in_timeout) {
            return;
        }
        this.in.setSoTimeout(n);
    }

    public boolean isClosed() {
        return !this.opened;
    }

    public void hasException(Throwable throwable) {
        boolean bl = ntrace.isTraceEnabled((int)4);
        if (bl) {
            ntrace.doTrace((String)("[/TuxedoMuxableSocket/hasException/" + throwable));
        }
        this.opened = false;
        if (this.myTuxReadSession != null) {
            this.myTuxReadSession.connectionHasTerminated();
        }
        if (bl) {
            ntrace.doTrace((String)"]/TuxedoMuxableSocket/hasException/10");
        }
    }

    public void endOfStream() {
        boolean bl = ntrace.isTraceEnabled((int)4);
        if (bl) {
            ntrace.doTrace((String)"[/TuxedoMuxableSocket/endOfStream/");
        }
        this.opened = false;
        if (this.myTuxReadSession != null) {
            this.myTuxReadSession.connectionHasTerminated();
        }
        if (bl) {
            ntrace.doTrace((String)"]/TuxedoMuxableSocket/endOfStream/10");
        }
    }

    public boolean timeout() {
        this.endOfStream();
        return true;
    }

    public final boolean requestTimeout() {
        return true;
    }

    public int getIdleTimeoutMillis() {
        return 0;
    }

    public int getCompleteMessageTimeoutMillis() {
        return 0;
    }

    public int setElevel(int n) {
        boolean bl = ntrace.isTraceEnabled((int)4);
        if (bl) {
            ntrace.doTrace((String)("[/TuxedoMuxableSocket/setELevel(" + n + ")/"));
        }
        if (n == 1 || n == 2 || n == 32 || n == 4) {
            this.elevel = n;
            if (bl) {
                ntrace.doTrace((String)"]/TuxedoMuxableSocket/setElevel/10/0");
            }
            return 0;
        }
        if (bl) {
            ntrace.doTrace((String)"]/TuxedoMuxableSocket/setElevel/20/1");
        }
        return 1;
    }

    public void setLLE(tplle tplle2) {
        boolean bl = ntrace.isTraceEnabled((int)4);
        if (bl) {
            ntrace.doTrace((String)"[/TuxedoMuxableSocket/setLLE/");
        }
        this.lle = tplle2;
        if (bl) {
            ntrace.doTrace((String)"]/TuxedoMuxableSocket/setLLE/10/");
        }
    }

    public void setProtocol(int n) {
        this.myProtocol = n;
    }

    public void close() {
        if (this.sockInfo != null) {
            this.myMuxer.closeSocket(this.getSocketFilter());
        }
        this.opened = false;
        if (this.myTuxReadSession != null) {
            this.myTuxReadSession.connectionHasTerminated();
        }
    }

    public void setSocketFilter(MuxableSocket muxableSocket) {
        this.filter = muxableSocket;
    }

    public MuxableSocket getSocketFilter() {
        return this.filter;
    }

    public SocketInfo getSocketInfo() {
        return this.sockInfo;
    }

    public void setSocketInfo(SocketInfo socketInfo) {
        this.sockInfo = socketInfo;
    }

    public boolean supportsScatteredRead() {
        return false;
    }

    public long read(NIOConnection nIOConnection) throws IOException {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer[] getAvailableBufferofSize(int n) {
        throw new UnsupportedOperationException();
    }
}

