/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.jatmi;

import com.bea.core.jatmi.common.ntrace;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.utils.KeyStoreUtils;
import weblogic.security.utils.SSLCertUtility;
import weblogic.security.utils.SSLContextManager;
import weblogic.security.utils.SSLContextWrapper;
import weblogic.wtc.WTCLogger;

public final class TuxedoSSLSocketFactory
extends weblogic.security.SSL.SSLSocketFactory {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    public static final String[] CIPHER0 = new String[]{"TLS_RSA_WITH_NULL_MD5", "TLS_RSA_WITH_NULL_SHA"};
    public static final String[] CIPHER56 = new String[]{"TLS_RSA_WITH_DES_CBC_SHA"};
    public static final String[] CIPHER112 = new String[]{"TLS_RSA_WITH_3DES_EDE_CBC_SHA"};
    public static final String[] CIPHER128 = new String[]{"TLS_RSA_WITH_RC4_128_SHA", "TLS_RSA_WITH_RC4_128_MD5"};
    public static final String[] CIPHER256 = new String[]{"TLS_RSA_WITH_AES_256_CBC_SHA"};
    private String ksType;
    private String trustKsType;
    private String identityKeyStore;
    private String identityKeyStorePassphrase;
    private String identityKeyAlias;
    private String identityKeyPassphrase;
    private String trustKeyStore;
    private String trustKeyStorePassphrase;

    public TuxedoSSLSocketFactory(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        super((SSLSocketFactory)null);
        this.ksType = string;
        this.identityKeyStore = string2;
        this.identityKeyStorePassphrase = string3;
        this.identityKeyAlias = string4;
        this.identityKeyPassphrase = string5;
        this.trustKsType = string6;
        this.trustKeyStore = string7;
        this.trustKeyStorePassphrase = string8;
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        SSLSocketFactory sSLSocketFactory = this.getSocketFactory();
        return sSLSocketFactory.createSocket(inetAddress, n);
    }

    public String[] getDefaultCipherSuites() {
        try {
            return this.getSocketFactory().getDefaultCipherSuites();
        }
        catch (IOException iOException) {
            throw (RuntimeException)new IllegalStateException().initCause(iOException);
        }
    }

    public String[] getSupportedCipherSuites() {
        try {
            return this.getSocketFactory().getSupportedCipherSuites();
        }
        catch (IOException iOException) {
            throw (RuntimeException)new IllegalStateException().initCause(iOException);
        }
    }

    public ServerSocket createServerSocket(int n, int n2, InetAddress inetAddress) throws IOException {
        return this.getServerSocketFactory().createServerSocket(n, n2, inetAddress);
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        return this.getSocketFactory().createSocket(socket, string, n, bl);
    }

    private SSLServerSocketFactory getServerSocketFactory() throws IOException {
        String string;
        Certificate[] certificateArray;
        Key key;
        File file;
        String string2;
        SSLContextWrapper sSLContextWrapper;
        boolean bl;
        block20: {
            bl = ntrace.isTraceEnabled((int)4);
            if (bl) {
                ntrace.doTrace((String)"[/TuxedoSSLSocketFactory/getServerSocketFactory()");
            }
            sSLContextWrapper = SSLContextWrapper.getInstance();
            string2 = "getServerSocketFactory";
            file = null;
            KeyStore keyStore = null;
            key = null;
            certificateArray = null;
            String string3 = string = this.identityKeyStore == null ? "unspecified" : this.identityKeyStore;
            if (this.identityKeyStore != null && (file = new File(this.identityKeyStore)).exists()) {
                keyStore = KeyStoreUtils.load(file, this.identityKeyStorePassphrase, this.ksType);
            }
            if (keyStore == null) {
                WTCLogger.logErrorInvalidPrivateKeyStoreInfo(string, string2);
                if (bl) {
                    ntrace.doTrace((String)"*]/TuxedoSSLSocketFactory/getServerSocketFactory(10)/bad key store");
                }
                throw new IOException("Problem with private key store " + string);
            }
            try {
                key = keyStore.getKey(this.identityKeyAlias, this.identityKeyPassphrase.toCharArray());
                certificateArray = keyStore.getCertificateChain(this.identityKeyAlias);
            }
            catch (Exception exception) {
                if (!bl) break block20;
                exception.printStackTrace();
            }
        }
        if (key == null || !(key instanceof PrivateKey) || !(certificateArray instanceof Certificate[])) {
            WTCLogger.logErrorInvalidPrivateKeyInfo(this.identityKeyAlias, string, string2);
            if (bl) {
                ntrace.doTrace((String)"*]/TuxedoSSLSocketFactory/getServerSocketFactory(20)/bad key or cert");
            }
            throw new IOException("Problem with key or certificate");
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            x509CertificateArray[i] = (X509Certificate)certificateArray[i];
        }
        sSLContextWrapper.addIdentity(x509CertificateArray, (PrivateKey)key);
        KeyStore keyStore = null;
        file = null;
        if (this.trustKeyStore != null || this.trustKeyStorePassphrase != null || this.trustKsType != null) {
            String string4 = string = this.trustKeyStore == null ? "unspecified" : this.trustKeyStore;
            if (this.trustKeyStore != null && (file = new File(string)).exists()) {
                keyStore = KeyStoreUtils.load(file, this.trustKeyStorePassphrase, this.trustKsType);
            }
            if (keyStore == null) {
                WTCLogger.logErrorInvalidTrustCertStoreInfo(string, string2);
                if (bl) {
                    ntrace.doTrace((String)"*]/TuxedoSSLSocketFactory/getServerSocketFactory(30)/bad trust store");
                }
                throw new IOException("Problem with trust certificate store " + string);
            }
            try {
                X509Certificate[] x509CertificateArray2 = null;
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(SSLCertUtility.getX509Certificates(keyStore));
                x509CertificateArray2 = arrayList.toArray(new X509Certificate[arrayList.size()]);
                sSLContextWrapper.addTrustedCA(x509CertificateArray2);
            }
            catch (Exception exception) {
                WTCLogger.logErrorInvalidTrustCertificate(string, string2);
                if (bl) {
                    ntrace.doTrace((String)"*]/TuxedoSSLSocketFactory/getServerSocketFactory(40)/bad trust cert");
                }
                throw new IOException(exception.getMessage());
            }
        }
        try {
            sSLContextWrapper.addTrustedCA(SSLContextManager.getServerTrustedCAs());
        }
        catch (Exception exception) {
            WTCLogger.logErrorInvalidServerTrustCertificate(string2);
            if (bl) {
                ntrace.doTrace((String)"*]/TuxedoSSLSocketFactory/getServerSocketFactory(50)/bad trust cert");
            }
            throw new IOException(exception.getMessage());
        }
        if (bl) {
            ntrace.doTrace((String)"]/TuxedoSSLSocketFactory/getServerSocketFactory(60)/success");
        }
        return sSLContextWrapper.getSSLServerSocketFactory();
    }

    private SSLSocketFactory getSocketFactory() throws IOException {
        String string;
        Certificate[] certificateArray;
        Key key;
        File file;
        String string2;
        SSLContextWrapper sSLContextWrapper;
        boolean bl;
        block20: {
            bl = ntrace.isTraceEnabled((int)4);
            if (bl) {
                ntrace.doTrace((String)"[/TuxedoSSLSocketFactory/getSocketFactory()");
            }
            sSLContextWrapper = SSLContextWrapper.getInstance();
            string2 = "getSocketFactory";
            file = null;
            KeyStore keyStore = null;
            key = null;
            certificateArray = null;
            String string3 = string = this.identityKeyStore == null ? "unspecified" : this.identityKeyStore;
            if (this.identityKeyStore != null && (file = new File(this.identityKeyStore)).exists()) {
                keyStore = KeyStoreUtils.load(file, this.identityKeyStorePassphrase, this.ksType);
            }
            if (keyStore == null) {
                WTCLogger.logErrorInvalidPrivateKeyStoreInfo(string, string2);
                if (bl) {
                    ntrace.doTrace((String)"*]/TuxedoSSLSocketFactory/getSocketFactory(10)/bad key store");
                }
                throw new IOException("Problem with private key store " + string);
            }
            try {
                key = keyStore.getKey(this.identityKeyAlias, this.identityKeyPassphrase.toCharArray());
                certificateArray = keyStore.getCertificateChain(this.identityKeyAlias);
            }
            catch (Exception exception) {
                if (!bl) break block20;
                exception.printStackTrace();
            }
        }
        if (key == null || !(key instanceof PrivateKey) || !(certificateArray instanceof Certificate[])) {
            WTCLogger.logErrorInvalidPrivateKeyInfo(this.identityKeyAlias, string, string2);
            if (bl) {
                ntrace.doTrace((String)"*]/TuxedoSSLSocketFactory/getSocketFactory(20)/bad key store");
            }
            throw new IOException("Problem with key or certificate");
        }
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        for (int i = 0; i < x509CertificateArray.length; ++i) {
            x509CertificateArray[i] = (X509Certificate)certificateArray[i];
        }
        sSLContextWrapper.addIdentity(x509CertificateArray, (PrivateKey)key);
        KeyStore keyStore = null;
        file = null;
        if (this.trustKeyStore != null || this.trustKeyStorePassphrase != null || this.trustKsType != null) {
            String string4 = string = this.trustKeyStore == null ? "unspecified" : this.trustKeyStore;
            if (this.trustKeyStore != null && (file = new File(string)).exists()) {
                keyStore = KeyStoreUtils.load(file, this.trustKeyStorePassphrase, this.trustKsType);
            }
            if (keyStore == null) {
                WTCLogger.logErrorInvalidTrustCertStoreInfo(string, string2);
                if (bl) {
                    ntrace.doTrace((String)"*]/TuxedoSSLSocketFactory/getSocketFactory(30)/bad trust store");
                }
                throw new IOException("Problem with trust certiticate store " + string);
            }
            try {
                X509Certificate[] x509CertificateArray2 = null;
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(SSLCertUtility.getX509Certificates(keyStore));
                x509CertificateArray2 = arrayList.toArray(new X509Certificate[arrayList.size()]);
                sSLContextWrapper.addTrustedCA(x509CertificateArray2);
            }
            catch (Exception exception) {
                WTCLogger.logErrorInvalidTrustCertificate(string, string2);
                if (bl) {
                    ntrace.doTrace((String)"*]/TuxedoSSLSocketFactory/getSocketFactory(40)/bad trust cert");
                }
                throw new IOException(exception.getMessage());
            }
        }
        try {
            X509Certificate[] x509CertificateArray3 = SSLContextManager.getServerTrustedCAs();
            sSLContextWrapper.addTrustedCA(x509CertificateArray3);
        }
        catch (Exception exception) {
            WTCLogger.logErrorInvalidServerTrustCertificate(string2);
            if (bl) {
                ntrace.doTrace((String)"*]/TuxedoSSLSocketFactory/getSocketFactory(50)/bad trust cert");
            }
            throw new IOException(exception.getMessage());
        }
        if (bl) {
            ntrace.doTrace((String)"]/TuxedoSSLSocketFactory/getSocketFactory(60)/get Factory");
        }
        return sSLContextWrapper.getSSLSocketFactory();
    }

    public static String[] getCiphers(int n, int n2) {
        int n3;
        String[] stringArray;
        int n4 = 0;
        boolean bl = false;
        if (n == 0 && !(bl = (stringArray = ManagementService.getRuntimeAccess(KERNEL_ID).getServer().getSSL()).isAllowUnencryptedNullCipher())) {
            if (n2 == 0) {
                WTCLogger.logErrorNoNullCiphersAllowed();
                return null;
            }
            WTCLogger.logWarnNoNullCiphersAllowed();
        }
        if (n <= 256 && n2 >= 256) {
            n4 += CIPHER256.length;
        }
        if (n <= 128 && n2 >= 128) {
            n4 += CIPHER128.length;
        }
        if (n <= 112 && n2 >= 112) {
            n4 += CIPHER112.length;
        }
        if (n <= 56 && n2 >= 56) {
            n4 += CIPHER56.length;
        }
        if (bl) {
            n4 += CIPHER0.length;
        }
        stringArray = new String[n4];
        int n5 = 0;
        if (n <= 256 && n2 >= 256) {
            for (n3 = 0; n3 < CIPHER256.length; ++n3) {
                stringArray[n5] = CIPHER256[n3];
                ++n5;
            }
        }
        if (n <= 128 && n2 >= 128) {
            for (n3 = 0; n3 < CIPHER128.length; ++n3) {
                stringArray[n5] = CIPHER128[n3];
                ++n5;
            }
        }
        if (n <= 112 && n2 >= 112) {
            for (n3 = 0; n3 < CIPHER112.length; ++n3) {
                stringArray[n5] = CIPHER112[n3];
                ++n5;
            }
        }
        if (n <= 56 && n2 >= 56) {
            for (n3 = 0; n3 < CIPHER56.length; ++n3) {
                stringArray[n5] = CIPHER56[n3];
                ++n5;
            }
        }
        if (bl) {
            for (n3 = 0; n3 < CIPHER0.length; ++n3) {
                stringArray[n5] = CIPHER0[n3];
                ++n5;
            }
        }
        return stringArray;
    }
}

