/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.jatmi;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import weblogic.wtc.WTCLogger;
import weblogic.wtc.jatmi.Decimal;

public final class Utilities {
    public static final String encode = Utilities.getEncode();
    public static final boolean supportIllformedEncodedData = Utilities.getIllformedDataSupport();

    public static String getEncode() {
        String string = null;
        try {
            string = System.getProperty("weblogic.wtc.encoding");
            if (string != null) {
                String string2 = new String("test");
                string2.getBytes(string);
            }
        }
        catch (Exception exception) {
            WTCLogger.logErrorUnsupportedEncoding(string);
            string = null;
        }
        return string;
    }

    public static boolean getIllformedDataSupport() {
        boolean bl = false;
        String string = System.getProperty("weblogic.wtc.supportIllformedEncodedData");
        if (string != null && "true".equals(string)) {
            bl = true;
        }
        return bl;
    }

    public static byte[] getEncBytes(String string) {
        if (encode != null) {
            try {
                return string.getBytes(encode);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                WTCLogger.logErrorUnsupportedEncoding(encode);
                return string.getBytes();
            }
        }
        return string.getBytes();
    }

    public static String getEncString(byte[] byArray) {
        String string;
        if (encode != null) {
            try {
                string = new String(byArray, encode);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                WTCLogger.logErrorUnsupportedEncoding(encode);
                return new String(byArray);
            }
        } else {
            string = new String(byArray);
        }
        if (supportIllformedEncodedData && string.length() == 0 && byArray.length > 1) {
            for (int i = 1; i <= 4; ++i) {
                if (encode != null) {
                    try {
                        string = new String(byArray, 0, byArray.length - i, encode);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        WTCLogger.logErrorUnsupportedEncoding(encode);
                        return new String(byArray);
                    }
                } else {
                    string = new String(byArray, 0, byArray.length - i);
                }
                if (string.length() > 0 || byArray.length - i <= 1) break;
            }
        }
        return string;
    }

    public static String getEncString(byte[] byArray, int n, int n2) {
        if (encode != null) {
            try {
                return new String(byArray, n, n2, encode);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                WTCLogger.logErrorUnsupportedEncoding(encode);
                return new String(byArray, n, n2);
            }
        }
        return new String(byArray, n, n2);
    }

    public static int roundup4(int n) {
        return n + 3 & 0xFFFFFFFC;
    }

    public static int xdr_encode_string_length(DataOutputStream dataOutputStream, String string, int n) throws IOException {
        int n2;
        dataOutputStream.writeInt(n);
        if (string != null) {
            byte[] byArray = Utilities.getEncBytes(string);
            n2 = byArray.length;
            dataOutputStream.write(byArray);
        } else {
            n2 = 0;
        }
        int n3 = Utilities.roundup4(n) - n2;
        for (int i = 0; i < n3; ++i) {
            dataOutputStream.writeByte(0);
        }
        return 4 + n;
    }

    public static int xdr_encode_string_length(DataOutputStream dataOutputStream, String string, int n, boolean bl) throws IOException {
        return Utilities.xdr_encode_string_length(dataOutputStream, string, n);
    }

    public static int xdr_encode_string(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string == null) {
            dataOutputStream.writeInt(0);
            return 4;
        }
        byte[] byArray = Utilities.getEncBytes(string);
        int n = byArray.length;
        int n2 = Utilities.roundup4(n) - n;
        dataOutputStream.writeInt(n);
        if (n == 0) {
            return 4;
        }
        dataOutputStream.write(byArray);
        for (int i = 0; i < n2; ++i) {
            dataOutputStream.writeByte(0);
        }
        return 4 + n + n2;
    }

    public static String xdr_decode_string(DataInputStream dataInputStream, byte[] byArray) throws IOException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return null;
        }
        int n2 = Utilities.roundup4(n);
        byte[] byArray2 = byArray == null || byArray.length < n2 ? new byte[n2] : byArray;
        for (int i = 0; i < n2; ++i) {
            byArray2[i] = dataInputStream.readByte();
        }
        return Utilities.getEncString(byArray2, 0, n);
    }

    public static int xdr_encode_string(DataOutputStream dataOutputStream, String string, boolean bl) throws IOException {
        Object[] objectArray;
        if (bl) {
            objectArray = new char[]{'\u0000'};
            string = string == null ? new String((char[])objectArray) : string + new String((char[])objectArray);
        } else if (string == null) {
            dataOutputStream.writeInt(0);
            return 4;
        }
        objectArray = Utilities.getEncBytes(string);
        int n = objectArray.length;
        int n2 = Utilities.roundup4(n) - n;
        dataOutputStream.writeInt(n);
        if (n == 0) {
            return 4;
        }
        dataOutputStream.write((byte[])objectArray);
        for (int i = 0; i < n2; ++i) {
            dataOutputStream.writeByte(0);
        }
        return 4 + n + n2;
    }

    public static String xdr_decode_string(DataInputStream dataInputStream, byte[] byArray, boolean bl) throws IOException {
        int n;
        int n2 = dataInputStream.readInt();
        if (n2 == 0) {
            return null;
        }
        int n3 = Utilities.roundup4(n2);
        byte[] byArray2 = byArray == null || byArray.length < n3 ? new byte[n3] : byArray;
        for (int i = 0; i < n3; ++i) {
            byArray2[i] = dataInputStream.readByte();
        }
        String string = Utilities.getEncString(byArray2, 0, n2);
        if (bl && (n = string.indexOf(0)) >= 0) {
            string = n == 0 ? null : string.substring(0, n);
        }
        return string;
    }

    public static int xdr_length_bstring(byte[] byArray) {
        if (byArray == null) {
            return 4;
        }
        return 4 + Utilities.roundup4(byArray.length);
    }

    public static int xdr_encode_bstring(DataOutputStream dataOutputStream, byte[] byArray) throws IOException {
        if (byArray == null) {
            dataOutputStream.writeInt(0);
            return 4;
        }
        int n = byArray.length;
        int n2 = Utilities.roundup4(n) - n;
        dataOutputStream.writeInt(n);
        if (n == 0) {
            return 4;
        }
        dataOutputStream.write(byArray, 0, n);
        for (int i = 0; i < n2; ++i) {
            dataOutputStream.writeByte(0);
        }
        return 4 + n + n2;
    }

    public static byte[] xdr_decode_bstring(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2 = dataInputStream.readInt();
        if (n2 == 0) {
            return null;
        }
        int n3 = Utilities.roundup4(n2) - n2;
        byte[] byArray = new byte[n2];
        int n4 = 0;
        while ((n = dataInputStream.read(byArray, n4, n2 - n4)) != -1 && (n4 += n) < n2) {
        }
        if (n3 > 0) {
            dataInputStream.skipBytes(n3);
        }
        return byArray;
    }

    public static int xdr_encode_decimal(DataOutputStream dataOutputStream, Decimal decimal) throws IOException {
        if (decimal == null) {
            return 0;
        }
        dataOutputStream.writeInt(decimal.exponent());
        dataOutputStream.writeInt(decimal.sign());
        dataOutputStream.writeInt(decimal.numDigits());
        byte[] byArray = decimal.digits();
        dataOutputStream.writeInt(16);
        int n = byArray.length > 16 ? 16 : byArray.length;
        dataOutputStream.write(byArray, 0, n);
        int n2 = Utilities.roundup4(16) - n;
        for (int i = 0; i < n2; ++i) {
            dataOutputStream.writeByte(0);
        }
        return 16 + n + n2;
    }

    public static Decimal xdr_decode_decimal(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        int n4 = dataInputStream.readInt();
        int n5 = dataInputStream.readInt();
        if (n5 == 0) {
            return new Decimal();
        }
        int n6 = Utilities.roundup4(n5) - n5;
        byte[] byArray = new byte[n5];
        int n7 = 0;
        while ((n = dataInputStream.read(byArray, n7, n5 - n7)) != -1 && (n7 += n) < n5) {
        }
        if (n6 > 0) {
            dataInputStream.skipBytes(n6);
        }
        try {
            return new Decimal(n3, n2, n4, byArray);
        }
        catch (NumberFormatException numberFormatException) {
            return new Decimal();
        }
    }
}

