/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.jatmi;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public final class mkfldclass32
extends Task {
    private String packageName;
    private String outputDirectory;
    private String fieldTable;
    private static final int FLD_SHORT = 0;
    private static final int FLD_LONG = 1;
    private static final int FLD_CHAR = 2;
    private static final int FLD_FLOAT = 3;
    private static final int FLD_DOUBLE = 4;
    private static final int FLD_STRING = 5;
    private static final int FLD_CARRAY = 6;
    private static final int FLD_INT = 7;
    private static final int FLD_DECIMAL = 8;
    private static final int FLD_PTR = 9;
    private static final int FLD_FML32 = 10;
    private static final int FLD_VIEW32 = 11;
    private static final int FLD_MBSTRING = 12;
    private static final int FNMASK32 = 0x1FFFFFF;
    private static final int FTMASK32 = 63;
    private static final int FTSHIFT32 = 25;

    private static void write_error(int n, String string) {
        System.out.println("Error at line " + n + ". " + string + ".");
        throw new BuildException();
    }

    public void execute() {
        boolean bl = false;
        String[] stringArray = new String[]{this.packageName, this.outputDirectory, this.fieldTable};
        mkfldclass32.doIt(stringArray);
    }

    public void setPackage(String string) {
        this.packageName = string;
    }

    public void setOutputDirectory(String string) {
        this.outputDirectory = string;
    }

    public void setFieldTable(String string) {
        this.fieldTable = string;
    }

    public static void generateDynamicCode(String string, String string2, String string3, File file) {
        String string4 = null;
        BufferedWriter bufferedWriter = null;
        string4 = new String(file.getName() + ".java");
        if (string3 != null) {
            string4 = string3 + File.separatorChar + string4;
        }
        File file2 = new File(string4);
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Could not create file " + string4 + ". " + fileNotFoundException);
            return;
        }
        catch (IOException iOException) {
            System.out.println("Error creating file " + string4 + ". " + iOException);
            return;
        }
        try {
            if (string2 != null) {
                bufferedWriter.write("package " + string2 + ";");
                bufferedWriter.newLine();
                bufferedWriter.newLine();
            }
            bufferedWriter.newLine();
            bufferedWriter.write("import weblogic.wtc.jatmi.DynamicFldTbl;");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("/**");
            bufferedWriter.newLine();
            bufferedWriter.write(" * @author Copyright (c) 2003 by BEA Systems, Inc. All Rights Reserved.");
            bufferedWriter.newLine();
            bufferedWriter.write(" */");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("/**");
            bufferedWriter.newLine();
            bufferedWriter.write(" * This class reads a FML32 Field Table during boot time");
            bufferedWriter.newLine();
            bufferedWriter.write(" * which implements the FldTbl interface.  ");
            bufferedWriter.newLine();
            bufferedWriter.write(" * @see weblogic.wtc.jatmi.FldTbl");
            bufferedWriter.newLine();
            bufferedWriter.write(" * @see weblogic.wtc.jatmi.FML");
            bufferedWriter.newLine();
            bufferedWriter.write(" * @author BEA Systems, Inc.");
            bufferedWriter.newLine();
            bufferedWriter.write(" */");
            bufferedWriter.newLine();
            bufferedWriter.write("final public class " + file);
            bufferedWriter.newLine();
            bufferedWriter.write("\textends weblogic.wtc.jatmi.DynamicFldTbl");
            bufferedWriter.newLine();
            bufferedWriter.write("{");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("\t// Users need to modify this to where the field file is during boot time.");
            bufferedWriter.newLine();
            bufferedWriter.write("\t// The string may be an absolute pathname, a path relative to the root directory");
            bufferedWriter.newLine();
            bufferedWriter.write("\t// from which Java is started, or a relative path that can be found as a resource file");
            bufferedWriter.newLine();
            bufferedWriter.write("\t// by the class loader.");
            bufferedWriter.newLine();
            bufferedWriter.write("\tstatic final String USERFMLTABLEFILE=\"" + string + "\";");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("\t/**");
            bufferedWriter.newLine();
            bufferedWriter.write("\t * The constructor.  ");
            bufferedWriter.newLine();
            bufferedWriter.write("\t */");
            bufferedWriter.newLine();
            bufferedWriter.write("\tpublic " + file + "() {");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t// the 2nd parameter, true for FML32, false for FML");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t// Default initial capacity is 101 and load factor is 0.75f");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\tsuper(USERFMLTABLEFILE, true);");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t// super(USERFMLTABLEFILE, true, 1000, 0.5f);");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t// the 3rd parameter, Initial Capacity");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t// the 4th parameter, Load Factor");
            bufferedWriter.newLine();
            bufferedWriter.write("\t}");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("\tpublic static void main(String[] args) {");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t" + file + " bf = new " + file + "();");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\tString[] list = bf.getFldNames();");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\tfor (int i = 0; i < list.length; i++ ) {");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t\tSystem.out.println(\"field name = [\" + list[i] + \"]\t\t\tfield name from field id = [\" + bf.Fldid_to_name(bf.name_to_Fldid(list[i]))+ \"]\");");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t}");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\tSystem.out.println(\"Total entries = \" + list.length);");
            bufferedWriter.newLine();
            bufferedWriter.write("\t}");
            bufferedWriter.newLine();
            bufferedWriter.write("\t");
            bufferedWriter.newLine();
            bufferedWriter.write("}");
            bufferedWriter.newLine();
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Unable to write output file " + iOException);
        }
    }

    public static void main(String[] stringArray) {
        try {
            mkfldclass32.doIt(stringArray);
        }
        catch (BuildException buildException) {
            // empty catch block
        }
    }

    private static void doIt(String[] stringArray) throws BuildException {
        File file;
        String string;
        String string2;
        BufferedWriter bufferedWriter = null;
        BufferedReader bufferedReader = null;
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl2 = true;
        boolean bl3 = false;
        if (stringArray.length < 1 || stringArray.length > 3) {
            System.out.println("Usage: mkfldclass32 [package [outputdirectory]] fldtbl");
            throw new BuildException();
        }
        if (stringArray.length == 1) {
            string2 = null;
            string = null;
            file = new File(stringArray[0]);
        } else if (stringArray.length == 2) {
            string = null;
            string2 = stringArray[0];
            file = new File(stringArray[1]);
        } else {
            string2 = stringArray[0];
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
            if ((string = stringArray[1]) != null && string.length() == 0) {
                string = null;
            }
            file = new File(stringArray[2]);
        }
        String string3 = System.getProperty("DynRdHdr");
        if (string3 != null) {
            mkfldclass32.generateDynamicCode(string3, string2, string, file);
            return;
        }
        String string4 = System.getProperty("target");
        if (string4 == null) {
            string4 = new String("1.4");
        }
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Could not find file " + file);
            throw new BuildException();
        }
        String string5 = new String(file.getName() + ".java");
        if (string != null) {
            string5 = string + File.separatorChar + string5;
        }
        File file2 = new File(string5);
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file2));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Could not create file " + string5 + ". " + fileNotFoundException);
            throw new BuildException();
        }
        catch (IOException iOException) {
            System.out.println("Error creating file " + string5 + ". " + iOException);
            throw new BuildException();
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        while (true) {
            int n7;
            String string6;
            try {
                string6 = bufferedReader.readLine();
                if (string6 == null) break;
                string6 = string6.trim();
                ++n2;
                n7 = 0;
            }
            catch (IOException iOException) {
                System.out.println("Finished! " + iOException);
                break;
            }
            int n8 = string6.length();
            try {
                String string7;
                int n9;
                if (!bl3 && string2 != null) {
                    bufferedWriter.write("package " + string2 + ";");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                }
                bl3 = true;
                if (n8 == 0 || string6.startsWith("#")) continue;
                if (string6.startsWith("$")) {
                    bufferedWriter.write("//" + string6.substring(1));
                    bufferedWriter.newLine();
                    continue;
                }
                if (string6.startsWith("*base")) {
                    if (!Character.isWhitespace(string6.charAt(5))) {
                        mkfldclass32.write_error(n2, "*base must be followed by white space");
                    }
                    n7 = 6;
                    while (Character.isWhitespace(string6.charAt(n7))) {
                        ++n7;
                    }
                    if (!Character.isDigit(string6.charAt(n7))) {
                        mkfldclass32.write_error(n2, "*base must be followed by a numeric value");
                    }
                    n9 = n7++;
                    while (n7 < string6.length() && Character.isDigit(string6.charAt(n7))) {
                        ++n7;
                    }
                    n = new Integer(string6.substring(n9, n7));
                    continue;
                }
                if (!bl) {
                    bl = true;
                    bufferedWriter.write("import java.io.*;");
                    bufferedWriter.newLine();
                    bufferedWriter.write("import java.lang.*;");
                    bufferedWriter.newLine();
                    bufferedWriter.write("import java.util.*;");
                    bufferedWriter.newLine();
                    bufferedWriter.write("import weblogic.wtc.jatmi.*;");
                    bufferedWriter.newLine();
                    bufferedWriter.newLine();
                    bufferedWriter.write("public final class " + file.getName());
                    bufferedWriter.newLine();
                    bufferedWriter.write("\timplements weblogic.wtc.jatmi.FldTbl");
                    bufferedWriter.newLine();
                    bufferedWriter.write("{");
                    bufferedWriter.newLine();
                    if (string4.compareTo("1.5") < 0) {
                        bufferedWriter.write("\tHashtable nametofieldHashTable;");
                    } else {
                        bufferedWriter.write("\tHashtable<String, Integer> nametofieldHashTable;");
                    }
                    bufferedWriter.newLine();
                    if (string4.compareTo("1.5") < 0) {
                        bufferedWriter.write("\tHashtable fieldtonameHashTable;");
                    } else {
                        bufferedWriter.write("\tHashtable<Integer, String> fieldtonameHashTable;");
                    }
                    bufferedWriter.newLine();
                }
                while (!Character.isWhitespace(string6.charAt(n7))) {
                    ++n7;
                }
                String string8 = string6.substring(0, n7);
                while (Character.isWhitespace(string6.charAt(n7))) {
                    ++n7;
                }
                if (!Character.isDigit(string6.charAt(n7))) {
                    mkfldclass32.write_error(n2, "fieldname " + string8 + " must be followed by a numeric value");
                }
                n9 = n7++;
                while (Character.isDigit(string6.charAt(n7))) {
                    ++n7;
                }
                n3 = new Integer(string6.substring(n9, n7)) + n;
                if (n3 > 0x1FFFFFF) {
                    mkfldclass32.write_error(n2, "fieldnumber " + n3 + " must be less than or equal to 33554431");
                }
                while (Character.isWhitespace(string6.charAt(n7))) {
                    ++n7;
                }
                n9 = n7;
                while (!Character.isWhitespace(string6.charAt(n7)) && string6.charAt(n7) != '\n') {
                    if (++n7 < n8) continue;
                    n7 = n8;
                    break;
                }
                if ((string7 = string6.substring(n9, n7)).equals("char")) {
                    n5 = 2;
                } else if (string7.equals("string")) {
                    n5 = 5;
                } else if (string7.equals("short")) {
                    n5 = 0;
                } else if (string7.equals("long")) {
                    n5 = 1;
                } else if (string7.equals("float")) {
                    n5 = 3;
                } else if (string7.equals("double")) {
                    n5 = 4;
                } else if (string7.equals("carray")) {
                    n5 = 6;
                } else if (string7.equals("ptr")) {
                    n5 = 9;
                } else if (string7.equals("fml32")) {
                    n5 = 10;
                } else if (string7.equals("view32")) {
                    n5 = 11;
                } else if (string7.equals("mbstring")) {
                    n5 = 12;
                } else {
                    mkfldclass32.write_error(n2, "fieldtype " + string7 + " is invalid");
                }
                n4 = (n5 & 0x3F) << 25 | n3 & 0x1FFFFFF;
                bufferedWriter.write("\t/** number: " + n3 + "  type: " + string7 + " */");
                bufferedWriter.newLine();
                bufferedWriter.write("\tpublic final static int " + string8 + " = " + n4 + ";");
                bufferedWriter.newLine();
                linkedList.add(string8);
                ++n6;
            }
            catch (IOException iOException) {
                System.out.println("Unable to write output file " + iOException);
            }
        }
        if (!bl) {
            System.out.println("Did not find any field entries");
            throw new BuildException();
        }
        if (n6 > 3000) {
            System.out.println("WARNING: Field tables with large numbers of fields can cause run-time");
            System.out.println("problems in the Java Virtual Machine.  Consider creating a dynamically");
            System.out.println("parsed field table by setting the DynRdHdr Java property to the run-time");
            System.out.println("path name of the field definition file.");
        }
        try {
            String string9;
            bufferedWriter.flush();
            bufferedWriter.write("\n\tpublic String Fldid_to_name(int fldid)");
            bufferedWriter.newLine();
            bufferedWriter.write("\t{");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\tif ( fieldtonameHashTable == null ) {");
            bufferedWriter.newLine();
            if (string4.compareTo("1.5") < 0) {
                bufferedWriter.write("\t\t\tfieldtonameHashTable = new Hashtable();");
            } else {
                bufferedWriter.write("\t\t\tfieldtonameHashTable = new Hashtable<Integer, String>();");
            }
            bufferedWriter.newLine();
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                string9 = (String)listIterator.next();
                bufferedWriter.write("\t\t\t");
                bufferedWriter.write("fieldtonameHashTable.put(new Integer(" + string9 + "), \"" + string9 + "\");");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("\t\t}");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("\t\treturn ((String)fieldtonameHashTable.get(new Integer(fldid)));");
            bufferedWriter.newLine();
            bufferedWriter.write("\t}");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("\tpublic int name_to_Fldid(String name)");
            bufferedWriter.newLine();
            bufferedWriter.write("\t{");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\tif ( nametofieldHashTable == null ) {");
            bufferedWriter.newLine();
            if (string4.compareTo("1.5") < 0) {
                bufferedWriter.write("\t\t\tnametofieldHashTable = new Hashtable();");
            } else {
                bufferedWriter.write("\t\t\tnametofieldHashTable = new Hashtable<String, Integer>();");
            }
            bufferedWriter.newLine();
            listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                string9 = (String)listIterator.next();
                bufferedWriter.write("\t\t\t");
                bufferedWriter.write("nametofieldHashTable.put(\"" + string9 + "\", new Integer(" + string9 + "));");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("\t\t}");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("\t\tInteger fld = (Integer)nametofieldHashTable.get(name);");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\tif (fld == null) {");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t\treturn (-1);");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t} else {");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t\treturn (fld.intValue());");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\t}");
            bufferedWriter.newLine();
            bufferedWriter.write("\t}");
            bufferedWriter.newLine();
            bufferedWriter.newLine();
            bufferedWriter.write("\tpublic String[] getFldNames()");
            bufferedWriter.newLine();
            bufferedWriter.write("\t{");
            bufferedWriter.newLine();
            bufferedWriter.write("\t\tString retval[] = new String[" + linkedList.size() + "];");
            bufferedWriter.newLine();
            int n10 = 0;
            listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                string9 = (String)listIterator.next();
                bufferedWriter.write("\t\tretval[" + n10 + "] = new String(\"" + string9 + "\");");
                bufferedWriter.newLine();
                ++n10;
            }
            bufferedWriter.write("\t\treturn retval;");
            bufferedWriter.newLine();
            bufferedWriter.write("\t}");
            bufferedWriter.newLine();
            bufferedWriter.write("}");
            bufferedWriter.newLine();
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Unable to write output file " + iOException);
            throw new BuildException();
        }
    }
}

