/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.tbridge;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Hashtable;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public final class tBsend2jms {
    public static final String JNDI_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    public static final String JMS_FACTORY = "weblogic.jms.ConnectionFactory";
    public static final String QUEUE = "weblogic.jms.Jms2TuxQueue";
    private QueueConnectionFactory qconFactory;
    private QueueConnection qcon;
    private QueueSession qsession;
    private QueueSender qsender;
    private Queue queue;
    private TextMessage textmsg;
    private BytesMessage bytesmsg;
    private static byte[] canofdata = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0};

    public void init(Context context, String string) throws NamingException, JMSException {
        this.qconFactory = (QueueConnectionFactory)context.lookup(JMS_FACTORY);
        this.qcon = this.qconFactory.createQueueConnection();
        this.qsession = this.qcon.createQueueSession(false, 1);
        try {
            this.queue = (Queue)context.lookup(string);
        }
        catch (NamingException namingException) {
            this.queue = this.qsession.createQueue(string);
            context.bind(string, (Object)this.queue);
        }
        this.qsender = this.qsession.createSender(this.queue);
        this.textmsg = this.qsession.createTextMessage();
        this.bytesmsg = this.qsession.createBytesMessage();
        this.qcon.start();
    }

    public void close() throws JMSException {
        this.qsender.close();
        this.qsession.close();
        this.qcon.close();
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        if (stringArray.length < 1 || stringArray.length > 2) {
            System.out.println("Usage: tBsend2jms [queue] WebLogicURL");
            return;
        }
        tBsend2jms tBsend2jms2 = new tBsend2jms();
        if (stringArray.length == 1) {
            object = tBsend2jms.getInitialContext(stringArray[0]);
            tBsend2jms2.init((Context)object, QUEUE);
        } else {
            object = tBsend2jms.getInitialContext(stringArray[1]);
            tBsend2jms2.init((Context)object, stringArray[0]);
        }
        object = new BufferedReader(new InputStreamReader(System.in));
        String string = null;
        boolean bl = false;
        do {
            System.out.println("Enter message (\"quit\" to quit): ");
            string = ((BufferedReader)object).readLine();
            if (string == null || string.trim().length() == 0) continue;
            boolean bl2 = bl = string.equalsIgnoreCase("quit") || string.trim().equalsIgnoreCase("<XML><STRING>quit</STRING></XML>");
            if (string.equalsIgnoreCase("bytes")) {
                tBsend2jms2.sendbytes(canofdata);
                continue;
            }
            if (string.equalsIgnoreCase("null")) {
                string = null;
            }
            tBsend2jms2.send(string);
        } while (!bl);
        tBsend2jms2.close();
    }

    private static InitialContext getInitialContext(String string) throws NamingException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", JNDI_FACTORY);
        hashtable.put("java.naming.provider.url", string);
        return new InitialContext(hashtable);
    }

    public void send(String string) throws JMSException {
        try {
            this.textmsg.setText(string);
            this.qsender.send((Message)this.textmsg);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void sendbytes(byte[] byArray) throws JMSException {
        try {
            this.bytesmsg.clearBody();
            this.bytesmsg.writeBytes(byArray);
            this.qsender.send((Message)this.bytesmsg);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

