/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.wls;

import com.bea.core.jatmi.intf.LogService;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.wtc.WTCLogger;

public final class WlsLogService
implements LogService {
    private static int level = -1;
    private DebugLogger CorbaEx = DebugLogger.getDebugLogger((String)"DebugWTCCorbaEx");
    private DebugLogger GwtEx = DebugLogger.getDebugLogger((String)"DebugWTCGwtEx");
    private DebugLogger JatmiEx = DebugLogger.getDebugLogger((String)"DebugWTCJatmiEx");
    private DebugLogger tBridgeEx = DebugLogger.getDebugLogger((String)"DebugWTCtBridgeEx");
    private DebugLogger WtcConfig = DebugLogger.getDebugLogger((String)"DebugWTCConfig");
    private DebugLogger WtcTdomPdu = DebugLogger.getDebugLogger((String)"DebugWTCTdomPdu");
    private DebugLogger WtcUData = DebugLogger.getDebugLogger((String)"DebugWTCUData");
    private boolean _debug = false;

    public void setTraceLevel(int n) {
        level = n;
    }

    public void doTrace(String string) {
        if (this._debug) {
            WTCLogger.logDebugMsg("WlsLogService:" + string);
        } else {
            WTCLogger.logDebugMsg(string);
        }
    }

    private boolean typeStatus(int n) {
        if ((n & 4) == 4) {
            if (this.JatmiEx.isDebugEnabled()) {
                return true;
            }
            if (level >= 55000) {
                return true;
            }
        }
        if ((n & 2) == 2) {
            if (this.GwtEx.isDebugEnabled()) {
                return true;
            }
            if (level >= 25000) {
                return true;
            }
        }
        if ((n & 1) == 1) {
            if (this.tBridgeEx.isDebugEnabled()) {
                return true;
            }
            if (level >= 15000) {
                return true;
            }
        }
        if ((n & 8) == 8) {
            if (this.CorbaEx.isDebugEnabled()) {
                return true;
            }
            if (level >= 65000) {
                return true;
            }
        }
        if ((n & 0x10) == 16 && this.WtcConfig.isDebugEnabled()) {
            return true;
        }
        if ((n & 0x20) == 32 && this.WtcTdomPdu.isDebugEnabled()) {
            return true;
        }
        return (n & 0x40) == 64 && this.WtcUData.isDebugEnabled();
    }

    public void doTrace(int n, String string) {
        if (this.typeStatus(n)) {
            WTCLogger.logDebugMsg(string);
        }
    }

    public void doTrace(int n, int n2, String string) {
        if (this.typeStatus(n2)) {
            WTCLogger.logDebugMsg(string);
        }
    }

    public boolean isTraceEnabled(int n) {
        switch (n) {
            case 4: {
                if (this.JatmiEx.isDebugEnabled()) {
                    return true;
                }
                if (level < 55000) break;
                return true;
            }
            case 2: {
                if (this.GwtEx.isDebugEnabled()) {
                    return true;
                }
                if (level < 25000) break;
                return true;
            }
            case 1: {
                if (this.tBridgeEx.isDebugEnabled()) {
                    return true;
                }
                if (level < 15000) break;
                return true;
            }
            case 8: {
                if (this.CorbaEx.isDebugEnabled()) {
                    return true;
                }
                if (level < 65000) break;
                return true;
            }
            case 16: {
                if (!this.WtcConfig.isDebugEnabled()) break;
                return true;
            }
            case 32: {
                if (!this.WtcTdomPdu.isDebugEnabled()) break;
                return true;
            }
            case 64: {
                if (!this.WtcUData.isDebugEnabled()) break;
                return true;
            }
        }
        return false;
    }

    public boolean isMixedTraceEnabled(int n) {
        return this.typeStatus(n);
    }
}

