/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.wls;

import com.bea.core.jatmi.common.ntrace;
import com.bea.core.jatmi.intf.TCAppKey;
import com.bea.core.jatmi.intf.TCAuthenticatedUser;
import com.bea.core.jatmi.intf.TCSecurityService;
import java.io.Serializable;
import java.security.AccessController;
import javax.security.auth.login.LoginException;
import weblogic.security.WLSPrincipals;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.wtc.jatmi.AppKey;
import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.wls.WlsAppKeyDelegate;
import weblogic.wtc.wls.WlsAuthenticatedUser;

public final class WlsSecurityService
implements TCSecurityService,
Serializable {
    static final long serialVersionUID = -2563145107053158113L;
    private static final AuthenticatedSubject myKid = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String SEL_LDAP = "LDAP";
    private static final String SEL_CUSTOM = "Custom";
    private ClassLoader _loader = null;
    private String _anon_username = null;
    private PrincipalAuthenticator _pa = null;

    public WlsSecurityService() {
        if (ntrace.isTraceEnabled((int)4)) {
            ntrace.doTrace((String)"[ WlsSecurityService()");
            this._anon_username = WLSPrincipals.getAnonymousUsername();
            this._pa = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)myKid, (String)"weblogicDEFAULT", (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
            ntrace.doTrace((String)"] WlsSecurityService/10");
        } else {
            this._anon_username = WLSPrincipals.getAnonymousUsername();
            this._pa = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)myKid, (String)"weblogicDEFAULT", (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
        }
    }

    static AuthenticatedSubject getKernelUser() {
        if (ntrace.isTraceEnabled((int)4)) {
            ntrace.doTrace((String)"[/WlsSecurityService/getKernelUser()");
            ntrace.doTrace((String)("] WlsSecurityService/getKernelUser/10/" + myKid));
        }
        return myKid;
    }

    public void shutdown(int n) {
    }

    public void pushUser(TCAuthenticatedUser tCAuthenticatedUser) {
        if (ntrace.isTraceEnabled((int)4)) {
            ntrace.doTrace((String)("[/WlsSecurityService/pushUser(" + tCAuthenticatedUser + ")"));
            tCAuthenticatedUser.setAsCurrentUser();
            ntrace.doTrace((String)"] WlsSecurityService/pushUser/10/");
        } else {
            tCAuthenticatedUser.setAsCurrentUser();
        }
    }

    public TCAuthenticatedUser getUser() {
        if (ntrace.isTraceEnabled((int)4)) {
            ntrace.doTrace((String)"[/WlsSecurityService/getUser()");
            AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)myKid);
            WlsAuthenticatedUser wlsAuthenticatedUser = new WlsAuthenticatedUser(authenticatedSubject);
            ntrace.doTrace((String)("] WlsSecurityService/getUser/10/" + wlsAuthenticatedUser));
            return wlsAuthenticatedUser;
        }
        AuthenticatedSubject authenticatedSubject = SecurityServiceManager.getCurrentSubject((AuthenticatedSubject)myKid);
        return new WlsAuthenticatedUser(authenticatedSubject);
    }

    public void popUser() {
        if (ntrace.isTraceEnabled((int)4)) {
            ntrace.doTrace((String)"[/WlsSecurityService/popUser()");
            SecurityServiceManager.popSubject((AuthenticatedSubject)myKid);
            ntrace.doTrace((String)"] WlsSecurityService/popUser/10/");
        } else {
            SecurityServiceManager.popSubject((AuthenticatedSubject)myKid);
        }
    }

    public String getAnonymousUserName() {
        if (ntrace.isTraceEnabled((int)4)) {
            ntrace.doTrace((String)"[/WlsSecurityService/getAnonymousUserName()");
            ntrace.doTrace((String)("]/WlsSecurityService/getAnonymousUserName/10/" + this._anon_username));
        }
        return this._anon_username;
    }

    public TCAuthenticatedUser impersonate(String string) throws LoginException {
        if (ntrace.isTraceEnabled((int)4)) {
            ntrace.doTrace((String)("[/WlsSecurityService/impersonate(" + string + ")"));
            AuthenticatedSubject authenticatedSubject = this._pa.impersonateIdentity(string);
            WlsAuthenticatedUser wlsAuthenticatedUser = new WlsAuthenticatedUser(authenticatedSubject);
            ntrace.doTrace((String)("]/WlsSecurityService/impersonate/10/" + wlsAuthenticatedUser));
            return wlsAuthenticatedUser;
        }
        AuthenticatedSubject authenticatedSubject = this._pa.impersonateIdentity(string);
        return new WlsAuthenticatedUser(authenticatedSubject);
    }

    public TCAppKey getAppKeyGenerator(String string, String string2, String string3, boolean bl, int n) {
        boolean bl2 = ntrace.isTraceEnabled((int)4);
        TCAppKey tCAppKey = null;
        boolean bl3 = false;
        if (bl2) {
            ntrace.doTrace((String)("[/WlsSecurityService/getAppKeyGenerator/" + string + ", p1 = " + string2 + ", p2 = " + string3 + ", p3 = " + bl + ", p4 = " + n));
        }
        if (string != null) {
            String string4;
            Serializable serializable;
            String string5;
            if (string.compareToIgnoreCase(SEL_LDAP) == 0) {
                string5 = new String("weblogic.wtc.wls.ldapAppKey");
                serializable = string2 == null || string2.length() == 0 ? new StringBuffer("TUXEDO_UID") : new StringBuffer(string2);
                serializable.append(" ");
                if (string3 == null || string3.length() == 0) {
                    serializable.append("TUXEDO_GID");
                } else {
                    serializable.append(string3);
                }
                string4 = new String((StringBuffer)serializable);
            } else if (string.compareToIgnoreCase(SEL_CUSTOM) == 0) {
                bl3 = true;
                string5 = string2;
                string4 = string3;
            } else {
                if (bl2) {
                    ntrace.doTrace((String)("unsupported AppKey Generator type: " + string));
                    ntrace.doTrace((String)"]/WlsSecurityService/getAppKeyGenerator/10/null");
                }
                return null;
            }
            try {
                Class<?> clazz;
                if (this._loader == null) {
                    serializable = this;
                    clazz = serializable.getClass();
                    this._loader = clazz.getClassLoader();
                }
                tCAppKey = (serializable = (clazz = this._loader.loadClass(string5)).newInstance()) instanceof AppKey ? new WlsAppKeyDelegate((AppKey)((Object)serializable)) : (TCAppKey)serializable;
                tCAppKey.init(string4, bl, n);
                if (!bl3) {
                    if (bl2) {
                        ntrace.doTrace((String)"Cache enabled");
                    }
                    tCAppKey.doCache(true);
                } else {
                    tCAppKey.doCache(false);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (bl2) {
                    ntrace.doTrace((String)"]/WlsSecurityService/getAppKeyGenerator/10/null");
                }
                return null;
            }
            catch (TPException tPException) {
                if (bl2) {
                    ntrace.doTrace((String)"]/WlsSecurityService/getAppKeyGenerator/20/null");
                }
                return null;
            }
            catch (Exception exception) {
                if (bl2) {
                    ntrace.doTrace((String)"]/WlsSecurityService/getAppKeyGenerator/30/null");
                }
                return null;
            }
        }
        if (bl2) {
            ntrace.doTrace((String)"]/WlsSecurityService/getAppKeyGenerator/40/success");
        }
        return tCAppKey;
    }

    public int getSecProviderId() {
        return 0;
    }

    public String getSecProviderName() {
        return "WLS Security Service for TC";
    }
}

