/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.wls;

import com.bea.core.jatmi.common.ntrace;
import com.bea.core.jatmi.intf.TCTransactionService;
import com.bea.core.jatmi.intf.TuxedoLoggable;
import java.io.Serializable;
import java.util.Hashtable;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import weblogic.transaction.InterposedTransactionManager;
import weblogic.transaction.ServerTransactionManager;
import weblogic.transaction.TransactionLogger;
import weblogic.transaction.TransactionManager;
import weblogic.transaction.TxHelper;
import weblogic.wtc.wls.WlsTuxedoLoggable;

public final class WlsTransactionService
implements TCTransactionService,
Serializable {
    private static TransactionLogger tlg = null;
    private static TransactionManager tm = null;
    private static InterposedTransactionManager itm = null;

    public WlsTransactionService() {
        boolean bl = ntrace.isTraceEnabled((int)4);
        if (bl) {
            ntrace.doTrace((String)"[ WlsTransactionService()");
            if (tlg == null) {
                ntrace.doTrace((String)"tlg == null");
                tm = TxHelper.getTransactionManager();
                tlg = ((ServerTransactionManager)tm).getTransactionLogger();
                itm = TxHelper.getServerInterposedTransactionManager();
            }
            ntrace.doTrace((String)"] WlsTransactionService()/10");
        } else if (tlg == null) {
            tm = TxHelper.getTransactionManager();
            tlg = ((ServerTransactionManager)tm).getTransactionLogger();
            itm = TxHelper.getServerInterposedTransactionManager();
        }
    }

    public void shutdown(int n) {
    }

    public int getRealTransactionTimeout() {
        weblogic.transaction.Transaction transaction = TxHelper.getTransaction();
        if (transaction != null) {
            return (int)(transaction.getTimeToLiveMillis() / 1000L);
        }
        return -1;
    }

    public void registerResource(String string, XAResource xAResource) throws SystemException {
        if (ntrace.isTraceEnabled((int)4)) {
            ntrace.doTrace((String)("[ /WlsTransactionService/registerResource(name = " + string + ", resource = " + xAResource + ")"));
            if (string != null) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("weblogic.transaction.registration.type", "standard");
                hashtable.put("weblogic.transaction.registration.settransactiontimeout", "true");
                tm.registerResource(string, xAResource, hashtable);
            }
            ntrace.doTrace((String)"] /WlsTransactionService/registerResource/10");
        } else if (string != null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("weblogic.transaction.registration.type", "standard");
            hashtable.put("weblogic.transaction.registration.settransactiontimeout", "true");
            tm.registerResource(string, xAResource, hashtable);
        }
    }

    public void unregisterResource(String string) {
        if (ntrace.isTraceEnabled((int)4)) {
            ntrace.doTrace((String)("[ /WlsTransactionService/unregisterResource(name = " + string + ")"));
            if (string != null) {
                try {
                    tm.unregisterResource(string);
                }
                catch (SystemException systemException) {
                    // empty catch block
                }
            }
            ntrace.doTrace((String)"] /WlsTransactionService/unregisterResource/10");
        } else if (string != null) {
            try {
                tm.unregisterResource(string);
            }
            catch (SystemException systemException) {
                // empty catch block
            }
        }
    }

    public TuxedoLoggable createTuxedoLoggable() {
        return new WlsTuxedoLoggable();
    }

    public TuxedoLoggable createTuxedoLoggable(Xid xid, int n) {
        return new WlsTuxedoLoggable(xid, n);
    }

    public XAResource getXAResource() {
        return itm.getXAResource();
    }

    public Transaction getTransaction() {
        return TxHelper.getTransaction();
    }

    public Transaction getTransaction(Xid xid) {
        return tm.getTransaction(xid);
    }

    public Xid getXidFromTransaction(Transaction transaction) {
        if (transaction instanceof weblogic.transaction.Transaction) {
            weblogic.transaction.Transaction transaction2 = (weblogic.transaction.Transaction)transaction;
            return transaction2.getXID();
        }
        return null;
    }

    public Xid getXidFromThread() {
        weblogic.transaction.Transaction transaction = TxHelper.getTransaction();
        if (transaction != null) {
            return transaction.getXID();
        }
        return null;
    }

    public int getXidFormatId() {
        return 48802;
    }

    public void resumeTransaction(Transaction transaction) throws Exception {
        tm.resume(transaction);
    }
}

