/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.wls;

import com.bea.core.jatmi.common.ntrace;
import com.bea.core.jatmi.config.TuxedoConnectorRAP;
import com.bea.core.jatmi.internal.TuxedoXid;
import com.bea.core.jatmi.intf.TuxedoLoggable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidObjectException;
import javax.transaction.xa.Xid;
import weblogic.transaction.ServerTransactionManager;
import weblogic.transaction.TransactionLoggable;
import weblogic.transaction.TransactionLogger;
import weblogic.transaction.TxHelper;
import weblogic.transaction.internal.LogDataInput;
import weblogic.transaction.internal.LogDataOutput;
import weblogic.wtc.gwt.OatmialServices;
import weblogic.wtc.gwt.WTCService;
import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.jatmi.Txid;

public class WlsTuxedoLoggable
implements TransactionLoggable,
TuxedoLoggable {
    private static final int VERSION = 1;
    private Txid myTxid;
    private Xid myXid;
    private int myType;
    private Object onDiskReply;
    private boolean gotDiskReply = false;
    private String[] remoteDomains;
    private TransactionLogger tlg = null;

    public WlsTuxedoLoggable() {
        this.myType = 0;
        this.onDiskReply = new Object();
    }

    public WlsTuxedoLoggable(Xid xid, int n) {
        this.myXid = xid;
        this.myTxid = new Txid(xid.getGlobalTransactionId());
        this.myType = n >= 0 && n <= 4 ? n : 0;
        this.onDiskReply = new Object();
    }

    public int getType() {
        return this.myType;
    }

    public void readExternal(DataInput dataInput) throws IOException {
        LogDataInput logDataInput = (LogDataInput)dataInput;
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/WlsTuxedoLoggable/readExternal/");
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        int n = logDataInput.readNonNegativeInt();
        if (n != 1) {
            if (bl) {
                ntrace.doTrace((String)"*]/WlsTuxedoLoggable/readExternal/10");
            }
            throw new InvalidObjectException("WTC log record: unrecognized versionnumber " + n);
        }
        this.myType = logDataInput.readNonNegativeInt();
        byArray = logDataInput.readByteArray();
        byArray2 = logDataInput.readByteArray();
        switch (this.myType) {
            case 1: 
            case 2: {
                this.myXid = TxHelper.createXid(byArray, byArray2);
                this.myTxid = new Txid(this.myXid.getGlobalTransactionId());
                break;
            }
            case 3: 
            case 4: {
                try {
                    this.myXid = new TuxedoXid(byArray, byArray2);
                }
                catch (TPException tPException) {
                    if (bl) {
                        ntrace.doTrace((String)"*]/WlsTuxedoLoggable/readExternal/20");
                    }
                    throw new InvalidObjectException("WTC log record: Invalid Tuxeod Xid " + (Object)((Object)tPException));
                }
                this.myTxid = new Txid(this.myXid.getGlobalTransactionId());
                break;
            }
            default: {
                if (bl) {
                    ntrace.doTrace((String)"*]/WlsTuxedoLoggable/readExternal/30");
                }
                throw new InvalidObjectException("WTC log record: unrecognized type " + this.myType);
            }
        }
        int n2 = logDataInput.readNonNegativeInt();
        if (n2 == 0) {
            if (bl) {
                ntrace.doTrace((String)"]/WlsTuxedoLoggable/readExternal/40");
            }
            return;
        }
        this.remoteDomains = new String[n2];
        for (int i = 0; i < n2; ++i) {
            this.remoteDomains[i] = logDataInput.readAbbrevString();
        }
        if (bl) {
            ntrace.doTrace((String)"]/WlsTuxedoLoggable/readExternal/50");
        }
    }

    public void writeExternal(DataOutput dataOutput) throws IOException {
        TuxedoConnectorRAP[] tuxedoConnectorRAPArray;
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/WlsTuxedoLoggable/writeExternal/");
        }
        LogDataOutput logDataOutput = (LogDataOutput)dataOutput;
        logDataOutput.writeNonNegativeInt(1);
        logDataOutput.writeNonNegativeInt(this.myType);
        if (this.myXid == null) {
            logDataOutput.writeNonNegativeInt(0);
            logDataOutput.writeNonNegativeInt(0);
            logDataOutput.writeNonNegativeInt(0);
            if (bl) {
                ntrace.doTrace((String)"]/WlsTuxedoLoggable/writeExternal/10");
            }
            return;
        }
        byte[] byArray = this.myXid.getGlobalTransactionId();
        logDataOutput.writeByteArray(byArray);
        byArray = this.myXid.getBranchQualifier();
        logDataOutput.writeByteArray(byArray);
        OatmialServices oatmialServices = WTCService.getOatmialServices();
        switch (this.myType) {
            case 3: 
            case 4: {
                tuxedoConnectorRAPArray = oatmialServices.getInboundRdomsAssociatedWithXid(this.myXid);
                break;
            }
            default: {
                tuxedoConnectorRAPArray = oatmialServices.getOutboundRdomsAssociatedWithXid(this.myXid);
            }
        }
        if (tuxedoConnectorRAPArray == null || tuxedoConnectorRAPArray.length == 0) {
            if (bl) {
                ntrace.doTrace((String)"no rdom");
            }
            logDataOutput.writeNonNegativeInt(0);
        } else {
            logDataOutput.writeNonNegativeInt(tuxedoConnectorRAPArray.length);
            for (int i = 0; i < tuxedoConnectorRAPArray.length; ++i) {
                logDataOutput.writeAbbrevString(tuxedoConnectorRAPArray[i].getAccessPoint());
            }
        }
        if (bl) {
            ntrace.doTrace((String)"]/WlsTuxedoLoggable/writeExternal/20");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDisk(TransactionLogger transactionLogger) {
        Object object;
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)"[/WlsTuxedoLoggable/onDisk/");
        }
        if (this.myType == 4) {
            if (this.tlg == null) {
                this.tlg = ((ServerTransactionManager)TxHelper.getTransactionManager()).getTransactionLogger();
            }
            object = new WlsTuxedoLoggable(this.myXid, 3);
            if (ntrace.getTraceLevel() == 1000372) {
                if (bl) {
                    ntrace.doTrace((String)"Committing on disk, prepared not removed, sleep 30 seconds");
                }
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (bl) {
                    ntrace.doTrace((String)"Finished sleeping");
                }
            }
            object.forget();
        }
        object = this.onDiskReply;
        synchronized (object) {
            this.gotDiskReply = true;
            this.onDiskReply.notify();
        }
        if (bl) {
            ntrace.doTrace((String)"]/WlsTuxedoLoggable/onDisk/10");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDisk() {
        Object object = this.onDiskReply;
        synchronized (object) {
            while (!this.gotDiskReply) {
                try {
                    this.onDiskReply.wait();
                }
                catch (InterruptedException interruptedException) {
                    this.gotDiskReply = false;
                    return;
                }
            }
            this.gotDiskReply = false;
        }
    }

    public void onError(TransactionLogger transactionLogger) {
    }

    public void onRecovery(TransactionLogger transactionLogger) {
        boolean bl = ntrace.isTraceEnabled((int)2);
        if (bl) {
            ntrace.doTrace((String)("[/WlsTuxedoLoggable/onRecovery/" + transactionLogger));
        }
        switch (this.myType) {
            case 0: {
                if (!bl) break;
                ntrace.doTrace((String)"IS_NONE");
                break;
            }
            case 1: {
                if (bl) {
                    ntrace.doTrace((String)"IS_READY");
                }
                if (this.myXid == null || this.remoteDomains == null || this.remoteDomains.length == 0) break;
                WTCService.addRecoveredXid(this.myXid, this.remoteDomains);
                WTCService.AddXidTLogMap(this.myXid, this);
                break;
            }
            case 2: {
                if (bl) {
                    ntrace.doTrace((String)"IS_COMMIT");
                }
                if (this.myXid == null || this.remoteDomains == null || this.remoteDomains.length == 0) break;
                WTCService.addCommittedXid(this.myXid, this.remoteDomains);
                break;
            }
            case 3: {
                if (bl) {
                    ntrace.doTrace((String)"IS_PREPARED");
                }
                if (this.myXid == null || this.remoteDomains == null || this.remoteDomains.length == 0) break;
                WTCService.addPreparedXid(this.myXid, this.remoteDomains[0], this);
                break;
            }
            case 4: {
                if (bl) {
                    ntrace.doTrace((String)"IS_COMMITTING");
                }
                if (this.myXid == null || this.remoteDomains == null || this.remoteDomains.length == 0) break;
                WTCService.addCommittingXid(this.myXid, this.remoteDomains[0], this);
                break;
            }
            default: {
                if (!bl) break;
                ntrace.doTrace((String)("Unknown type: " + this.myType));
            }
        }
        if (bl) {
            ntrace.doTrace((String)"]/WlsTuxedoLoggable/onRecovery/10");
        }
    }

    public Txid getTxid() {
        return this.myTxid;
    }

    public boolean equals(Object object) {
        if (this.myTxid == null && object != null) {
            return false;
        }
        if (this.myTxid != null && object == null) {
            return false;
        }
        if (object == null) {
            return this.myTxid == null && this.myType == 0;
        }
        if (!(object instanceof WlsTuxedoLoggable)) {
            return false;
        }
        WlsTuxedoLoggable wlsTuxedoLoggable = (WlsTuxedoLoggable)object;
        int n = wlsTuxedoLoggable.getType();
        if (n != this.myType) {
            return false;
        }
        Txid txid = wlsTuxedoLoggable.getTxid();
        return this.myTxid.equals((Object)txid);
    }

    public int hashCode() {
        if (this.myTxid == null) {
            return this.myType;
        }
        return this.myTxid.hashCode() + this.myType;
    }

    public void write() {
        if (this.tlg == null) {
            this.tlg = ((ServerTransactionManager)TxHelper.getTransactionManager()).getTransactionLogger();
        }
        this.tlg.store((TransactionLoggable)this);
    }

    public void forget() {
        if (this.tlg == null) {
            this.tlg = ((ServerTransactionManager)TxHelper.getTransactionManager()).getTransactionLogger();
        }
        this.tlg.release((TransactionLoggable)this);
    }
}

