/*
 * Decompiled with CFR 0.152.
 */
package weblogic.wtc.wls;

import com.bea.core.jatmi.common.ntrace;
import com.bea.core.jatmi.intf.TCAppKey;
import com.bea.core.jatmi.intf.TCAuthenticatedUser;
import java.security.AccessController;
import java.security.Principal;
import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import weblogic.ldap.EmbeddedLDAP;
import weblogic.security.WLSPrincipals;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.wtc.jatmi.DefaultUserRec;
import weblogic.wtc.jatmi.TPException;
import weblogic.wtc.jatmi.UserRec;

public final class ldapAppKey
implements TCAppKey {
    public static final String DFLT_UID_KW = "TUXEDO_UID";
    public static final String DFLT_GID_KW = "TUXEDO_GID";
    private int dfltAppKey;
    private boolean allowAnon;
    private String uid_key = "TUXEDO_UID=";
    private String gid_key = "TUXEDO_GID=";
    private String anon_user = null;
    private String domain;
    private String realm;
    private String passwd;
    private String host;
    private String base;
    private int port;
    private DefaultUserRec anonUserRec = null;
    private LDAPConnection ld;
    private boolean _cached = false;
    private static final int scope = 2;
    private static final boolean attrsonly = false;
    private static final String base_prefix = "ou=people";
    private static final String ou = ",ou=";
    private static final String dc = ",dc=";
    private static final String dflt_filter = "(objectclass=*)";
    private static final String filter_prefix = "uid=";
    private static final String[] attr_query = new String[]{"uid", "description", null};
    private static final String ANONAPPKEY_KW = "DefaultAppKey=";
    private static final String admin = "cn=Admin";
    private static final AuthenticatedSubject KERNELID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());

    public void init(String string, boolean bl, int n) throws TPException {
        boolean bl2 = ntrace.isTraceEnabled((int)4);
        if (bl2) {
            ntrace.doTrace((String)("[/ldapAppKey/init(param " + string + ", anonAllowed " + bl + ", dfltAppKey " + n + ")"));
        }
        if (string != null) {
            this.parseParam(string);
        }
        this.do_init();
        this.dfltAppKey = n;
        this.allowAnon = bl;
        if (this.allowAnon) {
            this.anonUserRec = new DefaultUserRec(this.anon_user, this.dfltAppKey);
        }
        if (bl2) {
            ntrace.doTrace((String)"]/ldapAppKey/init(10) return");
        }
    }

    private void do_init() throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)4);
        if (bl) {
            ntrace.doTrace((String)"[/ldapAppKey/do_init()");
        }
        this.realm = SecurityServiceManager.getDefaultRealmName();
        this.domain = EmbeddedLDAP.getEmbeddedLDAPDomain();
        this.passwd = EmbeddedLDAP.getEmbeddedLDAPCredential(KERNELID);
        this.host = EmbeddedLDAP.getEmbeddedLDAPHost();
        this.port = EmbeddedLDAP.getEmbeddedLDAPPort();
        if (ntrace.getTraceLevel() == 1000373) {
            ntrace.doTrace((String)("domain=" + this.domain + ", realm=" + this.realm + ", host=" + this.host + ", port=" + this.port));
        }
        StringBuffer stringBuffer = new StringBuffer(base_prefix).append(ou).append(this.realm);
        stringBuffer = stringBuffer.append(dc).append(this.domain);
        this.base = stringBuffer.toString();
        if (bl) {
            ntrace.doTrace((String)("search base: " + this.base));
        }
        try {
            this.ld = new LDAPConnection();
            this.ld.connect(3, this.host, this.port, admin, this.passwd);
        }
        catch (LDAPException lDAPException) {
            this.ld = null;
            if (bl) {
                ntrace.doTrace((String)"*]/ldapAppKey/do_init(10) return TPESYSTEM");
            }
            throw new TPException(12, "Failed to create LDAP connection object");
        }
        finally {
            if (this.passwd != null) {
                this.passwd = null;
            }
        }
        this.anon_user = WLSPrincipals.getAnonymousUsername();
        if (bl) {
            ntrace.doTrace((String)"]/ldapAppKey/do_init(20) return");
        }
    }

    public void uninit() throws TPException {
        boolean bl = ntrace.isTraceEnabled((int)4);
        if (bl) {
            ntrace.doTrace((String)"[/ldapAppKey/uninit()");
        }
        if (this.ld != null) {
            try {
                this.ld.disconnect();
            }
            catch (LDAPException lDAPException) {
                if (bl) {
                    ntrace.doTrace((String)"*]/ldapAppKey/uninit(10) return TPESYSTEM");
                }
                throw new TPException(12, "Failed to close LDAP connection");
            }
        }
        if (bl) {
            ntrace.doTrace((String)"]/ldapAppKey/uninit(20) return");
        }
    }

    public UserRec getTuxedoUserRecord(TCAuthenticatedUser tCAuthenticatedUser) {
        Object[] objectArray;
        boolean bl = ntrace.isTraceEnabled((int)4);
        if (bl) {
            ntrace.doTrace((String)("[/ldapAppKey/getTuxedoUserRecord(subj " + tCAuthenticatedUser + ")"));
        }
        if ((objectArray = tCAuthenticatedUser.getPrincipals()) == null || objectArray.length == 0) {
            if (this.allowAnon) {
                if (bl) {
                    ntrace.doTrace((String)("]/ldapAppKey/getTuxedoUserRecord(10) return anonymous user: " + this.anonUserRec));
                }
                return this.anonUserRec;
            }
            if (bl) {
                ntrace.doTrace((String)"]/ldapAppKey/uninit(20) return null");
            }
            return null;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Principal principal = (Principal)objectArray[i];
            String string = principal.getName();
            if (string.equals(this.anon_user)) {
                if (bl) {
                    ntrace.doTrace((String)("]/ldapAppKey/getTuxedoUserRecord(30) return anonymous user: " + this.anonUserRec));
                }
                return this.anonUserRec;
            }
            UserRec userRec = this.getUserRec(string);
            if (userRec == null) continue;
            if (bl) {
                ntrace.doTrace((String)("]/ldapAppKey/getTuxedoUserRecord(40) return user: " + userRec));
            }
            return userRec;
        }
        if (bl) {
            ntrace.doTrace((String)"]/ldapAppKey/getTuxedoUserRecord(50) return null");
        }
        return null;
    }

    private void parseParam(String string) {
        String string2;
        int n;
        boolean bl = ntrace.isTraceEnabled((int)4);
        if (bl) {
            ntrace.doTrace((String)("[/ldapAppKey/parseParam(param " + string + ")"));
        }
        if ((n = (string2 = string.trim()).indexOf(32)) != -1) {
            StringBuffer stringBuffer = new StringBuffer(string2.substring(0, n));
            stringBuffer.append('=');
            this.uid_key = new String(stringBuffer);
            String string3 = string2.substring(n + 1).trim();
            n = string3.indexOf(32);
            if (n != -1) {
                string2 = string3.substring(0, n);
            } else if (string3.length() != 0) {
                string2 = string3;
            }
            stringBuffer = new StringBuffer(string2);
            stringBuffer.append('=');
            this.gid_key = new String(stringBuffer);
        } else if (string2.length() != 0) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.append('=');
            this.uid_key = new String(stringBuffer);
        }
        if (bl) {
            ntrace.doTrace((String)("/ldapAppKey/parseParam/(uid_key " + this.uid_key + ", gid_key " + this.gid_key));
            ntrace.doTrace((String)"]/ldapAppKey/parseParam(10) return");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private UserRec getUserRec(String string) {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer(filter_prefix).append(string);
        String string2 = stringBuffer.toString();
        boolean bl = ntrace.isTraceEnabled((int)4);
        if (bl) {
            ntrace.doTrace((String)("[/ldapAppKey/getUserRec(username " + string + ")"));
        }
        if (this.ld == null) {
            try {
                this.do_init();
            }
            catch (TPException tPException) {
                if (!bl) return null;
                ntrace.doTrace((String)"]/ldapAppKey/getUserRec(5) return null");
                return null;
            }
        }
        boolean bl2 = true;
        block10: while (true) {
            if (!bl2) {
                if (!bl) return null;
                ntrace.doTrace((String)"]/ldapAppKey/getUserRec(60) return null");
                return null;
            }
            bl2 = false;
            try {
                LDAPSearchResults lDAPSearchResults = this.ld.search(this.base, 2, string2, attr_query, false);
                block11: while (true) {
                    if (!lDAPSearchResults.hasMoreElements()) continue block10;
                    LDAPEntry lDAPEntry = null;
                    lDAPEntry = lDAPSearchResults.next();
                    if (ntrace.getTraceLevel() == 1000373) {
                        ntrace.doTrace((String)("DN: " + lDAPEntry.getDN()));
                    }
                    LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
                    int n3 = 0;
                    while (true) {
                        Enumeration enumeration;
                        if (n3 >= lDAPAttributeSet.size()) continue block11;
                        LDAPAttribute lDAPAttribute = lDAPAttributeSet.elementAt(n3);
                        String string3 = lDAPAttribute.getName();
                        if (ntrace.getTraceLevel() == 1000373) {
                            ntrace.doTrace((String)(string3 + ':'));
                        }
                        if ((enumeration = lDAPAttribute.getStringValues()) != null) {
                            while (enumeration.hasMoreElements()) {
                                Integer n4;
                                String string4 = (String)enumeration.nextElement();
                                if (ntrace.getTraceLevel() == 1000373) {
                                    ntrace.doTrace((String)string4);
                                }
                                if (!string3.equals("description")) continue;
                                int n5 = string4.indexOf(this.uid_key);
                                if (n5 == -1) {
                                    if (!bl) return null;
                                    ntrace.doTrace((String)"]/ldapAppKey/getUserRec(20) return null");
                                    return null;
                                }
                                int n6 = string4.indexOf(32, n5 = string4.indexOf(61, n5) + 1);
                                String string5 = n6 != -1 ? string4.substring(n5, n6) : string4.substring(n5);
                                n6 = string5.indexOf(44);
                                String string6 = n6 != -1 || (n6 = string5.indexOf(59)) != -1 || (n6 = string5.indexOf(58)) != -1 ? string5.substring(0, n6) : string5;
                                try {
                                    n4 = new Integer(string6);
                                    n = n4;
                                    if (ntrace.getTraceLevel() == 1000373) {
                                        ntrace.doTrace((String)("uid = " + n));
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    if (!bl) return null;
                                    ntrace.doTrace((String)"]/ldapAppKey/getUserRec(10) return null");
                                    return null;
                                }
                                n5 = string4.indexOf(this.gid_key);
                                if (n5 == -1) {
                                    if (!bl) return null;
                                    ntrace.doTrace((String)"]/ldapAppKey/getUserRec(40) return null");
                                    return null;
                                }
                                n6 = string4.indexOf(32, n5 = string4.indexOf(61, n5) + 1);
                                string5 = n6 != -1 ? string4.substring(n5, n6) : string4.substring(n5);
                                n6 = string5.indexOf(44);
                                string6 = n6 != -1 || (n6 = string5.indexOf(59)) != -1 || (n6 = string5.indexOf(58)) != -1 ? string5.substring(n6) : string5;
                                try {
                                    n4 = new Integer(string6);
                                    n2 = n4;
                                    if (ntrace.getTraceLevel() == 1000373) {
                                        ntrace.doTrace((String)("gid = " + n2));
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    if (!bl) return null;
                                    ntrace.doTrace((String)"]/ldapAppKey/getUserRec(30) return null");
                                    return null;
                                }
                                int n7 = (n &= 0x1FFFF) | (n2 &= 0x3FFF) << 17;
                                if (!bl) return new DefaultUserRec(string, n7);
                                ntrace.doTrace((String)("]/ldapAppKey/getUserRec(50) return user: " + string + ", appkey " + n7));
                                return new DefaultUserRec(string, n7);
                            }
                        }
                        ++n3;
                    }
                    break;
                }
            }
            catch (LDAPException lDAPException) {
                int n8 = lDAPException.getLDAPResultCode();
                if (n8 != 81) continue;
                this.ld = null;
                try {
                    this.do_init();
                    bl2 = true;
                }
                catch (TPException tPException) {
                }
                continue;
            }
            break;
        }
    }

    public void doCache(boolean bl) {
        this._cached = bl;
    }

    public boolean isCached() {
        return this._cached;
    }
}

