/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;
import weblogic.xml.crypto.NodeSetDataImpl;
import weblogic.xml.crypto.URIDereferencerBase;
import weblogic.xml.crypto.api.Data;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.URIReference;
import weblogic.xml.crypto.api.URIReferenceException;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.api.dom.DOMSignContext;
import weblogic.xml.crypto.api.dom.DOMStructure;
import weblogic.xml.crypto.dom.WLDOMSignContext;
import weblogic.xml.crypto.dsig.api.XMLObject;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.SecurityTokenReferenceImpl;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.dom.ElementNode;

public class NodeURIDereferencer
extends URIDereferencerBase {
    private Node node;
    private Node contextNode;
    private final HashMap hmAttrNode = new HashMap();
    private List nodeList = new ArrayList();
    private boolean parsedFlag = false;

    public NodeURIDereferencer(Node node, Map map) {
        this.node = node;
        this.contextNode = node;
    }

    public NodeURIDereferencer(Node node) {
        this(node, null);
    }

    private void traverseOnlyOnce(Set set) {
        if (!this.parsedFlag) {
            this.hmAttrNode.clear();
            this.nodeList.clear();
            this.nodeList = DOMUtils.getNodeListAndIdAttrNodeMap(this.node, this.hmAttrNode, set, false);
            this.parsedFlag = true;
        }
    }

    private Set getNodeSet(List list, int n, int n2) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        if (list.size() > n && n2 <= list.size()) {
            for (int i = n; i < n2; ++i) {
                linkedHashSet.add(list.get(i));
            }
        }
        return linkedHashSet;
    }

    public Data dereference(URIReference uRIReference, XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
        Set set = (Set)xMLCryptoContext.getProperty("weblogic.xml.crypto.idqnames");
        String string = uRIReference.getURI();
        if (string == null || string.length() == 0) {
            this.contextNode = this.node;
            this.traverseOnlyOnce(set);
            return new NodeSetDataImpl(this.getNodeSet(this.nodeList, 0, this.nodeList.size()));
        }
        if (string.startsWith("#")) {
            try {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                String string2 = string.substring(1);
                if (xMLCryptoContext instanceof WLDOMSignContext) {
                    object4 = ((WLDOMSignContext)((Object)xMLCryptoContext)).getXMLSignature().getObjects();
                    if (object4 != null) {
                        object3 = object4.iterator();
                        while (object3.hasNext()) {
                            object2 = (XMLObject)object3.next();
                            if (!object2.getId().equals(string2)) continue;
                            LogUtils.logDsig("Resolved uri ref: " + string + "in Object list.");
                            List list = object2.getContent();
                            Node node = this.getNode((XMLObject)object2, xMLCryptoContext);
                            for (DOMStructure dOMStructure : list) {
                                Node node2 = dOMStructure.getNode();
                                node.appendChild(node2);
                            }
                            this.contextNode = node;
                            return new NodeSetDataImpl(DOMUtils.getNodeSet(node, false));
                        }
                    }
                    if ((object3 = ((WLDOMSignContext)((Object)xMLCryptoContext)).getXMLSignature().getKeyInfo()) != null) {
                        object2 = object3.getContent();
                        object = object2.iterator();
                        while (object.hasNext()) {
                            SecurityTokenReference securityTokenReference;
                            Object e = object.next();
                            if (!(e instanceof SecurityTokenReference) || !string2.equals((securityTokenReference = (SecurityTokenReference)e).getId())) continue;
                            Node node = SecurityTokenReferenceImpl.getStrNode(securityTokenReference);
                            return new NodeSetDataImpl(DOMUtils.getNodeSet(node, false));
                        }
                    }
                }
                this.traverseOnlyOnce(set);
                object4 = (int[])this.hmAttrNode.get(string2);
                if (object4 != null) {
                    return new NodeSetDataImpl(this.getNodeSet(this.nodeList, (int)object4[0], (int)object4[1]));
                }
                object3 = (Node)xMLCryptoContext.getProperty("weblogic.wsee.security.signature_node");
                if (null != object3) {
                    object2 = new HashMap();
                    object = DOMUtils.getNodeListAndIdAttrNodeMap((Node)object3, object2, set, false);
                    object4 = (int[])((HashMap)object2).get(string2);
                    if (object4 != null) {
                        return new NodeSetDataImpl(this.getNodeSet((List)object, (int)object4[0], (int)object4[1]));
                    }
                }
                throw new URIReferenceException("Failed to dereference URI " + string);
            }
            catch (MarshalException marshalException) {
                throw new URIReferenceException(marshalException);
            }
        }
        return super.dereference(uRIReference, xMLCryptoContext);
    }

    private Node getNode(XMLObject xMLObject, XMLCryptoContext xMLCryptoContext) {
        String string = ((DOMSignContext)xMLCryptoContext).getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "dsig");
        ElementNode elementNode = new ElementNode("http://www.w3.org/2000/09/xmldsig#", "Object", string);
        elementNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:dsig", "http://www.w3.org/2000/09/xmldsig#");
        elementNode.setAttributeNS(null, "Id", xMLObject.getId());
        return elementNode;
    }

    public Node getNode() {
        return this.node;
    }

    public Node getContextNode() {
        return this.contextNode;
    }

    public static final void resetParsedFlag(WSSecurityContext wSSecurityContext) {
        if (wSSecurityContext != null && wSSecurityContext.getURIDereferencer() instanceof NodeURIDereferencer) {
            NodeURIDereferencer nodeURIDereferencer = (NodeURIDereferencer)wSSecurityContext.getURIDereferencer();
            nodeURIDereferencer.parsedFlag = false;
            LogUtils.logWss("refresh nodeList once!");
        }
    }
}

