/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import weblogic.xml.crypto.NodeURIDereferencer;
import weblogic.xml.crypto.dom.WLDOMSignContextImpl;
import weblogic.xml.crypto.dom.WLDOMValidateContextImpl;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.api.SignedInfo;
import weblogic.xml.crypto.dsig.api.XMLSignature;
import weblogic.xml.crypto.dsig.api.XMLSignatureFactory;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfo;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfoFactory;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyValue;
import weblogic.xml.dom.Util;

public class Test {
    public static void main(String[] stringArray) {
        System.setProperty("weblogic.xml.crypto.dsig.api.XMLSignatureFactory", "weblogic.xml.crypto.dsig.XMLSignatureFactoryImpl");
        try {
            Test.testCreateXMLDetachedSignature();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void testSignatureFactory() {
        try {
            XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance();
            System.out.println(xMLSignatureFactory);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void testCreateXMLDetachedSignature() throws Exception {
        XMLSignatureFactory xMLSignatureFactory = XMLSignatureFactory.getInstance();
        Reference reference = xMLSignatureFactory.newReference("http://www.w3.org/TR/xml-stylesheet", xMLSignatureFactory.newDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", null));
        SignedInfo signedInfo = xMLSignatureFactory.newSignedInfo(xMLSignatureFactory.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", null), xMLSignatureFactory.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1", null), Collections.singletonList(reference));
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("DSA");
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        KeyInfoFactory keyInfoFactory = xMLSignatureFactory.getKeyInfoFactory();
        KeyValue keyValue = keyInfoFactory.newKeyValue(keyPair.getPublic());
        KeyInfo keyInfo = keyInfoFactory.newKeyInfo(Collections.singletonList(keyValue));
        XMLSignature xMLSignature = xMLSignatureFactory.newXMLSignature(signedInfo, keyInfo);
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element element = document.createElementNS("http://foo.com", "foo:root");
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:foo", "http://foo.com");
        document.appendChild(element);
        WLDOMSignContextImpl wLDOMSignContextImpl = new WLDOMSignContextImpl(keyPair.getPrivate(), element);
        NodeURIDereferencer nodeURIDereferencer = new NodeURIDereferencer(document);
        wLDOMSignContextImpl.setURIDereferencer(nodeURIDereferencer);
        System.out.println("signing...");
        xMLSignature.sign(wLDOMSignContextImpl);
        System.out.println("done");
        String string = Util.printNode(document);
        System.out.println(string);
        WLDOMValidateContextImpl wLDOMValidateContextImpl = new WLDOMValidateContextImpl(keyPair.getPublic(), element.getFirstChild());
        wLDOMValidateContextImpl.setURIDereferencer(nodeURIDereferencer);
        System.out.println("unmarshalling...");
        xMLSignature = xMLSignatureFactory.unmarshalXMLSignature(wLDOMValidateContextImpl);
        System.out.println("done");
        System.out.println("validating...");
        boolean bl = xMLSignature.validate(wLDOMValidateContextImpl);
        System.out.println("Signature core validation result: " + bl);
        Iterator iterator = xMLSignature.getSignedInfo().getReferences().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            boolean bl2 = ((Reference)iterator.next()).validate(wLDOMValidateContextImpl).status();
            System.out.println("ref[" + n + "] validity status: " + bl2);
            ++n;
        }
        System.out.println("done");
    }
}

