/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto;

import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class URIDereferenceUtils {
    public static Node findNodeById(String string, Set set, Node node) {
        Node node2 = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && (node2 = URIDereferenceUtils.findNodeByIdQName(string, (QName)iterator.next(), node)) == null) {
        }
        return node2;
    }

    public static Node findNodeByIdQName(String string, QName qName, Node node) {
        NodeList nodeList;
        int n;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            int n2 = namedNodeMap.getLength();
            for (n = 0; n < n2; ++n) {
                Node node2 = namedNodeMap.item(n);
                if (!URIDereferenceUtils.namespacesMatch(node2, qName) || !URIDereferenceUtils.localNamesMatch(node2, qName) || !node2.getNodeValue().equals(string)) continue;
                return node;
            }
        }
        if ((nodeList = node.getChildNodes()) != null) {
            n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node3 = URIDereferenceUtils.findNodeByIdQName(string, qName, nodeList.item(i));
                if (node3 == null) continue;
                return node3;
            }
        }
        return null;
    }

    private static boolean localNamesMatch(Node node, QName qName) {
        String string = node.getLocalName();
        if (string == null) {
            string = node.getNodeName();
        }
        return qName.getLocalPart().equals(string);
    }

    private static boolean namespacesMatch(Node node, QName qName) {
        String string = node.getNamespaceURI();
        String string2 = qName.getNamespaceURI();
        if (URIDereferenceUtils.isEmptyNamespace(string) && URIDereferenceUtils.isEmptyNamespace(string2)) {
            return true;
        }
        return string != null && string.equals(string2);
    }

    private static boolean isEmptyNamespace(String string) {
        return string == null || "".equals(string);
    }
}

