/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.api;

import java.security.Key;
import weblogic.xml.crypto.api.AlgorithmMethod;
import weblogic.xml.crypto.api.KeySelectorException;
import weblogic.xml.crypto.api.KeySelectorResult;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfo;

public abstract class KeySelector {
    private Key key;

    protected KeySelector() {
    }

    private KeySelector(Key key) {
        this.key = key;
    }

    public abstract KeySelectorResult select(KeyInfo var1, Purpose var2, AlgorithmMethod var3, XMLCryptoContext var4) throws KeySelectorException;

    public static KeySelector singletonKeySelector(Key key) {
        final Key key2 = key;
        return new KeySelector(){

            public KeySelectorResult select(KeyInfo keyInfo, Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) {
                return new KeySelectorResult(){

                    public Key getKey() {
                        return key2;
                    }
                };
            }
        };
    }

    public static class Purpose {
        private String purpose;
        public static Purpose DECRYPT = new Purpose("decrypt");
        public static Purpose ENCRYPT = new Purpose("encrypt");
        public static Purpose SIGN = new Purpose("sign");
        public static Purpose VERIFY = new Purpose("verify");

        private Purpose(String string) {
            this.purpose = string;
        }

        public String toString() {
            return this.purpose;
        }
    }
}

