/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.common.keyinfo;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.KeySelectorResult;
import weblogic.xml.crypto.common.keyinfo.KeyProvider;
import weblogic.xml.crypto.utils.KeyUtils;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;

public abstract class BaseKeyProvider
implements KeyProvider {
    private final byte[] identifier;
    private final String name;
    private final Collection uri;
    private final SecurityToken token;

    protected BaseKeyProvider(String string, byte[] byArray, String string2) {
        this(string, byArray, Collections.singleton(string2));
    }

    protected BaseKeyProvider(String string, byte[] byArray, Collection collection) {
        this(string, byArray, collection, null);
    }

    protected BaseKeyProvider(String string, byte[] byArray, String string2, SecurityToken securityToken) {
        this(string, byArray, Collections.singleton(string2), securityToken);
    }

    protected BaseKeyProvider(String string, byte[] byArray, Collection collection, SecurityToken securityToken) {
        this.name = string;
        this.identifier = byArray;
        this.uri = collection;
        this.token = securityToken;
    }

    public KeySelectorResult getKeyByIdentifier(byte[] byArray, String string, KeySelector.Purpose purpose) {
        if (KeyUtils.matches(byArray, this.identifier)) {
            return this.getKey(string, purpose);
        }
        return null;
    }

    public KeySelectorResult getKeyByName(String string, String string2, KeySelector.Purpose purpose) {
        if (string != null && string.equals(this.name)) {
            return this.getKey(string2, purpose);
        }
        return null;
    }

    public KeySelectorResult getKeyByURI(String string, String string2, KeySelector.Purpose purpose) {
        if (this.uri.contains(string)) {
            return this.getKey(string2, purpose);
        }
        return null;
    }

    public KeySelectorResult getKeyBySubjectName(String string, String string2, KeySelector.Purpose purpose) {
        return null;
    }

    public KeySelectorResult getKeyByIssuerSerial(String string, BigInteger bigInteger, String string2, KeySelector.Purpose purpose) {
        return null;
    }

    public KeySelectorResult getKeyBySTR(SecurityTokenReference securityTokenReference, String string, KeySelector.Purpose purpose) {
        return null;
    }

    public byte[] getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getUri() {
        return this.uri == null || this.uri.isEmpty() ? null : (String)this.uri.iterator().next();
    }

    public SecurityToken getSecurityToken() {
        return this.token;
    }

    public String toString() {
        return this.getClass() + "{" + "identifier=" + (this.identifier == null ? null : "length:" + this.identifier.length) + ", name='" + this.name + "'" + ", uri='" + (this.uri == null || this.uri.isEmpty() ? "" : Arrays.deepToString(this.uri.toArray())) + "'" + "}";
    }
}

