/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.common.keyinfo;

import java.math.BigInteger;
import java.security.Key;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.KeySelectorResult;
import weblogic.xml.crypto.common.keyinfo.KeypairProvider;
import weblogic.xml.crypto.common.keyinfo.X509KeySelectorResult;
import weblogic.xml.crypto.wss.BSTUtils;
import weblogic.xml.crypto.wss.api.BinarySecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.security.utils.Utils;

public class CertificateKeyProvider
extends KeypairProvider {
    private final X509Certificate cert;

    public CertificateKeyProvider(X509Certificate x509Certificate, PrivateKey privateKey, String string, String string2) {
        this(x509Certificate, privateKey, string, string2, null);
    }

    public CertificateKeyProvider(X509Certificate x509Certificate, PrivateKey privateKey, String string, String string2, SecurityToken securityToken) {
        super(x509Certificate.getPublicKey(), privateKey, string, Utils.getSubjectKeyIdentifier(x509Certificate), string2, securityToken);
        this.cert = x509Certificate;
    }

    public CertificateKeyProvider(BinarySecurityToken binarySecurityToken, String string, String string2) {
        this(binarySecurityToken.getCertificate(), binarySecurityToken.getPrivateKey(), string, string2, binarySecurityToken);
    }

    public KeySelectorResult getKeyBySubjectName(String string, String string2, KeySelector.Purpose purpose) {
        if (string == null) {
            throw new IllegalArgumentException("SubjectName cannot be null");
        }
        Principal principal = this.cert.getSubjectDN();
        String string3 = principal.getName();
        if (string.equals(string3)) {
            return this.getKey(string2, purpose);
        }
        return null;
    }

    public KeySelectorResult getKeyByIdentifier(byte[] byArray, String string, KeySelector.Purpose purpose) {
        KeySelectorResult keySelectorResult = super.getKeyByIdentifier(byArray, string, purpose);
        if (keySelectorResult == null && BSTUtils.matchesThumbprint(this.cert, byArray)) {
            return this.getKey(string, purpose);
        }
        return keySelectorResult;
    }

    public KeySelectorResult getKeyByIssuerSerial(String string, BigInteger bigInteger, String string2, KeySelector.Purpose purpose) {
        if (string == null) {
            throw new IllegalArgumentException("IssuerName cannot be null");
        }
        if (bigInteger == null) {
            throw new IllegalArgumentException("Serial number cannot be null");
        }
        BigInteger bigInteger2 = this.cert.getSerialNumber();
        if (!bigInteger.equals(bigInteger2)) {
            return null;
        }
        if (!BSTUtils.matches(string, this.cert)) {
            return null;
        }
        return this.getKey(string2, purpose);
    }

    public KeySelectorResult getKeyByName(String string, String string2, KeySelector.Purpose purpose) {
        return this.getKeyBySubjectName(string, string2, purpose);
    }

    protected KeySelectorResult getResult(Key key) {
        X509KeySelectorResult x509KeySelectorResult = new X509KeySelectorResult(key, this.cert);
        x509KeySelectorResult.setSecurityToken(this.getSecurityToken());
        return x509KeySelectorResult;
    }
}

