/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.common.keyinfo;

import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.KeySelectorResult;
import weblogic.xml.crypto.common.keyinfo.BaseKeyProvider;
import weblogic.xml.crypto.common.keyinfo.KeySelectorResultImpl;
import weblogic.xml.crypto.encrypt.WLCipherData;
import weblogic.xml.crypto.encrypt.api.EncryptionMethod;
import weblogic.xml.crypto.encrypt.api.XMLDecryptContext;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionFactory;
import weblogic.xml.crypto.encrypt.api.keyinfo.EncryptedKey;
import weblogic.xml.crypto.encrypt.api.spec.EncryptionMethodParameterSpec;
import weblogic.xml.crypto.utils.KeyUtils;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.security.keyinfo.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncryptedKeyProvider
extends BaseKeyProvider {
    private static final String HASH_FUNCTION_SHA_256 = "SHA-256";
    private static final String HASH_FUNCTION_SHA_1 = "SHA-1";
    private EncryptedKey encryptedKey;
    private XMLDecryptContext cryptoCtx;
    private Key key;
    private KeySelectorResultImpl ksr;
    private static Map keySizes = new HashMap();
    public static final String DEFAULT_GENKEY_ALG = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";

    public EncryptedKeyProvider(EncryptedKey encryptedKey, Key key, SecurityToken securityToken) throws XMLEncryptionException {
        super(encryptedKey.getCarriedKeyName(), EncryptedKeyProvider.getKeyIdentifier(encryptedKey), EncryptedKeyProvider.getUri(encryptedKey.getId()), securityToken);
        this.key = key;
        this.encryptedKey = encryptedKey;
    }

    public EncryptedKeyProvider(EncryptedKey encryptedKey, Key key) throws XMLEncryptionException {
        this(encryptedKey, (XMLDecryptContext)null);
        this.key = key;
    }

    public EncryptedKeyProvider(EncryptedKey encryptedKey, SecurityToken securityToken, XMLDecryptContext xMLDecryptContext) throws XMLEncryptionException {
        super(encryptedKey.getCarriedKeyName(), EncryptedKeyProvider.getKeyIdentifier(encryptedKey), EncryptedKeyProvider.getUri(encryptedKey.getId()), securityToken);
        this.encryptedKey = encryptedKey;
        this.cryptoCtx = xMLDecryptContext;
    }

    public EncryptedKeyProvider(EncryptedKey encryptedKey, XMLDecryptContext xMLDecryptContext) throws XMLEncryptionException {
        super(encryptedKey.getCarriedKeyName(), EncryptedKeyProvider.getKeyIdentifier(encryptedKey), EncryptedKeyProvider.getUri(encryptedKey.getId()));
        this.encryptedKey = encryptedKey;
        this.cryptoCtx = xMLDecryptContext;
    }

    public static List<byte[]> getKeyIdentifiers(EncryptedKey encryptedKey) throws XMLEncryptionException {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        arrayList.add(EncryptedKeyProvider.getKeyIdentifier(encryptedKey, HASH_FUNCTION_SHA_256));
        arrayList.add(EncryptedKeyProvider.getKeyIdentifier(encryptedKey, HASH_FUNCTION_SHA_1));
        return arrayList;
    }

    public static byte[] getKeyIdentifier(EncryptedKey encryptedKey) throws XMLEncryptionException {
        return EncryptedKeyProvider.getKeyIdentifier(encryptedKey, HASH_FUNCTION_SHA_1);
    }

    private static byte[] getKeyIdentifier(EncryptedKey encryptedKey, String string) throws XMLEncryptionException {
        byte[] byArray = ((WLCipherData)encryptedKey.getCipherData()).getCipherBytes();
        if (byArray != null) {
            return EncryptedKeyProvider.getDigest(byArray, string);
        }
        return null;
    }

    private static byte[] getDigest(byte[] byArray, String string) {
        MessageDigest messageDigest = null;
        byte[] byArray2 = null;
        try {
            messageDigest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                messageDigest = MessageDigest.getInstance(HASH_FUNCTION_SHA_1);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                throw new RuntimeException(noSuchAlgorithmException2);
            }
        }
        messageDigest.update(byArray);
        byArray2 = messageDigest.digest();
        return byArray2;
    }

    @Override
    public KeySelectorResult getKeyByIdentifier(byte[] byArray, String string, KeySelector.Purpose purpose) {
        KeySelectorResult keySelectorResult = super.getKeyByIdentifier(byArray, string, purpose);
        if (keySelectorResult == null) {
            List<byte[]> list = null;
            try {
                list = EncryptedKeyProvider.getKeyIdentifiers(this.encryptedKey);
            }
            catch (XMLEncryptionException xMLEncryptionException) {
                throw new RuntimeException(xMLEncryptionException);
            }
            for (byte[] byArray2 : list) {
                if (!KeyUtils.matches(byArray, byArray2)) continue;
                keySelectorResult = this.getKey(string, purpose);
                break;
            }
        }
        return keySelectorResult;
    }

    @Override
    public KeySelectorResult getKey(String string, KeySelector.Purpose purpose) {
        String string2 = "Could not derive key from encrypted key for requested algorithm";
        KeySelectorResultImpl keySelectorResultImpl = null;
        if (this.key == null) {
            try {
                XMLEncryptionFactory xMLEncryptionFactory = XMLEncryptionFactory.getInstance();
                EncryptionMethodParameterSpec encryptionMethodParameterSpec = null;
                EncryptionMethod encryptionMethod = null;
                encryptionMethod = KeySelector.Purpose.VERIFY.equals(purpose) ? XMLEncryptionFactory.getInstance().newEncryptionMethod(DEFAULT_GENKEY_ALG, null, null) : xMLEncryptionFactory.newEncryptionMethod(string, null, encryptionMethodParameterSpec);
                this.key = this.encryptedKey.decryptKey(this.cryptoCtx, encryptionMethod);
                keySelectorResultImpl = (KeySelectorResultImpl)this.cryptoCtx.getProperty("weblogic.xml.crypto.ksr");
            }
            catch (XMLEncryptionException xMLEncryptionException) {
                string2 = string2 + ". Cause: " + xMLEncryptionException.getMessage();
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                string2 = string2 + ". Cause: " + invalidAlgorithmParameterException.getMessage();
            }
        }
        if (this.key != null && Utils.supports(Utils.getAlgorithms(this.key), string) && KeyUtils.serves(KeyUtils.getPurposes(this.key), purpose)) {
            this.ksr = new KeySelectorResultImpl(this.key);
            if (purpose.equals(KeySelector.Purpose.SIGN) || purpose.equals(KeySelector.Purpose.VERIFY)) {
                this.ksr.setSecurityToken(this.getSecurityToken());
            } else if (keySelectorResultImpl != null) {
                this.ksr.setSecurityToken(keySelectorResultImpl.getSecurityToken());
            } else {
                this.ksr.setSecurityToken(this.getSecurityToken());
            }
            return this.ksr;
        }
        string2 = string2 + " because encrypted key doesn't support required " + "algorithm or purpose.";
        LogUtils.logKeyInfo(string2);
        return null;
    }

    private static String getUri(String string) {
        return string != null ? "#" + string : null;
    }

    static {
        keySizes.put("http://www.w3.org/2001/04/xmlenc#kw-aes128", new Integer(128));
        keySizes.put("http://www.w3.org/2001/04/xmlenc#kw-aes192", new Integer(192));
        keySizes.put("http://www.w3.org/2001/04/xmlenc#kw-aes256", new Integer(256));
        keySizes.put("http://www.w3.org/2001/04/xmlenc#kw-tripledes", new Integer(192));
        keySizes.put("http://www.w3.org/2001/04/xmlenc#aes128-cbc", new Integer(128));
        keySizes.put("http://www.w3.org/2001/04/xmlenc#aes192-cbc", new Integer(192));
        keySizes.put(DEFAULT_GENKEY_ALG, new Integer(256));
        keySizes.put("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", new Integer(192));
    }
}

