/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.common.keyinfo;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import weblogic.xml.crypto.common.keyinfo.CertificateKeyProvider;
import weblogic.xml.crypto.common.keyinfo.KeyProvider;
import weblogic.xml.crypto.common.keyinfo.KeypairProvider;
import weblogic.xml.crypto.wss.api.BinarySecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityToken;

public class KeyProviderFactory {
    public static KeyProvider create(PrivateKey privateKey) {
        return new KeypairProvider(null, privateKey, null, null, null, null);
    }

    public static KeyProvider create(BinarySecurityToken binarySecurityToken) {
        return new CertificateKeyProvider(binarySecurityToken.getCertificate(), binarySecurityToken.getPrivateKey(), null, KeyProviderFactory.getURI(binarySecurityToken), binarySecurityToken);
    }

    public static KeyProvider create(X509Certificate x509Certificate, PrivateKey privateKey) {
        KeyProvider keyProvider = x509Certificate == null ? KeyProviderFactory.create(privateKey) : new CertificateKeyProvider(x509Certificate, privateKey, null, null, null);
        return keyProvider;
    }

    private static String getURI(SecurityToken securityToken) {
        String string = securityToken.getId();
        String string2 = string != null ? "#" + securityToken.getId() : null;
        return string2;
    }
}

