/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.common.keyinfo;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import org.w3c.dom.Element;
import weblogic.security.service.ContextHandler;
import weblogic.wsee.security.wssc.v200502.WSCConstants;
import weblogic.xml.crypto.api.AlgorithmMethod;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.KeySelectorException;
import weblogic.xml.crypto.api.KeySelectorResult;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.common.keyinfo.KeyProvider;
import weblogic.xml.crypto.common.keyinfo.KeySelectorResultImpl;
import weblogic.xml.crypto.common.keyinfo.SecretKeyProvider;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfo;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyName;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyValue;
import weblogic.xml.crypto.dsig.api.keyinfo.X509IssuerSerial;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionException;
import weblogic.xml.crypto.encrypt.api.XMLEncryptionFactory;
import weblogic.xml.crypto.encrypt.api.dom.DOMDecryptContext;
import weblogic.xml.crypto.encrypt.api.keyinfo.EncryptedKey;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.utils.KeyUtils;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.SecurityImpl;
import weblogic.xml.crypto.wss.SecurityTokenContextHandler;
import weblogic.xml.crypto.wss.SecurityTokenValidateResult;
import weblogic.xml.crypto.wss.WSSConstants;
import weblogic.xml.crypto.wss.WSSecurityContext;
import weblogic.xml.crypto.wss.WSSecurityException;
import weblogic.xml.crypto.wss.WSSecurityInfo;
import weblogic.xml.crypto.wss.api.KeyIdentifier;
import weblogic.xml.crypto.wss.provider.CredentialProvider;
import weblogic.xml.crypto.wss.provider.Purpose;
import weblogic.xml.crypto.wss.provider.SecurityToken;
import weblogic.xml.crypto.wss.provider.SecurityTokenHandler;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;
import weblogic.xml.security.utils.Utils;

public class KeyResolver
extends KeySelector {
    public static final String VERBOSE_PROPERTY = "weblogic.xml.crypto.keyinfo.verbose";
    public static final boolean VERBOSE = Boolean.getBoolean("weblogic.xml.crypto.keyinfo.verbose");
    private static final boolean DEBUG = false;
    private final List keyProviders;
    protected static Accessor BY_ALG_AND_PURPOSE = new Accessor(){

        public KeySelectorResult getKey(Object object, String string, KeySelector.Purpose purpose, KeyProvider keyProvider) {
            LogUtils.logKeyInfo("Trying to select key by mechanism: BY_ALG_AND_PURPOSE");
            LogUtils.logKeyInfo("ALG: " + string + "purpose: " + purpose);
            return keyProvider.getKey(string, purpose);
        }
    };
    protected static Accessor BY_TOKEN_REFERENCE = new Accessor(){

        public KeySelectorResult getKey(Object object, String string, KeySelector.Purpose purpose, KeyProvider keyProvider) {
            LogUtils.logKeyInfo("Trying to select key by mechanism: BY_TOKEN_REFERENCE");
            SecurityTokenReference securityTokenReference = (SecurityTokenReference)object;
            KeySelectorResult keySelectorResult = null;
            String string2 = securityTokenReference.getReferenceURI();
            if (string2 != null) {
                LogUtils.logKeyInfo("Trying to select key by uri " + string2);
                keySelectorResult = keyProvider.getKeyByURI(string2, string, purpose);
            }
            if (keySelectorResult != null) {
                LogUtils.logKeyInfo("Key selected by URI");
                return keySelectorResult;
            }
            KeyIdentifier keyIdentifier = securityTokenReference.getKeyIdentifier();
            if (keyIdentifier != null) {
                LogUtils.logKeyInfo("Trying to select key by KeyIdentifier " + Utils.base64(keyIdentifier.getIdentifier()));
                keySelectorResult = keyProvider.getKeyByIdentifier(keyIdentifier.getIdentifier(), string, purpose);
            }
            if (keySelectorResult != null) {
                LogUtils.logKeyInfo("Key selected by KeyIdentifier");
                return keySelectorResult;
            }
            X509IssuerSerial x509IssuerSerial = securityTokenReference.getIssuerSerial();
            if (x509IssuerSerial != null) {
                String string3 = x509IssuerSerial.getIssuerName();
                BigInteger bigInteger = x509IssuerSerial.getSerialNumber();
                LogUtils.logKeyInfo("Trying to select key by IssuerSerial " + string3 + ", " + bigInteger);
                keySelectorResult = keyProvider.getKeyByIssuerSerial(string3, bigInteger, string, purpose);
            }
            if (keySelectorResult != null) {
                LogUtils.logKeyInfo("Key selected by KeyIdentifier");
                return keySelectorResult;
            }
            keySelectorResult = keyProvider.getKeyBySTR(securityTokenReference, string, purpose);
            return keySelectorResult;
        }
    };
    protected static Accessor BY_KEY_NAME = new Accessor(){

        public KeySelectorResult getKey(Object object, String string, KeySelector.Purpose purpose, KeyProvider keyProvider) {
            LogUtils.logKeyInfo("Trying to select key by mechanism: BY_KEY_NAME");
            String string2 = (String)object;
            return keyProvider.getKeyByName(string2, string, purpose);
        }
    };

    private KeyResolver(List list) {
        this.keyProviders = list;
    }

    public KeyResolver() {
        this(new ArrayList());
    }

    public KeyResolver(KeyProvider[] keyProviderArray) {
        this(new ArrayList());
        for (int i = 0; i < keyProviderArray.length; ++i) {
            KeyProvider keyProvider = keyProviderArray[i];
            this.keyProviders.add(keyProvider);
        }
    }

    public KeyResolver copy() {
        ArrayList arrayList = new ArrayList(this.keyProviders);
        return new KeyResolver(arrayList);
    }

    public void addKeyProvider(KeyProvider keyProvider) {
        if (keyProvider == null) {
            throw new IllegalArgumentException("Provider cannot be null");
        }
        this.keyProviders.add(0, keyProvider);
    }

    public boolean removeKeyProvider(KeyProvider keyProvider) {
        return this.keyProviders.remove(keyProvider);
    }

    public KeyProvider[] getKeyProviders() {
        KeyProvider[] keyProviderArray = new KeyProvider[this.keyProviders.size()];
        this.keyProviders.toArray(keyProviderArray);
        return keyProviderArray;
    }

    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        String string = algorithmMethod.getAlgorithm();
        KeyProvider[] keyProviderArray = this.getKeyProviders();
        this.log(string, purpose, keyInfo, keyProviderArray);
        if (keyInfo != null) {
            LogUtils.logKeyInfo("Trying to get key using KeyInfo");
            List list = keyInfo.getContent();
            for (int i = 0; i < list.size(); ++i) {
                Object object;
                KeySelectorResult keySelectorResult;
                Object e = list.get(i);
                if (e instanceof EncryptedKey) {
                    return this.getKeyFromEncryptedKey((EncryptedKey)e, algorithmMethod, xMLCryptoContext);
                }
                if (e instanceof SecurityTokenReference) {
                    return this.getKeyFromSTR((SecurityTokenReference)e, xMLCryptoContext, purpose, string);
                }
                if (e instanceof KeyName && (keySelectorResult = this.getKeyByKeyName((KeyName)e, purpose, string, xMLCryptoContext, (WSSecurityContext)(object = this.getSecurityContext(xMLCryptoContext)))) != null) {
                    return keySelectorResult;
                }
                if (!(e instanceof KeyValue) || (object = this.getKeyFromKeyValue((KeyValue)e, purpose, string)) == null) continue;
                return object;
            }
        }
        LogUtils.logKeyInfo("No key found using KeyInfo");
        return this.getKey((Object)null, BY_ALG_AND_PURPOSE, string, purpose, this.getKeyProviders());
    }

    private KeySelectorResult getKeyFromKeyValue(KeyValue keyValue, KeySelector.Purpose purpose, String string) throws KeySelectorException {
        try {
            PublicKey publicKey = keyValue.getPublicKey();
            LogUtils.logKeyInfo("Trying to get key from public key" + publicKey);
            if (KeyUtils.serves(KeyUtils.getPurposes(publicKey), purpose) && KeyUtils.supports(KeyUtils.getAlgorithms(publicKey), string)) {
                LogUtils.logKeyInfo("Selecting key by mechanism: public key from KeyInfo");
                return new KeySelectorResultImpl(publicKey);
            }
        }
        catch (KeyException keyException) {
            throw new KeySelectorException("Failed to get public key from KeyValue.", keyException);
        }
        LogUtils.logKeyInfo("No key found using KeyInfo KeyValue");
        return null;
    }

    private KeySelectorResult getKeyByKeyName(KeyName keyName, KeySelector.Purpose purpose, String string, XMLCryptoContext xMLCryptoContext, WSSecurityContext wSSecurityContext) throws KeySelectorException {
        KeySelectorResult keySelectorResult;
        if (wSSecurityContext != null) {
            this.setupKeyNameKeyProvider(keyName.getName(), purpose, wSSecurityContext, xMLCryptoContext);
        }
        if ((keySelectorResult = this.getKey(keyName.getName(), BY_KEY_NAME, string, purpose, this.getKeyProviders())) == null) {
            LogUtils.logKeyInfo("No key found using KeyInfo KeyName.");
        }
        return keySelectorResult;
    }

    private void setupKeyNameKeyProvider(String string, KeySelector.Purpose purpose, WSSecurityContext wSSecurityContext, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        try {
            Object object;
            Object object2 = null;
            String string2 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
            Object object3 = wSSecurityContext.getTokenHandler(string2);
            if (object3 != null) {
                object2 = this.getCredential("weblogic.xml.crypto.keyinfo.keyname", string, string2, Purpose.convert(purpose), wSSecurityContext);
            }
            if (object2 == null) {
                string2 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1";
                object = object3;
                object3 = wSSecurityContext.getTokenHandler(string2);
                if (object3 != null) {
                    object2 = this.getCredential("weblogic.xml.crypto.keyinfo.keyname", string, string2, Purpose.convert(purpose), wSSecurityContext);
                } else {
                    object3 = object;
                }
            }
            if (object3 != null && object2 != null) {
                object = object3.getSecurityToken(string2, object2, null);
                MessageContext messageContext = (MessageContext)xMLCryptoContext.getProperty("javax.xml.rpc.handler.MessageContext");
                this.validateAndAddToken((SecurityTokenHandler)object3, (SecurityToken)object, messageContext, purpose, wSSecurityContext);
                KeyProvider keyProvider = object3.getKeyProvider((SecurityToken)object, messageContext);
                this.addKeyProvider(keyProvider);
            }
        }
        catch (WSSecurityException wSSecurityException) {
            throw new KeySelectorException("Failed to resolve key using KeyName " + string, wSSecurityException);
        }
    }

    private void log(String string, KeySelector.Purpose purpose, KeyInfo keyInfo, KeyProvider[] keyProviderArray) {
        if (VERBOSE) {
            LogUtils.logKeyInfo("Selecting key for\nalgorithm: " + string + "\npurpose: " + purpose + "\nKeyInfo: " + keyInfo + "\nfrom providers: ");
            for (int i = 0; i < keyProviderArray.length; ++i) {
                KeyProvider keyProvider = keyProviderArray[i];
                if (keyProvider == null) continue;
                LogUtils.logKeyInfo(keyProvider.toString());
            }
        }
    }

    private KeySelectorResult getKeyFromEncryptedKey(EncryptedKey encryptedKey, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        Key key;
        DOMDecryptContext dOMDecryptContext = new DOMDecryptContext(xMLCryptoContext.getKeySelector(), null);
        try {
            key = encryptedKey.decryptKey(dOMDecryptContext, algorithmMethod);
        }
        catch (XMLEncryptionException xMLEncryptionException) {
            throw new KeySelectorException(xMLEncryptionException);
        }
        this.addKeyProvider(new SecretKeyProvider(key, encryptedKey.getCarriedKeyName(), null, encryptedKey.getId()));
        KeySelectorResultImpl keySelectorResultImpl = new KeySelectorResultImpl(key);
        keySelectorResultImpl.setSecurityToken(((KeySelectorResultImpl)dOMDecryptContext.getProperty("weblogic.xml.crypto.ksr")).getSecurityToken());
        dOMDecryptContext.setProperty("weblogic.xml.crypto.ksr", keySelectorResultImpl);
        return keySelectorResultImpl;
    }

    private KeySelectorResult getKeyFromSTR(SecurityTokenReference securityTokenReference, XMLCryptoContext xMLCryptoContext, KeySelector.Purpose purpose, String string) throws KeySelectorException {
        LogUtils.logKeyInfo("Trying to get key using STR");
        MessageContext messageContext = (MessageContext)xMLCryptoContext.getProperty("javax.xml.rpc.handler.MessageContext");
        WSSecurityContext wSSecurityContext = null;
        if (messageContext != null) {
            wSSecurityContext = WSSecurityContext.getSecurityContext(messageContext);
            if (KeySelector.Purpose.DECRYPT.equals(purpose) || KeySelector.Purpose.VERIFY.equals(purpose)) {
                SecurityTokenReference securityTokenReference2 = this.getSecurityTokenReference(securityTokenReference, wSSecurityContext);
                if (null == securityTokenReference2) {
                    this.setupKeyProviderFromContext(securityTokenReference, wSSecurityContext, messageContext, purpose);
                } else {
                    this.setupKeyProviderFromContext(securityTokenReference2, wSSecurityContext, messageContext, purpose);
                }
            } else {
                this.setupKeyProviderFromContext(securityTokenReference, wSSecurityContext, messageContext, purpose);
            }
        } else if ((KeySelector.Purpose.DECRYPT.equals(purpose) || KeySelector.Purpose.VERIFY.equals(purpose)) && (wSSecurityContext = (WSSecurityContext)xMLCryptoContext.getProperty("weblogic.xml.crypto.wss.WSSecurityContext")) != null) {
            messageContext = new KeyResolverMessageContext();
            messageContext.setProperty("weblogic.xml.crypto.wss.WSSecurityContext", (Object)wSSecurityContext);
            SecurityTokenReference securityTokenReference3 = this.getSecurityTokenReference(securityTokenReference, wSSecurityContext);
            if (null == securityTokenReference3) {
                this.setupKeyProviderFromContext(securityTokenReference, wSSecurityContext, messageContext, purpose);
            } else {
                this.setupKeyProviderFromContext(securityTokenReference3, wSSecurityContext, messageContext, purpose);
            }
        }
        KeySelectorResult keySelectorResult = this.getKey(securityTokenReference, BY_TOKEN_REFERENCE, string, purpose, this.getKeyProviders());
        if (keySelectorResult != null) {
            return keySelectorResult;
        }
        throw new KeySelectorException("Failed to resolve key using SecurityTokenReference " + securityTokenReference);
    }

    private void setupKeyProviderFromContext(SecurityTokenReference securityTokenReference, WSSecurityContext wSSecurityContext, MessageContext messageContext, KeySelector.Purpose purpose) throws KeySelectorException {
        String string = this.getValueType(securityTokenReference, wSSecurityContext);
        SecurityTokenHandler securityTokenHandler = null;
        SecurityToken securityToken = null;
        try {
            securityTokenHandler = wSSecurityContext.getRequiredTokenHandler(string);
            messageContext.setProperty("weblogic.xml.crypto.wss.provider.Purpose", (Object)Purpose.convert(purpose));
            securityToken = securityTokenHandler.getSecurityToken(securityTokenReference, messageContext);
            if (securityToken != null) {
                this.validateAndAddToken(securityTokenHandler, securityToken, messageContext, purpose, wSSecurityContext);
                KeyProvider keyProvider = securityTokenHandler.getKeyProvider(securityToken, messageContext);
                this.addKeyProvider(keyProvider);
                LogUtils.logKeyInfo("Added key provider " + keyProvider);
            }
        }
        catch (WSSecurityException wSSecurityException) {
            throw new KeySelectorException(wSSecurityException);
        }
    }

    private void validateAndAddToken(SecurityTokenHandler securityTokenHandler, SecurityToken securityToken, MessageContext messageContext, KeySelector.Purpose purpose, WSSecurityContext wSSecurityContext) throws WSSecurityException {
        SecurityTokenValidateResult securityTokenValidateResult = securityTokenHandler.validateUnmarshalled(securityToken, messageContext);
        if (!securityTokenValidateResult.status()) {
            throw new WSSecurityException("Security token failed to validate.", securityTokenValidateResult, WSSConstants.FAILURE_TOKEN_INVALID);
        }
        messageContext.removeProperty("weblogic.xml.crypto.wss.provider.Purpose");
        if (!KeySelector.Purpose.DECRYPT.equals(purpose)) {
            wSSecurityContext.addSecurityToken(securityToken);
        }
    }

    private WSSecurityContext getSecurityContext(XMLCryptoContext xMLCryptoContext) {
        MessageContext messageContext = (MessageContext)xMLCryptoContext.getProperty("javax.xml.rpc.handler.MessageContext");
        WSSecurityContext wSSecurityContext = null;
        if (messageContext != null) {
            wSSecurityContext = WSSecurityContext.getSecurityContext(messageContext);
        }
        return wSSecurityContext;
    }

    private String getValueType(SecurityTokenReference securityTokenReference, WSSecurityContext wSSecurityContext) throws KeySelectorException {
        String string = securityTokenReference.getValueType();
        if (string != null) {
            return string;
        }
        String string2 = securityTokenReference.getReferenceURI();
        Element element = wSSecurityContext.getElementById(string2.substring(1));
        if (null == element) {
            throw new KeySelectorException("Failed to unmarshal STR, token is null for uri =" + string2);
        }
        QName qName = DOMUtils.getQName(element);
        if (WSSConstants.BST_QNAME.equals(qName)) {
            return DOMUtils.getAttributeValue(element, WSSConstants.VALUE_TYPE_QNAME);
        }
        if (WSSConstants.UNT_QNAME.equals(qName)) {
            return "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken";
        }
        if (weblogic.wsee.security.wssc.v13.WSCConstants.DK_QNAME.equals(qName)) {
            return "http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/dk";
        }
        if (WSCConstants.DK_QNAME.equals(qName)) {
            return "http://schemas.xmlsoap.org/ws/2005/02/sc/dk";
        }
        if (SecurityImpl.ENCRYPTED_KEY_QNAME.equals(qName)) {
            throw new KeySelectorException("Failed to unmarshal STR from a encrypted key -- uri =" + string2);
        }
        if (WSSConstants.STR_QNAME.equals(qName)) {
            throw new KeySelectorException("Failed to unmarshal STR from a STR-- uri =" + string2);
        }
        throw new KeySelectorException("Failed to unmarshal STR, token type not recognized -- uri =" + string2 + " QName = " + qName.toString());
    }

    private SecurityTokenReference getSecurityTokenReference(SecurityTokenReference securityTokenReference, WSSecurityContext wSSecurityContext) {
        if (securityTokenReference.getValueType() != null) {
            return null;
        }
        String string = securityTokenReference.getReferenceURI();
        Element element = wSSecurityContext.getElementById(string.substring(1));
        QName qName = DOMUtils.getQName(element);
        if (WSSConstants.STR_QNAME.equals(qName)) {
            return (SecurityTokenReference)((Object)element);
        }
        if (SecurityImpl.ENCRYPTED_KEY_QNAME.equals(qName)) {
            XMLEncryptionFactory xMLEncryptionFactory = wSSecurityContext.getEncryptionFactory();
            KeySelector keySelector = wSSecurityContext.getKeySelector();
            DOMDecryptContext dOMDecryptContext = new DOMDecryptContext(keySelector, element);
            MessageContext messageContext = wSSecurityContext.getMessageContext();
            dOMDecryptContext.setProperty("javax.xml.rpc.handler.MessageContext", messageContext);
            dOMDecryptContext.setProperty("weblogic.xml.crypto.wss.WSSecurityContext", wSSecurityContext);
            try {
                KeyInfo keyInfo;
                List list;
                EncryptedKey encryptedKey = (EncryptedKey)xMLEncryptionFactory.unmarshalEncryptedType(dOMDecryptContext);
                if (null != encryptedKey.getKeyInfo() && null != (list = (keyInfo = encryptedKey.getKeyInfo()).getContent())) {
                    for (Object e : list) {
                        if (!(e instanceof SecurityTokenReference)) continue;
                        return (SecurityTokenReference)e;
                    }
                }
            }
            catch (Exception exception) {
                LogUtils.logKeyInfo("5  exception found STR in key info " + exception.toString());
                return null;
            }
        }
        return null;
    }

    private String providersToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (KeyProvider keyProvider : this.keyProviders) {
            stringBuffer.append(keyProvider).append(" ");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private KeySelectorResult getKey(Iterator iterator, Accessor accessor, String string, KeySelector.Purpose purpose, KeyProvider[] keyProviderArray) {
        KeySelectorResult keySelectorResult = null;
        while (iterator.hasNext() && keySelectorResult == null) {
            Object e = iterator.next();
            keySelectorResult = this.getKey(e, accessor, string, purpose, keyProviderArray);
        }
        return keySelectorResult;
    }

    private KeySelectorResult getKey(Object object, Accessor accessor, String string, KeySelector.Purpose purpose, KeyProvider[] keyProviderArray) {
        KeySelectorResult keySelectorResult = null;
        for (int i = 0; keySelectorResult == null && i < keyProviderArray.length; ++i) {
            KeyProvider keyProvider = keyProviderArray[i];
            if (null == keyProvider) {
                LogUtils.logKeyInfo("Trying to get key from key object " + object + " but the  KeyProvider is null");
                continue;
            }
            LogUtils.logKeyInfo("Trying to get key from key object " + object + " and KeyProvider " + keyProvider);
            keySelectorResult = accessor.getKey(object, string, purpose, keyProvider);
            if (keySelectorResult == null) continue;
            return keySelectorResult;
        }
        return keySelectorResult;
    }

    private Object getCredential(String string, Object object, String string2, Purpose purpose, WSSecurityContext wSSecurityContext) throws WSSecurityException {
        CredentialProvider credentialProvider = wSSecurityContext.getRequiredCredentialProvider(string2);
        ContextHandler contextHandler = this.getContextHandler(wSSecurityContext, string, object);
        Object object2 = credentialProvider.getCredential(string2, null, contextHandler, purpose);
        return object2;
    }

    protected ContextHandler getContextHandler(WSSecurityInfo wSSecurityInfo, String string, Object object) {
        SecurityTokenContextHandler securityTokenContextHandler = new SecurityTokenContextHandler(wSSecurityInfo);
        securityTokenContextHandler.addContextElement(string, object);
        return securityTokenContextHandler;
    }

    private class KeyResolverMessageContext
    implements MessageContext {
        private HashMap props = new HashMap();

        private KeyResolverMessageContext() {
        }

        public void setProperty(String string, Object object) {
            this.props.put(string, object);
        }

        public Object getProperty(String string) {
            return this.props.get(string);
        }

        public void removeProperty(String string) {
            this.props.remove(string);
        }

        public boolean containsProperty(String string) {
            return this.props.containsKey(string);
        }

        public Iterator getPropertyNames() {
            return this.props.keySet().iterator();
        }
    }

    protected static interface Accessor {
        public KeySelectorResult getKey(Object var1, String var2, KeySelector.Purpose var3, KeyProvider var4);
    }
}

