/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.common.keyinfo;

import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Iterator;
import weblogic.xml.crypto.api.AlgorithmMethod;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.KeySelectorException;
import weblogic.xml.crypto.api.KeySelectorResult;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.common.keyinfo.KeySelectorResultImpl;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfo;
import weblogic.xml.crypto.dsig.keyinfo.KeyInfoImpl;

public class KeyValueKeySelector
extends KeySelector {
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod algorithmMethod, XMLCryptoContext xMLCryptoContext) throws KeySelectorException {
        PublicKey publicKey = null;
        Iterator iterator = ((KeyInfoImpl)keyInfo).getPublicKeys();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof DSAPublicKey && "http://www.w3.org/2000/09/xmldsig#dsa-sha1".equals(algorithmMethod.getAlgorithm())) {
                publicKey = (DSAPublicKey)e;
                break;
            }
            if (!(e instanceof RSAPublicKey) || !"http://www.w3.org/2000/09/xmldsig#rsa-sha1".equals(algorithmMethod.getAlgorithm())) continue;
            publicKey = (RSAPublicKey)e;
            break;
        }
        return new KeySelectorResultImpl(publicKey);
    }
}

