/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.common.keyinfo;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.KeySelectorResult;
import weblogic.xml.crypto.common.keyinfo.BaseKeyProvider;
import weblogic.xml.crypto.common.keyinfo.KeySelectorResultImpl;
import weblogic.xml.crypto.utils.KeyUtils;
import weblogic.xml.crypto.wss.provider.SecurityToken;

public class KeypairProvider
extends BaseKeyProvider {
    private final String[] algs;
    private final PublicKey pubKey;
    private final PrivateKey privKey;

    public KeypairProvider(PublicKey publicKey, PrivateKey privateKey, String string, byte[] byArray, String string2) {
        this(publicKey, privateKey, string, byArray, string2, null);
    }

    public KeypairProvider(PublicKey publicKey, PrivateKey privateKey, String string, byte[] byArray, String string2, SecurityToken securityToken) {
        super(string, byArray, string2, securityToken);
        if (publicKey == null && privateKey == null) {
            throw new IllegalArgumentException("Received null for public key and private key");
        }
        this.pubKey = publicKey;
        this.privKey = privateKey;
        this.algs = publicKey != null ? KeyUtils.getAlgorithms(publicKey) : KeyUtils.getAlgorithms(privateKey);
    }

    protected KeySelectorResult getResult(Key key) {
        return new KeySelectorResultImpl(key);
    }

    public KeySelectorResult getKey(String string, KeySelector.Purpose purpose) {
        if (KeyUtils.supports(this.algs, string)) {
            if (this.pubKey != null && KeyUtils.serves(KeyUtils.getPurposes(this.pubKey), purpose)) {
                return this.getResult(this.pubKey);
            }
            if (this.privKey != null && KeyUtils.serves(KeyUtils.getPurposes(this.privKey), purpose)) {
                return this.getResult(this.privKey);
            }
        }
        return null;
    }
}

