/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.common.keyinfo;

import java.math.BigInteger;
import java.security.Key;
import java.util.Collection;
import java.util.Collections;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.KeySelectorResult;
import weblogic.xml.crypto.common.keyinfo.BaseKeyProvider;
import weblogic.xml.crypto.common.keyinfo.KeySelectorResultImpl;
import weblogic.xml.crypto.utils.KeyUtils;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.provider.SecurityToken;

public class SecretKeyProvider
extends BaseKeyProvider {
    private final Key key;
    private final String[] algs;
    private final KeySelector.Purpose[] purposes;
    static final boolean DEBUG = false;

    public SecretKeyProvider(Key key, String string, byte[] byArray, String string2) {
        this(key, string, byArray, Collections.singleton(string2));
    }

    public SecretKeyProvider(Key key, String string, byte[] byArray, Collection collection) {
        this(key, string, byArray, collection, null);
    }

    public SecretKeyProvider(Key key, String string, byte[] byArray, String string2, SecurityToken securityToken) {
        this(key, string, byArray, Collections.singleton(string2), securityToken);
    }

    public SecretKeyProvider(Key key, String string, byte[] byArray, Collection collection, SecurityToken securityToken) {
        super(string, byArray, collection, securityToken);
        if (key == null) {
            throw new IllegalArgumentException("Key cannot be null");
        }
        this.key = key;
        this.algs = KeyUtils.getAlgorithms(key);
        this.purposes = KeyUtils.getPurposes(key);
        this.dumpDebugInfo();
    }

    public KeySelectorResult getKey(String string, KeySelector.Purpose purpose) {
        if (this.serves(purpose) && this.supports(string)) {
            KeySelectorResultImpl keySelectorResultImpl = new KeySelectorResultImpl(this.key);
            keySelectorResultImpl.setSecurityToken(this.getSecurityToken());
            this.dumpDebugInfo();
            return keySelectorResultImpl;
        }
        return null;
    }

    public KeySelectorResult getKeyBySubjectName(String string, String string2, KeySelector.Purpose purpose) {
        return null;
    }

    public KeySelectorResult getKeyByIssuerSerial(String string, BigInteger bigInteger, String string2, KeySelector.Purpose purpose) {
        return null;
    }

    protected final boolean supports(String string) {
        return KeyUtils.supports(this.algs, string);
    }

    protected final boolean serves(KeySelector.Purpose purpose) {
        return KeyUtils.serves(this.purposes, purpose);
    }

    private void dumpDebugInfo() {
        if (this.key == null) {
            LogUtils.logKeyInfo("SecretKeyProvider key is null");
            return;
        }
        LogUtils.logKeyInfo("SecretKeyProvider Uri=" + this.getUri() + " Algo =" + this.key.getAlgorithm());
    }
}

