/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.common.keyinfo;

import java.math.BigInteger;
import java.security.Key;
import java.util.Map;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.KeySelectorResult;
import weblogic.xml.crypto.common.keyinfo.BaseKeyProvider;
import weblogic.xml.crypto.common.keyinfo.KeySelectorResultImpl;
import weblogic.xml.security.encryption.EncryptionAlgorithm;
import weblogic.xml.security.encryption.EncryptionException;
import weblogic.xml.security.encryption.EncryptionMethod;

public class SharedSecretKeyProvider
extends BaseKeyProvider {
    private static final Map keyFactories;
    private final String secret;
    private final byte[] nonce;

    public SharedSecretKeyProvider(String string, byte[] byArray, String string2, byte[] byArray2, String string3) {
        super(string2, byArray2, string3);
        this.secret = string;
        this.nonce = byArray;
    }

    public KeySelectorResult getKey(String string, KeySelector.Purpose purpose) {
        EncryptionAlgorithm encryptionAlgorithm = (EncryptionAlgorithm)keyFactories.get(string);
        KeySelectorResult keySelectorResult = null;
        if (encryptionAlgorithm != null) {
            try {
                Key key = encryptionAlgorithm.generateKey(this.secret.getBytes(), this.nonce);
                keySelectorResult = this.getResult(key);
            }
            catch (EncryptionException encryptionException) {
                // empty catch block
            }
        }
        return keySelectorResult;
    }

    protected KeySelectorResult getResult(Key key) {
        return new KeySelectorResultImpl(key);
    }

    public KeySelectorResult getKeyBySubjectName(String string, String string2, KeySelector.Purpose purpose) {
        return null;
    }

    public KeySelectorResult getKeyByIssuerSerial(String string, BigInteger bigInteger, String string2, KeySelector.Purpose purpose) {
        return null;
    }

    static {
        EncryptionAlgorithm encryptionAlgorithm;
        keyFactories = new ConcurrentHashMap();
        try {
            encryptionAlgorithm = (EncryptionAlgorithm)EncryptionMethod.get("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            keyFactories.put("http://www.w3.org/2001/04/xmlenc#aes128-cbc", encryptionAlgorithm);
            keyFactories.put("http://www.w3.org/2001/04/xmlenc#kw-aes128", encryptionAlgorithm);
        }
        catch (EncryptionException encryptionException) {
            // empty catch block
        }
        try {
            encryptionAlgorithm = (EncryptionAlgorithm)EncryptionMethod.get("http://www.w3.org/2001/04/xmlenc#aes192-cbc");
            keyFactories.put("http://www.w3.org/2001/04/xmlenc#aes192-cbc", encryptionAlgorithm);
            keyFactories.put("http://www.w3.org/2001/04/xmlenc#kw-aes192", encryptionAlgorithm);
        }
        catch (EncryptionException encryptionException) {
            // empty catch block
        }
        try {
            encryptionAlgorithm = (EncryptionAlgorithm)EncryptionMethod.get("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
            keyFactories.put("http://www.w3.org/2001/04/xmlenc#aes256-cbc", encryptionAlgorithm);
            keyFactories.put("http://www.w3.org/2001/04/xmlenc#kw-aes256", encryptionAlgorithm);
            keyFactories.put("http://www.w3.org/2000/09/xmldsig#hmac-sha1", encryptionAlgorithm);
        }
        catch (EncryptionException encryptionException) {
            // empty catch block
        }
        try {
            encryptionAlgorithm = (EncryptionAlgorithm)EncryptionMethod.get("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
            keyFactories.put("http://www.w3.org/2001/04/xmlenc#tripledes-cbc", encryptionAlgorithm);
            keyFactories.put("http://www.w3.org/2001/04/xmlenc#kw-tripledes", encryptionAlgorithm);
        }
        catch (EncryptionException encryptionException) {
            // empty catch block
        }
    }
}

