/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.util.Iterator;
import org.w3c.dom.Node;
import weblogic.utils.encoders.BASE64Decoder;
import weblogic.xml.crypto.OctetData;
import weblogic.xml.crypto.api.Data;
import weblogic.xml.crypto.api.NodeSetData;
import weblogic.xml.crypto.api.OctetStreamData;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.dsig.OctetTransform;
import weblogic.xml.crypto.dsig.TransformFactory;
import weblogic.xml.crypto.dsig.TransformImpl;
import weblogic.xml.crypto.dsig.api.Transform;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.dsig.api.spec.TransformParameterSpec;

public class Base64Transform
extends TransformImpl
implements OctetTransform,
TransformFactory {
    private static final TransformFactory factory = new Base64Transform();

    protected Base64Transform() {
    }

    public String getAlgorithm() {
        return "http://www.w3.org/2000/09/xmldsig#base64";
    }

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext) throws XMLSignatureException {
        try {
            if (data instanceof OctetStreamData) {
                OctetStreamData octetStreamData = (OctetStreamData)data;
                return this.getDecodedData(octetStreamData.getOctetStream());
            }
            if (data instanceof NodeSetData) {
                NodeSetData nodeSetData = (NodeSetData)data;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Iterator iterator = nodeSetData.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    if (node.getNodeType() != 3 && node.getNodeType() != 2) continue;
                    byte[] byArray = node.getNodeValue().getBytes("ASCII");
                    byteArrayOutputStream.write(byArray);
                }
                return this.getDecodedData(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            }
            if (data instanceof OctetData) {
                OctetData octetData = (OctetData)data;
                return this.getDecodedData(new ByteArrayInputStream(octetData.getBytes()));
            }
            throw new XMLSignatureException("Data type not supported in Base64Tranform.");
        }
        catch (IOException iOException) {
            throw new XMLSignatureException(iOException);
        }
    }

    private Data getDecodedData(InputStream inputStream) throws IOException {
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bASE64Decoder.decodeBuffer(inputStream, (OutputStream)byteArrayOutputStream);
        byteArrayOutputStream.flush();
        byteArrayOutputStream.close();
        return new OctetStreamData(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
    }

    public Transform newTransform(TransformParameterSpec transformParameterSpec) throws InvalidAlgorithmParameterException {
        return this;
    }

    public String getURI() {
        return "http://www.w3.org/2000/09/xmldsig#base64";
    }

    public static void init() {
        Base64Transform.register(factory);
    }
}

