/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import org.w3c.dom.Node;
import weblogic.xml.babel.stream.CanonicalWriter;
import weblogic.xml.babel.stream.ExclusiveCanonicalWriter;
import weblogic.xml.crypto.api.Data;
import weblogic.xml.crypto.api.OctetStreamData;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.dsig.TransformImpl;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.utils.DataUtils;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLStreamException;

public class C14NTransform
extends TransformImpl {
    private boolean exclusive;
    private boolean withComments;

    public C14NTransform(boolean bl, boolean bl2) {
        this.exclusive = bl;
        this.withComments = bl2;
    }

    public String getAlgorithm() {
        if (this.exclusive) {
            return "http://www.w3.org/2001/10/xml-exc-c14n#";
        }
        if (this.withComments) {
            return "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
        }
        return "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    }

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext) throws XMLSignatureException {
        Node node = DataUtils.getNode(data);
        XMLInputStream xMLInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            ExclusiveCanonicalWriter exclusiveCanonicalWriter;
            Closeable closeable;
            if (node != null) {
                xMLInputStream = XMLInputStreamFactory.newInstance().newInputStream(node);
            } else {
                closeable = DataUtils.getInputStream(data);
                if (closeable != null) {
                    xMLInputStream = XMLInputStreamFactory.newInstance().newInputStream(DataUtils.getInputStream(data));
                } else {
                    return new OctetStreamData(new ByteArrayInputStream(new byte[0]));
                }
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                closeable = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
            Map map = DOMUtils.getNamespaceMap(node);
            if (this.exclusive) {
                exclusiveCanonicalWriter = new ExclusiveCanonicalWriter((Writer)closeable);
            } else {
                exclusiveCanonicalWriter = new CanonicalWriter((Writer)closeable, map);
                if (this.withComments) {
                    ((CanonicalWriter)exclusiveCanonicalWriter).setWriteComments(this.withComments);
                }
            }
            while (xMLInputStream.hasNext()) {
                XMLEvent xMLEvent = xMLInputStream.next();
                exclusiveCanonicalWriter.write(xMLEvent);
            }
            exclusiveCanonicalWriter.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XMLSignatureException("Could not create xml stream for " + this.getAlgorithm() + " transform.", xMLStreamException);
        }
        return new OctetStreamData(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
    }
}

