/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.security.NoSuchAlgorithmException;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.xml.crypto.dsig.CanonicalizationMethodFactory;
import weblogic.xml.crypto.dsig.CanonicalizationMethodW3C;
import weblogic.xml.crypto.dsig.api.CanonicalizationMethod;
import weblogic.xml.crypto.dsig.api.spec.C14NMethodParameterSpec;

public abstract class CanonicalizationMethodImpl {
    public static final String C14NMETHOD_ELEMENT = "CanonicalizationMethod";
    public static final String ALGORITHM_ATTRIBUTE = "Algorithm";
    private static final ConcurrentHashMap factories = new ConcurrentHashMap();

    private static final void initFactories() {
        CanonicalizationMethodW3C.init();
    }

    public static void register(CanonicalizationMethodFactory canonicalizationMethodFactory) {
        factories.put((Object)canonicalizationMethodFactory.getURI(), (Object)canonicalizationMethodFactory);
    }

    public static CanonicalizationMethod newCanonicalizationMethod(String string) throws NoSuchAlgorithmException {
        return CanonicalizationMethodImpl.newCanonicalizationMethod(string, null);
    }

    public static CanonicalizationMethod newCanonicalizationMethod(String string, C14NMethodParameterSpec c14NMethodParameterSpec) throws NoSuchAlgorithmException {
        CanonicalizationMethodFactory canonicalizationMethodFactory = (CanonicalizationMethodFactory)factories.get((Object)string);
        if (canonicalizationMethodFactory == null) {
            throw new NoSuchAlgorithmException(string + " not supported");
        }
        return canonicalizationMethodFactory.newCanonicalizationMethod();
    }

    static {
        CanonicalizationMethodImpl.initFactories();
    }
}

