/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.utils.StringUtils;
import weblogic.xml.babel.stream.CanonicalWriter;
import weblogic.xml.babel.stream.ExclusiveCanonicalWriter;
import weblogic.xml.babel.stream.XMLOutputStreamBase;
import weblogic.xml.babel.stream.XMLWriter;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.dsig.CanonicalizationMethodFactory;
import weblogic.xml.crypto.dsig.CanonicalizationMethodImpl;
import weblogic.xml.crypto.dsig.InclusiveUtils;
import weblogic.xml.crypto.dsig.WLCanonicalizationMethod;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.dsig.api.CanonicalizationMethod;
import weblogic.xml.crypto.dsig.api.spec.C14NMethodParameterSpec;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.utils.StaxUtils;
import weblogic.xml.schema.types.XSDNMTokens;
import weblogic.xml.stream.XMLOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CanonicalizationMethodW3C
extends CanonicalizationMethodImpl
implements CanonicalizationMethodFactory,
CanonicalizationMethod,
WLCanonicalizationMethod,
WLXMLStructure {
    private final String algorithmURI;
    private final String algorithm;
    private final boolean withComments;
    private final boolean exclusive;
    private final boolean augmented;
    private Set<String> augmentedElementTracks;
    private C14NMethodParameterSpec c14nMethodParameterSpec;
    private String[] inclusiveNSPrefixList;

    private CanonicalizationMethodW3C(String string, boolean bl, boolean bl2) {
        this(string, bl, bl2, false);
    }

    private CanonicalizationMethodW3C(String string, boolean bl, boolean bl2, boolean bl3) {
        this.algorithmURI = string;
        this.withComments = bl;
        this.exclusive = bl2;
        this.augmented = bl3;
        this.algorithm = bl3 ? string + "_augmented" : string;
    }

    static void init() {
        CanonicalizationMethodW3C.register(new CanonicalizationMethodW3C("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", false, false));
        CanonicalizationMethodW3C.register(new CanonicalizationMethodW3C("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", true, false));
        CanonicalizationMethodW3C.register(new CanonicalizationMethodW3C("http://www.w3.org/2001/10/xml-exc-c14n#", false, true));
        CanonicalizationMethodW3C.register(new CanonicalizationMethodW3C("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", false, false, true));
        CanonicalizationMethodW3C.register(new CanonicalizationMethodW3C("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", true, false, true));
        CanonicalizationMethodW3C.register(new CanonicalizationMethodW3C("http://www.w3.org/2001/10/xml-exc-c14n#", false, true, true));
    }

    @Override
    public String getURI() {
        return this.algorithm;
    }

    @Override
    public CanonicalizationMethod newCanonicalizationMethod() {
        if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(this.algorithmURI)) {
            if (!this.augmented) {
                return new CanonicalizationMethodW3C("http://www.w3.org/2001/10/xml-exc-c14n#", false, true);
            }
            return new CanonicalizationMethodW3C("http://www.w3.org/2001/10/xml-exc-c14n#", false, true, true);
        }
        return this;
    }

    @Override
    public AlgorithmParameterSpec getParameterSpec() {
        return this.c14nMethodParameterSpec;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithmURI;
    }

    @Override
    public boolean isFeatureSupported(String string) {
        return false;
    }

    @Override
    public XMLOutputStream canonicalize(OutputStream outputStream, Map map) {
        CanonicalWriter canonicalWriter;
        OutputStreamWriter outputStreamWriter;
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        if (this.exclusive) {
            canonicalWriter = this.inclusiveNSPrefixList != null ? new ExclusiveCanonicalWriter((Writer)outputStreamWriter, map, this.getPrefixList()) : new ExclusiveCanonicalWriter((Writer)outputStreamWriter, this.getPrefixList());
        } else {
            canonicalWriter = new CanonicalWriter((Writer)outputStreamWriter, map);
            if (this.withComments) {
                canonicalWriter.setWriteComments(this.withComments);
            }
        }
        if (this.augmented) {
            canonicalWriter.setWriteAugmented(this.augmented);
            canonicalWriter.setAugmentedElementTracks(this.augmentedElementTracks);
        }
        return new XMLOutputStreamBase((XMLWriter)canonicalWriter);
    }

    @Override
    public void write(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod");
            xMLStreamWriter.writeAttribute("Algorithm", this.algorithmURI);
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to write CanonicalizationMethod " + this.algorithmURI + ".", xMLStreamException);
        }
    }

    private void writeInclusiveNamespaces(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        xMLStreamWriter.setPrefix("exc14n", "http://www.w3.org/2001/10/xml-exc-c14n#");
        xMLStreamWriter.writeStartElement("http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces");
        xMLStreamWriter.writeNamespace("exc14n", "http://www.w3.org/2001/10/xml-exc-c14n#");
        String[] stringArray = this.getPrefixList();
        if (stringArray != null && stringArray.length > 0) {
            xMLStreamWriter.writeAttribute("PrefixList", this.getPrefixes());
        }
        xMLStreamWriter.writeEndElement();
    }

    private String[] getPrefixList() {
        if (this.inclusiveNSPrefixList != null && this.inclusiveNSPrefixList.length > 0) {
            for (int i = 0; i < this.inclusiveNSPrefixList.length; ++i) {
                if (this.inclusiveNSPrefixList[i].compareTo("xmlns") != 0) continue;
                this.inclusiveNSPrefixList[i] = "#default";
            }
        }
        return this.inclusiveNSPrefixList;
    }

    public String getPrefixes() {
        if (this.inclusiveNSPrefixList != null) {
            return StringUtils.join((String[])this.getPrefixList(), (String)" ");
        }
        return "";
    }

    public void setPrefixes(String string) {
        if (string != null) {
            string.replace("#default", "xmlns");
            this.inclusiveNSPrefixList = XSDNMTokens.convertXml((String)string, (String)"#default");
        }
    }

    public void setupNonVisiblyUsed(Node node, Map map, XMLCryptoContext xMLCryptoContext) {
        Node node2;
        if (!"http://www.w3.org/2001/10/xml-exc-c14n#".equals(this.algorithmURI) && !"http://www.w3.org/2001/10/xml-exc-c14n#WithComments".equals(this.algorithmURI)) {
            return;
        }
        String[] stringArray = InclusiveUtils.getNonVisiblyUsed(node, map, xMLCryptoContext);
        if (stringArray != null && stringArray.length > 0 && (node2 = DOMUtils.findNode(node, "CanonicalizationMethod")) != null && node2.getNodeType() == 1) {
            Element element = DOMUtils.createAndAddElement((Element)node2, new QName("http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces", "exc14n"), "exc14n");
            DOMUtils.addAttribute(element, new QName("PrefixList"), StringUtils.join((String[])stringArray, (String)" "));
            this.inclusiveNSPrefixList = stringArray;
        }
    }

    @Override
    public void read(XMLStreamReader xMLStreamReader) throws MarshalException {
        try {
            if (this.algorithmURI.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
                this.readInclusiveNamespaces(xMLStreamReader);
            }
            StaxUtils.forwardToEndElement("http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod", xMLStreamReader);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to read CanonicalizationMethod " + this.getAlgorithm() + ".", xMLStreamException);
        }
    }

    private void readInclusiveNamespaces(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        xMLStreamReader.nextTag();
        if (StaxUtils.findStart(xMLStreamReader, "http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces", false)) {
            String string = StaxUtils.getAttributeValue("http://www.w3.org/2001/10/xml-exc-c14n#", "PrefixList", xMLStreamReader);
            this.setPrefixes(string);
        }
    }

    @Override
    public void setAugmentedElementTracks(Set<String> set) {
        if (!"http://www.w3.org/2001/10/xml-exc-c14n#".equals(this.algorithmURI)) {
            throw new IllegalArgumentException("Augmented element tracks not allowed to be set into the one other than EXC-C14N without comments");
        }
        this.augmentedElementTracks = set;
    }
}

