/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.InvalidAlgorithmParameterException;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import weblogic.xml.babel.stream.CanonicalWriter;
import weblogic.xml.babel.stream.XMLWriter;
import weblogic.xml.crypto.NodeURIDereferencer;
import weblogic.xml.crypto.OctetData;
import weblogic.xml.crypto.api.Data;
import weblogic.xml.crypto.api.NodeSetData;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.dsig.OctetTransform;
import weblogic.xml.crypto.dsig.TransformFactory;
import weblogic.xml.crypto.dsig.TransformImpl;
import weblogic.xml.crypto.dsig.api.Transform;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.dsig.api.spec.TransformParameterSpec;
import weblogic.xml.crypto.utils.C14NDOMAdapter;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.utils.DataUtils;
import weblogic.xml.stream.XMLStreamException;

public class DOMC14NTransform
extends TransformImpl
implements OctetTransform,
TransformFactory {
    private static TransformFactory withoutCommentsFactory = new DOMC14NTransform(false);
    private static TransformFactory withCommentsFactory = new DOMC14NTransform(true);
    private boolean withComments;

    public DOMC14NTransform(boolean bl) {
        this.withComments = bl;
    }

    public String getAlgorithm() {
        if (this.withComments) {
            return "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
        }
        return "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    }

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext) throws XMLSignatureException {
        NodeSetData nodeSetData = DataUtils.extractNodeSetData(data);
        Node node = ((NodeURIDereferencer)xMLCryptoContext.getURIDereferencer()).getContextNode();
        return this.transform(node, nodeSetData, xMLCryptoContext);
    }

    public Data transform(Node node, NodeSetData nodeSetData, XMLCryptoContext xMLCryptoContext) throws XMLSignatureException {
        OutputStreamWriter outputStreamWriter;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)unsupportedEncodingException);
        }
        Map map = DOMUtils.getNamespaceMap((Node)nodeSetData.iterator().next());
        try {
            this.setupNonVisiblyUsed(nodeSetData, map, xMLCryptoContext);
            CanonicalWriter canonicalWriter = this.getWriter(outputStreamWriter, map);
            if (this.withComments) {
                canonicalWriter.setWriteComments(this.withComments);
            }
            C14NDOMAdapter c14NDOMAdapter = new C14NDOMAdapter((XMLWriter)canonicalWriter, map);
            DOMC14NTransform.traverseNode(node, nodeSetData, c14NDOMAdapter);
            canonicalWriter.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XMLSignatureException("Could not create xml stream for " + this.getAlgorithm() + " transform.", xMLStreamException);
        }
        return new OctetData(byteArrayOutputStream.toByteArray());
    }

    private static void traverseNode(Node node, NodeSetData nodeSetData, C14NDOMAdapter c14NDOMAdapter) throws XMLStreamException {
        Node node2;
        int n;
        int n2;
        Object object;
        if (nodeSetData.contains(node)) {
            c14NDOMAdapter.adaptNodeStart(node);
        }
        if (node.getNodeType() == 1) {
            object = ((Element)node).getAttributes();
            n2 = object.getLength();
            for (n = 0; n < n2; ++n) {
                node2 = object.item(n);
                if (!nodeSetData.contains(node2)) continue;
                c14NDOMAdapter.adaptNodeStart(node2);
            }
        }
        if (node.hasChildNodes()) {
            object = node.getChildNodes();
            n2 = object.getLength();
            for (n = 0; n < n2; ++n) {
                node2 = object.item(n);
                DOMC14NTransform.traverseNode(node2, nodeSetData, c14NDOMAdapter);
            }
        }
        if (nodeSetData.contains(node)) {
            c14NDOMAdapter.adaptNodeEnd(node);
        }
    }

    public Transform newTransform(TransformParameterSpec transformParameterSpec) throws InvalidAlgorithmParameterException {
        return this;
    }

    public String getURI() {
        return this.getAlgorithm();
    }

    public static void init() {
        DOMC14NTransform.register(withoutCommentsFactory);
        DOMC14NTransform.register(withCommentsFactory);
    }

    protected CanonicalWriter getWriter(Writer writer, Map map) {
        return new CanonicalWriter(writer, map);
    }

    protected void setupNonVisiblyUsed(NodeSetData nodeSetData, Map map, XMLCryptoContext xMLCryptoContext) {
    }
}

