/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.XMLStructure;
import weblogic.xml.crypto.dsig.DigestMethodFactory;
import weblogic.xml.crypto.dsig.JCEDigestMethod;
import weblogic.xml.crypto.dsig.WLDigestMethod;
import weblogic.xml.crypto.dsig.api.spec.DigestMethodParameterSpec;
import weblogic.xml.crypto.utils.StaxUtils;

public abstract class DigestMethodImpl
implements XMLStructure,
WLDigestMethod {
    public static final String DIGESTMETHOD_ELEMENT = "DigestMethod";
    public static final String ALGORITHM_ATTRIBUTE = "Algorithm";
    private static final ConcurrentHashMap factories = new ConcurrentHashMap();
    protected final String algorithmURI;

    protected DigestMethodImpl(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Algorithm URI cannot be null");
        }
        this.algorithmURI = string;
    }

    private static final void initDigestFactories() {
        JCEDigestMethod.init();
    }

    public static void register(DigestMethodFactory digestMethodFactory) {
        factories.put((Object)digestMethodFactory.getURI(), (Object)digestMethodFactory);
    }

    public static WLDigestMethod newDigestMethod(String string) throws NoSuchAlgorithmException {
        return DigestMethodImpl.newDigestMethod(string, null);
    }

    static WLDigestMethod newDigestMethod(String string, DigestMethodParameterSpec digestMethodParameterSpec) throws NoSuchAlgorithmException {
        DigestMethodFactory digestMethodFactory = (DigestMethodFactory)factories.get((Object)string);
        if (digestMethodFactory == null) {
            throw new NoSuchAlgorithmException(string + " not supported");
        }
        return digestMethodFactory.newDigestMethod(null);
    }

    public static WLDigestMethod newDigestMethod(XMLStreamReader xMLStreamReader) throws XMLStreamException, NoSuchAlgorithmException, MarshalException {
        xMLStreamReader.require(1, "http://www.w3.org/2000/09/xmldsig#", DIGESTMETHOD_ELEMENT);
        String string = StaxUtils.getAttributeValue("http://www.w3.org/2000/09/xmldsig#", ALGORITHM_ATTRIBUTE, xMLStreamReader);
        WLDigestMethod wLDigestMethod = DigestMethodImpl.newDigestMethod(string);
        wLDigestMethod.read(xMLStreamReader);
        return wLDigestMethod;
    }

    public String getURI() {
        return this.algorithmURI;
    }

    public abstract AlgorithmParameterSpec getParameterSpec();

    public String getAlgorithm() {
        return this.algorithmURI;
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public final void write(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2000/09/xmldsig#", DIGESTMETHOD_ELEMENT);
            xMLStreamWriter.writeAttribute(ALGORITHM_ATTRIBUTE, this.algorithmURI);
            this.writeParameters(xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to write element DigestMethod", xMLStreamException);
        }
    }

    protected void writeParameters(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
    }

    public final void read(XMLStreamReader xMLStreamReader) throws MarshalException {
        try {
            String string = StaxUtils.getAttributeValue("http://www.w3.org/2000/09/xmldsig#", ALGORITHM_ATTRIBUTE, xMLStreamReader);
            if (!this.algorithmURI.equals(string)) {
                throw new MarshalException("DigestMethod read (" + string + ") was not the one expected (" + this.algorithmURI + ")");
            }
            StaxUtils.readStart(xMLStreamReader, "http://www.w3.org/2000/09/xmldsig#", DIGESTMETHOD_ELEMENT);
            this.readParameters(xMLStreamReader);
            StaxUtils.readEnd(xMLStreamReader, "http://www.w3.org/2000/09/xmldsig#", DIGESTMETHOD_ELEMENT);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to read DigestMethod " + this.getAlgorithm() + ".", xMLStreamException);
        }
    }

    protected void readParameters(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        StaxUtils.skipChildren(xMLStreamReader);
    }

    static {
        DigestMethodImpl.initDigestFactories();
    }
}

