/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Node;
import weblogic.xml.crypto.NodeSetDataImpl;
import weblogic.xml.crypto.api.Data;
import weblogic.xml.crypto.api.NodeSetData;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.dom.WLDOMSignContext;
import weblogic.xml.crypto.dom.WLDOMValidateContext;
import weblogic.xml.crypto.dsig.NodeTransform;
import weblogic.xml.crypto.dsig.TransformFactory;
import weblogic.xml.crypto.dsig.TransformImpl;
import weblogic.xml.crypto.dsig.api.Transform;
import weblogic.xml.crypto.dsig.api.XMLSignContext;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.dsig.api.XMLValidateContext;
import weblogic.xml.crypto.dsig.api.spec.TransformParameterSpec;
import weblogic.xml.crypto.utils.DOMUtils;

public class EnvelopedSignatureTransform
extends TransformImpl
implements NodeTransform,
TransformFactory {
    private static final TransformFactory factory = new EnvelopedSignatureTransform();
    private TransformParameterSpec params;

    protected EnvelopedSignatureTransform() {
    }

    protected EnvelopedSignatureTransform(TransformParameterSpec transformParameterSpec) {
        this.params = transformParameterSpec;
    }

    public String getAlgorithm() {
        return "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext) throws XMLSignatureException {
        Node node = null;
        if (xMLCryptoContext instanceof XMLValidateContext) {
            node = ((WLDOMValidateContext)((Object)xMLCryptoContext)).getSignatureNode();
        } else if (xMLCryptoContext instanceof XMLSignContext) {
            node = ((WLDOMSignContext)((Object)xMLCryptoContext)).getXMLSignature().getSignatureNode();
        } else {
            return data;
        }
        Set set = DOMUtils.getNodeSet(node, true);
        NodeSetData nodeSetData = (NodeSetData)data;
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Iterator iterator = nodeSetData.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (set.contains(e)) continue;
            linkedHashSet.add(e);
        }
        return new NodeSetDataImpl(linkedHashSet);
    }

    protected void writeParameters(XMLStreamWriter xMLStreamWriter) {
    }

    protected void readParameters(XMLStreamReader xMLStreamReader) {
    }

    public Transform newTransform(TransformParameterSpec transformParameterSpec) throws InvalidAlgorithmParameterException {
        return new EnvelopedSignatureTransform(transformParameterSpec);
    }

    public String getURI() {
        return "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    }

    public static void init() {
        EnvelopedSignatureTransform.register(factory);
    }
}

