/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.io.Writer;
import java.security.InvalidAlgorithmParameterException;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.utils.StringUtils;
import weblogic.xml.babel.stream.CanonicalWriter;
import weblogic.xml.babel.stream.ExclusiveCanonicalWriter;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.NodeSetData;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.dsig.DOMC14NTransform;
import weblogic.xml.crypto.dsig.InclusiveUtils;
import weblogic.xml.crypto.dsig.TransformFactory;
import weblogic.xml.crypto.dsig.api.Transform;
import weblogic.xml.crypto.dsig.api.spec.TransformParameterSpec;
import weblogic.xml.crypto.utils.StaxUtils;
import weblogic.xml.schema.types.XSDNMTokens;

public class ExclDOMC14NTransform
extends DOMC14NTransform {
    private static TransformFactory withoutCommentsExclFactory = new ExclDOMC14NTransform(false);
    private String[] inclusiveNSPrefixList = null;
    private boolean nonVisiblyUsedSet = false;

    public ExclDOMC14NTransform(boolean bl) {
        super(bl);
    }

    public ExclDOMC14NTransform(boolean bl, TransformParameterSpec transformParameterSpec) {
        this(bl);
    }

    public String getAlgorithm() {
        return "http://www.w3.org/2001/10/xml-exc-c14n#";
    }

    protected CanonicalWriter getWriter(Writer writer, Map map) {
        return new ExclusiveCanonicalWriter(writer, map, this.getPrefixList());
    }

    protected void readParameters(XMLStreamReader xMLStreamReader) throws MarshalException {
        this.readInclusiveNamespaces(xMLStreamReader);
    }

    protected void writeParameters(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        String[] stringArray = this.getPrefixList();
        if (stringArray != null && stringArray.length > 0) {
            this.writeInclusiveNamespaces(xMLStreamWriter);
        }
    }

    private void readInclusiveNamespaces(XMLStreamReader xMLStreamReader) throws MarshalException {
        try {
            xMLStreamReader.nextTag();
            if (StaxUtils.findStart(xMLStreamReader, "http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces", false)) {
                String string = StaxUtils.getAttributeValue("http://www.w3.org/2001/10/xml-exc-c14n#", "PrefixList", xMLStreamReader);
                this.setPrefixes(string);
            }
            this.nonVisiblyUsedSet = true;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
    }

    private void writeInclusiveNamespaces(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.setPrefix("exc14n", "http://www.w3.org/2001/10/xml-exc-c14n#");
            xMLStreamWriter.writeStartElement("http://www.w3.org/2001/10/xml-exc-c14n#", "InclusiveNamespaces");
            xMLStreamWriter.writeNamespace("exc14n", "http://www.w3.org/2001/10/xml-exc-c14n#");
            String[] stringArray = this.getPrefixList();
            if (stringArray != null && stringArray.length > 0) {
                xMLStreamWriter.writeAttribute("PrefixList", this.getPrefixes());
            }
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException(xMLStreamException);
        }
    }

    public String[] getPrefixList() {
        if (this.inclusiveNSPrefixList != null && this.inclusiveNSPrefixList.length > 0) {
            for (int i = 0; i < this.inclusiveNSPrefixList.length; ++i) {
                if (this.inclusiveNSPrefixList[i].compareTo("xmlns") != 0) continue;
                this.inclusiveNSPrefixList[i] = "#default";
            }
        }
        return this.inclusiveNSPrefixList;
    }

    public void setPrefixList(String[] stringArray) {
        this.setNonVisiblyUsed(stringArray);
    }

    private String getPrefixes() {
        if (this.inclusiveNSPrefixList != null) {
            return StringUtils.join((String[])this.getPrefixList(), (String)" ");
        }
        return "";
    }

    private void setPrefixes(String string) {
        String[] stringArray = null;
        if (string != null) {
            string.replace("#default", "xmlns");
            stringArray = XSDNMTokens.convertXml((String)string, (String)"#default");
        }
        this.setNonVisiblyUsed(stringArray);
    }

    public Transform newTransform(TransformParameterSpec transformParameterSpec) throws InvalidAlgorithmParameterException {
        return new ExclDOMC14NTransform(false, transformParameterSpec);
    }

    private void setNonVisiblyUsed(String[] stringArray) {
        this.nonVisiblyUsedSet = true;
        this.inclusiveNSPrefixList = stringArray;
    }

    protected void setupNonVisiblyUsed(NodeSetData nodeSetData, Map map, XMLCryptoContext xMLCryptoContext) {
        if (this.isNonVisiblyUsedSet()) {
            return;
        }
        String[] stringArray = InclusiveUtils.getNonVisiblyUsed(nodeSetData, map, xMLCryptoContext);
        this.setNonVisiblyUsed(stringArray);
    }

    private boolean isNonVisiblyUsedSet() {
        return this.nonVisiblyUsedSet;
    }

    public static void init() {
        ExclDOMC14NTransform.register(withoutCommentsExclFactory);
    }
}

