/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;
import weblogic.xml.crypto.NodeSetDataImpl;
import weblogic.xml.crypto.api.NodeSetData;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.dsig.DsigConstants;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.wss.WSSecurityContext;

public class InclusiveUtils {
    static final String PREFIX_SEP = ":";

    static String[] gatherInclusivePrefixes(NodeSetData nodeSetData, Map map, XMLCryptoContext xMLCryptoContext) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        Object object = nodeSetData.iterator();
        while (object.hasNext()) {
            Node node = (Node)object.next();
            String string = node.getLocalName();
            String string2 = node.getPrefix();
            String string3 = node.getNamespaceURI();
            if (node.getNodeType() == 2 && "http://www.w3.org/2000/xmlns/".equals(string3)) {
                if (string2 == null && "xmlns".equals(string)) {
                    hashSet2.add("");
                    continue;
                }
                hashSet2.add(string2);
                continue;
            }
            if (string2 == null || hashSet.contains(string2)) continue;
            hashSet.add(string2);
        }
        object = new HashSet(map.keySet());
        hashSet.removeAll(hashSet2);
        object.removeAll(hashSet);
        if (object.contains("")) {
            object.remove("");
            object.add("#default");
        }
        return object.toArray(new String[object.size()]);
    }

    public static String[] getNonVisiblyUsed(Node node, Map map, XMLCryptoContext xMLCryptoContext) {
        Set set = DOMUtils.getNodeSet(node, false);
        return InclusiveUtils.getNonVisiblyUsed(new NodeSetDataImpl(set), map, xMLCryptoContext);
    }

    public static String[] getNonVisiblyUsed(NodeSetData nodeSetData, Map map, XMLCryptoContext xMLCryptoContext) {
        String[] stringArray;
        Object object;
        String[] stringArray2;
        HashSet<String> hashSet = new HashSet<String>();
        Object object2 = nodeSetData.iterator();
        while (object2.hasNext()) {
            String string;
            QName qName;
            String string2;
            stringArray2 = (String[])object2.next();
            if (stringArray2.getNodeType() != 2 || !InclusiveUtils.isAttribute((String)(object = stringArray2.getLocalName()), (String)(stringArray = stringArray2.getPrefix())) || (string2 = stringArray2.getNamespaceURI()) == null || !DsigConstants.QNAME_VALUE_ATTRIBUTES.contains(qName = new QName(string2, (String)object)) || (string = InclusiveUtils.parsePrefix(stringArray2.getNodeValue())) == null) continue;
            hashSet.add(string);
        }
        object2 = (WSSecurityContext)xMLCryptoContext.getProperty("weblogic.xml.crypto.wss.WSSecurityContext");
        if (object2 != null && (stringArray2 = ((WSSecurityContext)object2).getMessageContext()) != null && ((object = stringArray2.getProperty("com.bea.weblogic.xml.crypto.dsig.IncluisveNSPrefixList")) instanceof Boolean && ((Boolean)object).booleanValue() || object instanceof String && "true".equalsIgnoreCase((String)object))) {
            stringArray = InclusiveUtils.gatherInclusivePrefixes(nodeSetData, map, xMLCryptoContext);
            hashSet.addAll(Arrays.asList(stringArray));
        }
        stringArray2 = new String[hashSet.size()];
        hashSet.toArray(stringArray2);
        return stringArray2;
    }

    static boolean isAttribute(String string, String string2) {
        if (string != null && string.equals("xmlns")) {
            return false;
        }
        return string2 == null || !string2.equals("xmlns");
    }

    static String parsePrefix(String string) {
        int n = string.indexOf(PREFIX_SEP);
        if (n < 0) {
            return null;
        }
        if (n == 0) {
            return "";
        }
        return string.substring(0, n);
    }
}

