/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import weblogic.xml.crypto.dsig.DigestMethodFactory;
import weblogic.xml.crypto.dsig.DigestMethodImpl;
import weblogic.xml.crypto.dsig.WLDigestMethod;
import weblogic.xml.crypto.dsig.api.DigestMethod;
import weblogic.xml.crypto.dsig.api.spec.DigestMethodParameterSpec;

class JCEDigestMethod
extends DigestMethodImpl
implements DigestMethodFactory,
DigestMethod {
    private static final String JCE_SHA1 = "SHA-1";
    private static final String JCE_SHA256 = "SHA-256";
    private static final String JCE_SHA512 = "SHA-512";
    private final String jceAlgorithmID;
    private final MessageDigest messageDigest;

    private JCEDigestMethod(String string, String string2) {
        super(string);
        this.jceAlgorithmID = string2;
        this.messageDigest = JCEDigestMethod.newMessageDigest(string2);
    }

    private static MessageDigest newMessageDigest(String string) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return messageDigest;
    }

    public static void init() {
        JCEDigestMethod.register(new JCEDigestMethod("http://www.w3.org/2000/09/xmldsig#sha1", JCE_SHA1));
        JCEDigestMethod.register(new JCEDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256", JCE_SHA256));
        JCEDigestMethod.register(new JCEDigestMethod("http://www.w3.org/2001/04/xmlenc#sha512", JCE_SHA512));
    }

    public MessageDigest getMessageDigest() {
        return this.messageDigest;
    }

    public WLDigestMethod newDigestMethod(DigestMethodParameterSpec digestMethodParameterSpec) throws NoSuchAlgorithmException {
        return new JCEDigestMethod(this.algorithmURI, this.jceAlgorithmID);
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return null;
    }

    public byte[] digest(byte[] byArray) {
        this.getMessageDigest().update(byArray);
        return this.getMessageDigest().digest();
    }
}

