/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import com.bea.xbean.util.XsTypeConverter;
import java.io.IOException;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Node;
import weblogic.utils.Hex;
import weblogic.xml.crypto.api.Data;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.NodeSetData;
import weblogic.xml.crypto.api.URIReferenceException;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.api.XMLStructure;
import weblogic.xml.crypto.dsig.DigestMethodImpl;
import weblogic.xml.crypto.dsig.ReferenceUtils;
import weblogic.xml.crypto.dsig.TransformImpl;
import weblogic.xml.crypto.dsig.WLDigestMethod;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.dsig.api.DigestMethod;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.api.Transform;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.dsig.api.XMLValidateContext;
import weblogic.xml.crypto.utils.DataUtils;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.utils.StaxUtils;
import weblogic.xml.crypto.wss.SignatureInfo;
import weblogic.xml.security.utils.Utils;

public class ReferenceImpl
implements XMLStructure,
Reference,
WLXMLStructure,
SignatureInfo.Reference,
Serializable {
    private static final long serialVersionUID = 1543097730829042873L;
    public static final String REFERENCE_ELEMENT = "Reference";
    private static final String URI_ATTRIBUTE = "URI";
    private static final String TYPE_ATTRIBUTE = "Type";
    private static final String DIGESTVALUE_ELEMENT = "DigestValue";
    private static final String TRANSFORMS_ELEMENT = "Transforms";
    private DigestMethod digestMethod;
    private transient String id;
    private List transforms;
    private List transformURIs;
    private transient List appliedTransforms = new ArrayList();
    private String uri;
    private transient String type;
    private transient Reference.DigestValue digestValue;
    private transient byte[] unmarshalledDigest;
    private transient Data derefData;

    public ReferenceImpl() {
        this.transforms = new ArrayList();
    }

    public ReferenceImpl(String string, DigestMethod digestMethod) {
        this(string, digestMethod, null, null, null);
    }

    public ReferenceImpl(String string, DigestMethod digestMethod, List list, String string2, String string3) {
        this.uri = string;
        this.digestMethod = digestMethod;
        this.transforms = ReferenceUtils.getAppliedTransforms(ReferenceUtils.getTransforms(list));
        this.fillAppliedTransforms();
        this.type = string2;
        this.id = string3;
    }

    public DigestMethod getDigestMethod() {
        return this.digestMethod;
    }

    public String getId() {
        return this.id;
    }

    public List getTransforms() {
        return Collections.unmodifiableList(this.transforms);
    }

    public Reference.DigestValue getDigestValue() {
        return this.digestValue;
    }

    public Reference.ValidateResult validate(XMLValidateContext xMLValidateContext) throws XMLSignatureException {
        try {
            this.createDigest(xMLValidateContext);
        }
        catch (URIReferenceException uRIReferenceException) {
            throw new XMLSignatureException("Failed to resolve reference.", uRIReferenceException);
        }
        boolean bl = Arrays.equals(this.digestValue.getDigest(), this.unmarshalledDigest);
        return new ValidateResultImpl(bl, this.digestValue, this.unmarshalledDigest, this.uri);
    }

    public String getURI() {
        return this.uri;
    }

    public void setUri(String string) {
        this.uri = string;
    }

    public String getType() {
        return this.type;
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    private String printB64(byte[] byArray) {
        CharSequence charSequence = XsTypeConverter.printHexBinary((byte[])byArray);
        return ((Object)charSequence).toString();
    }

    protected void createDigest(XMLCryptoContext xMLCryptoContext) throws URIReferenceException, XMLSignatureException {
        byte[] byArray;
        LogUtils.logDsig("creating digest for reference with uri: " + this.uri + " and algorithm: " + this.digestMethod.getAlgorithm());
        this.derefData = ReferenceUtils.dereference(this, xMLCryptoContext);
        Data data = ReferenceUtils.applyTransforms(this.derefData, this.appliedTransforms, xMLCryptoContext);
        byte[] byArray2 = null;
        try {
            byArray = byArray2 = DataUtils.getBytes(data);
            LogUtils.logDsig(new LogUtils.LogMethod(){

                public String log() {
                    return "digest input: " + ReferenceImpl.this.getString(byArray);
                }
            });
        }
        catch (IOException iOException) {
            throw new XMLSignatureException("Failed to convert transform result to digest input.", iOException);
        }
        byArray = ((WLDigestMethod)this.digestMethod).digest(byArray2);
        LogUtils.logDsig(new LogUtils.LogMethod(){

            public String log() {
                return "digest value: " + ReferenceImpl.this.printB64(byArray);
            }
        });
        this.digestValue = new DigestValueImpl(this.derefData, byArray2, byArray);
        if (this.unmarshalledDigest == null) {
            this.unmarshalledDigest = byArray;
        }
    }

    private void fillAppliedTransforms() {
        this.appliedTransforms = ReferenceUtils.getAppliedTransforms(this.transforms);
    }

    private static void addC14NTransform(List list) {
        try {
            list.add(TransformImpl.newTransform("http://www.w3.org/TR/2001/REC-xml-c14n-20010315"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public void write(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2000/09/xmldsig#", REFERENCE_ELEMENT);
            if (this.id != null) {
                xMLStreamWriter.writeAttribute("Id", this.id);
            }
            if (this.uri != null) {
                xMLStreamWriter.writeAttribute(URI_ATTRIBUTE, this.uri);
            }
            if (this.type != null) {
                xMLStreamWriter.writeAttribute(TYPE_ATTRIBUTE, this.type);
            }
            if (!this.transforms.isEmpty()) {
                this.writeTransforms(xMLStreamWriter);
            }
            ((WLXMLStructure)((Object)this.digestMethod)).write(xMLStreamWriter);
            if (this.digestValue != null) {
                this.writeDigestValue(xMLStreamWriter);
            }
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to write element Reference", xMLStreamException);
        }
    }

    public void read(XMLStreamReader xMLStreamReader) throws MarshalException {
        try {
            this.id = StaxUtils.getAttributeValue("http://www.w3.org/2000/09/xmldsig#", "Id", xMLStreamReader);
            this.uri = StaxUtils.getAttributeValue("http://www.w3.org/2000/09/xmldsig#", URI_ATTRIBUTE, xMLStreamReader);
            this.type = StaxUtils.getAttributeValue("http://www.w3.org/2000/09/xmldsig#", TYPE_ATTRIBUTE, xMLStreamReader);
            xMLStreamReader.nextTag();
            this.readTransforms(xMLStreamReader);
            this.digestMethod = DigestMethodImpl.newDigestMethod(xMLStreamReader);
            this.readDigestValue(xMLStreamReader);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to read Reference element.", xMLStreamException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MarshalException("Failed to instantiate object for child of Reference element.", noSuchAlgorithmException);
        }
    }

    private void readDigestValue(XMLStreamReader xMLStreamReader) throws XMLStreamException {
        xMLStreamReader.require(1, "http://www.w3.org/2000/09/xmldsig#", DIGESTVALUE_ELEMENT);
        final String string = xMLStreamReader.getElementText();
        this.unmarshalledDigest = Utils.base64(string);
        LogUtils.logDsig(new LogUtils.LogMethod(){

            public String log() {
                return "unmarshalled digest value: " + string + "\nbase 64 encoded: " + ReferenceImpl.this.printB64(ReferenceImpl.this.unmarshalledDigest);
            }
        });
        StaxUtils.forwardToEndElement("http://www.w3.org/2000/09/xmldsig#", REFERENCE_ELEMENT, xMLStreamReader);
    }

    private void readTransforms(XMLStreamReader xMLStreamReader) throws XMLStreamException, MarshalException {
        if ("http://www.w3.org/2000/09/xmldsig#".equals(xMLStreamReader.getNamespaceURI()) && TRANSFORMS_ELEMENT.equals(xMLStreamReader.getLocalName())) {
            xMLStreamReader.nextTag();
            while ("http://www.w3.org/2000/09/xmldsig#".equals(xMLStreamReader.getNamespaceURI()) && "Transform".equals(xMLStreamReader.getLocalName())) {
                this.transforms.add(TransformImpl.readTransform(xMLStreamReader));
                xMLStreamReader.nextTag();
            }
            this.fillAppliedTransforms();
            StaxUtils.findEnd(xMLStreamReader, "http://www.w3.org/2000/09/xmldsig#", TRANSFORMS_ELEMENT);
            xMLStreamReader.nextTag();
        }
    }

    private void writeTransforms(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2000/09/xmldsig#", TRANSFORMS_ELEMENT);
            Iterator iterator = this.transforms.iterator();
            while (iterator.hasNext()) {
                ((WLXMLStructure)iterator.next()).write(xMLStreamWriter);
            }
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to write element Reference", xMLStreamException);
        }
    }

    private void writeDigestValue(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2000/09/xmldsig#", DIGESTVALUE_ELEMENT);
            xMLStreamWriter.writeCharacters(Utils.base64(this.digestValue.getDigest()));
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to write element DigestValue", xMLStreamException);
        }
    }

    private String getString(byte[] byArray) {
        try {
            return "(as string, platform default encoding) " + new String(byArray);
        }
        catch (Exception exception) {
            return "(as hex) " + Hex.asHex((byte[])byArray, (int)byArray.length);
        }
    }

    public List getTransformURIs() {
        if (this.transformURIs == null) {
            this.transformURIs = new ArrayList();
            for (Transform transform : this.transforms) {
                this.transformURIs.add(transform.getAlgorithm());
            }
        }
        return this.transformURIs;
    }

    public String getDigestURI() {
        return this.digestMethod.getAlgorithm();
    }

    public boolean containsNode(Node node) {
        if (this.derefData instanceof NodeSetData) {
            return ((NodeSetData)this.derefData).contains(node);
        }
        return false;
    }

    public class ValidateResultImpl
    implements Reference.ValidateResult {
        private boolean status;
        private Reference.DigestValue digestValue;
        private String refURI;
        private byte[] unmarshalledDigestValue;

        protected ValidateResultImpl(boolean bl, Reference.DigestValue digestValue) {
            this(bl, digestValue, null, null);
        }

        protected ValidateResultImpl(boolean bl, Reference.DigestValue digestValue, byte[] byArray, String string) {
            this.status = bl;
            this.digestValue = digestValue;
            this.refURI = string;
            this.unmarshalledDigestValue = byArray;
        }

        public boolean status() {
            return this.status;
        }

        public Reference.DigestValue getDigestValue() {
            return this.digestValue;
        }

        public String getReferenceURI() {
            return this.refURI;
        }

        public String toString() {
            return "[ReferenceImpl.ValidateResultImpl:\n[refURI: " + this.refURI + "]" + "\n[status: " + this.status + "]" + "\n[digestValue: " + ReferenceImpl.this.printB64(this.digestValue.getDigest()) + "]" + "\n[unmarshalledDigestValue: " + ReferenceImpl.this.printB64(this.unmarshalledDigestValue) + "]]";
        }
    }

    public class DigestValueImpl
    implements Reference.DigestValue {
        private byte[] digest;
        private byte[] digestInput;
        private Data dereferencedData;

        protected DigestValueImpl(Data data, byte[] byArray, byte[] byArray2) {
            this.digestInput = byArray;
            this.digest = byArray2;
            this.dereferencedData = data;
        }

        public boolean isFeatureSupported(String string) {
            return false;
        }

        public byte[] getDigest() {
            return (byte[])this.digest.clone();
        }

        protected void setDigest(byte[] byArray) {
            this.digest = byArray;
        }

        public byte[] getDigestInput() {
            return (byte[])this.digestInput.clone();
        }

        protected void setDigestInput(byte[] byArray) {
            this.digestInput = byArray;
        }

        public Data getDereferencedData() {
            return this.dereferencedData;
        }

        protected void setDereferencedData(Data data) {
            this.dereferencedData = data;
        }
    }
}

