/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import weblogic.xml.crypto.api.Data;
import weblogic.xml.crypto.api.NodeSetData;
import weblogic.xml.crypto.api.URIReferenceException;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.dsig.DOMC14NTransform;
import weblogic.xml.crypto.dsig.ExclDOMC14NTransform;
import weblogic.xml.crypto.dsig.NodeTransform;
import weblogic.xml.crypto.dsig.OctetTransform;
import weblogic.xml.crypto.dsig.TransformImpl;
import weblogic.xml.crypto.dsig.WLTransform;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.utils.DataUtils;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.STRTransform;

public class ReferenceUtils {
    public static Data dereference(Reference reference, XMLCryptoContext xMLCryptoContext) throws URIReferenceException {
        Data data;
        final Data data2 = data = xMLCryptoContext.getURIDereferencer().dereference(reference, xMLCryptoContext);
        LogUtils.logDsig(new LogUtils.LogMethod(){

            public String log() {
                return "dereferenced data: " + DataUtils.toString(data2);
            }
        });
        return data;
    }

    public static Data applyTransforms(Data data, List list, XMLCryptoContext xMLCryptoContext) throws XMLSignatureException {
        if (data instanceof NodeSetData && list.isEmpty()) {
            ReferenceUtils.addC14NTransform(list);
        }
        for (WLTransform wLTransform : list) {
            LogUtils.logDsig("applying transform: " + wLTransform.getAlgorithm());
            final Data data2 = data = wLTransform.transform(data, xMLCryptoContext);
            LogUtils.logDsig(new LogUtils.LogMethod(){

                public String log() {
                    return "transformed data: " + DataUtils.toString(data2);
                }
            });
        }
        return data;
    }

    public static List getAppliedTransforms(List list) {
        ArrayList<TransformImpl> arrayList = new ArrayList<TransformImpl>();
        TransformImpl transformImpl = null;
        for (TransformImpl transformImpl2 : list) {
            if (transformImpl instanceof STRTransform && transformImpl2 instanceof ExclDOMC14NTransform) {
                LogUtils.logDsig(new LogUtils.LogMethod(){

                    public String log() {
                        return "exc-c14n transformer is removed after STR transformer";
                    }
                });
                continue;
            }
            if (transformImpl instanceof NodeTransform && transformImpl2 instanceof OctetTransform && !(transformImpl2 instanceof DOMC14NTransform) && !(transformImpl2 instanceof STRTransform)) {
                ReferenceUtils.addC14NTransform(arrayList);
            }
            arrayList.add(transformImpl2);
            transformImpl = transformImpl2;
        }
        if (transformImpl != null && transformImpl instanceof NodeTransform) {
            ReferenceUtils.addC14NTransform(arrayList);
        }
        return arrayList;
    }

    public static void addC14NTransform(List list) {
        try {
            list.add(TransformImpl.newTransform("http://www.w3.org/2001/10/xml-exc-c14n#"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public static List getTransforms(List arrayList) {
        if (arrayList == null || arrayList.isEmpty()) {
            arrayList = new ArrayList();
            ReferenceUtils.addC14NTransform(arrayList);
        }
        return arrayList;
    }
}

