/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.XMLStructure;
import weblogic.xml.crypto.dsig.SignatureMethodFactory;
import weblogic.xml.crypto.dsig.SignatureMethodImpl;
import weblogic.xml.crypto.dsig.WLSignatureMethod;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.dsig.api.SignatureMethod;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.dsig.api.spec.SignatureMethodParameterSpec;
import weblogic.xml.security.utils.Utils;

class SignatureMethodDSA
extends SignatureMethodImpl
implements SignatureMethodFactory,
SignatureMethod,
WLSignatureMethod,
XMLStructure,
WLXMLStructure {
    private static final String ALGORITHM_ID_SHA1 = "SHA1withDSA";
    private final String uri;
    private final String algorithmID;
    private final Signature algorithm;
    private SignatureMethodParameterSpec signatureMethodParameterSpec;

    private SignatureMethodDSA(String string, String string2) throws NoSuchAlgorithmException {
        this.uri = string;
        this.algorithmID = string2;
        this.algorithm = Signature.getInstance(ALGORITHM_ID_SHA1);
    }

    static void init() {
        try {
            SignatureMethodDSA.register(new SignatureMethodDSA("http://www.w3.org/2000/09/xmldsig#dsa-sha1", ALGORITHM_ID_SHA1));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public String getAlgorithm() {
        return this.uri;
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.signatureMethodParameterSpec;
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public String getURI() {
        return this.uri;
    }

    public SignatureMethod newSignatureMethod() {
        try {
            return new SignatureMethodDSA(this.uri, this.algorithmID);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    public String sign(Key key, byte[] byArray) throws XMLSignatureException {
        if (!(key instanceof PrivateKey)) {
            throw new XMLSignatureException(this.getURI() + " signing requires private key");
        }
        try {
            this.algorithm.initSign((PrivateKey)key);
            this.algorithm.update(byArray);
            byte[] byArray2 = this.algorithm.sign();
            byArray2 = this.convertJCAtoDSIG(byArray2);
            return Utils.base64(byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException(invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
    }

    public boolean verify(Key key, byte[] byArray, String string) throws XMLSignatureException {
        if (!(key instanceof PublicKey)) {
            throw new XMLSignatureException(this.getURI() + " verification requires public key");
        }
        try {
            this.algorithm.initVerify((PublicKey)key);
            this.algorithm.update(byArray);
            byte[] byArray2 = Utils.base64(string);
            byArray2 = this.convertDSIGtoJCA(byArray2);
            return this.algorithm.verify(byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException(invalidKeyException);
        }
        catch (SignatureException signatureException) {
            return false;
        }
    }

    public void readParameters(XMLStreamReader xMLStreamReader) throws MarshalException {
    }

    public void writeParameters(XMLStreamWriter xMLStreamWriter) throws MarshalException {
    }

    protected byte[] convertDSIGtoJCA(byte[] byArray) throws XMLSignatureException {
        if (byArray.length == 46) {
            int n = byArray.length;
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            return byArray2;
        }
        if (byArray.length != 40) {
            throw new XMLSignatureException("Invalid DSA signature");
        }
        int n = 6 + byArray.length;
        int n2 = (byArray[0] & 0x80) == 128 ? 1 : 0;
        int n3 = (byArray[20] & 0x80) == 128 ? 1 : 0;
        byte[] byArray3 = new byte[n += n2 + n3];
        byArray3[0] = 48;
        byArray3[1] = (byte)(4 + byArray.length + n2 + n3);
        byArray3[2] = 2;
        byArray3[3] = (byte)(20 + n2);
        System.arraycopy(byArray, 0, byArray3, 4 + n2, 20);
        byArray3[24 + n2] = 2;
        byArray3[25 + n2] = (byte)(20 + n3);
        System.arraycopy(byArray, 20, byArray3, 26 + n2 + n3, 20);
        return byArray3;
    }

    protected byte[] convertJCAtoDSIG(byte[] byArray) {
        byte[] byArray2 = new byte[40];
        byte by = byArray[3];
        byte by2 = byArray[by + 5];
        SignatureMethodDSA.I2OSP(byArray, 4, by, byArray2, 0, 20);
        SignatureMethodDSA.I2OSP(byArray, by + 6, by2, byArray2, 20, 20);
        return byArray2;
    }

    private static void I2OSP(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        if (n2 < n4) {
            int n5 = n3 + (n4 - n2);
            for (int i = n3; i < n5; ++i) {
                byArray2[i] = 0;
            }
            System.arraycopy(byArray, n, byArray2, n5, n2);
        } else {
            System.arraycopy(byArray, n + (n2 - n4), byArray2, n3, n4);
        }
    }
}

