/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.XMLStructure;
import weblogic.xml.crypto.dsig.SignatureMethodFactory;
import weblogic.xml.crypto.dsig.SignatureMethodImpl;
import weblogic.xml.crypto.dsig.WLSignatureMethod;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.dsig.api.SignatureMethod;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.dsig.api.spec.SignatureMethodParameterSpec;
import weblogic.xml.security.utils.Utils;

public class SignatureMethodHMAC
extends SignatureMethodImpl
implements SignatureMethodFactory,
SignatureMethod,
WLSignatureMethod,
XMLStructure,
WLXMLStructure {
    private static final String OUTPUTLENGTH_ELEMENT = "HMACOutputLength";
    private static final String ALGORITHM_ID_SHA1 = "HmacSHA1";
    private final String uri;
    private final String algorithmID;
    private final Mac algorithm;
    private SignatureMethodParameterSpec signatureMethodParameterSpec;
    private int outputLength = 160;

    public SignatureMethodHMAC(String string, String string2) throws NoSuchAlgorithmException {
        this.uri = string;
        this.algorithmID = string2;
        this.algorithm = Mac.getInstance(ALGORITHM_ID_SHA1);
    }

    static void init() {
        try {
            SignatureMethodHMAC.register(new SignatureMethodHMAC("http://www.w3.org/2000/09/xmldsig#hmac-sha1", ALGORITHM_ID_SHA1));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public String getAlgorithm() {
        return this.uri;
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.signatureMethodParameterSpec;
    }

    public String getURI() {
        return this.uri;
    }

    public SignatureMethod newSignatureMethod() {
        try {
            return new SignatureMethodHMAC(this.uri, this.algorithmID);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public String sign(Key key, byte[] byArray) throws XMLSignatureException {
        try {
            this.algorithm.init(key);
            this.algorithm.update(byArray);
            byte[] byArray2 = new byte[this.outputLength / 8];
            byte[] byArray3 = this.algorithm.doFinal();
            System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
            return Utils.base64(byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("Invalid key", invalidKeyException);
        }
    }

    public boolean verify(Key key, byte[] byArray, String string) throws XMLSignatureException {
        try {
            this.algorithm.init(key);
            this.algorithm.update(byArray);
            byte[] byArray2 = this.algorithm.doFinal();
            byte[] byArray3 = Utils.base64(string);
            int n = this.outputLength / 8;
            for (int i = 0; i < n; ++i) {
                if (byArray2[i] == byArray3[i]) continue;
                return false;
            }
            return true;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException("Invalid key", invalidKeyException);
        }
    }

    public void readParameters(XMLStreamReader xMLStreamReader) throws MarshalException {
        String string = null;
        try {
            xMLStreamReader.nextTag();
            if (!xMLStreamReader.getName().equals(new QName("http://www.w3.org/2000/09/xmldsig#", OUTPUTLENGTH_ELEMENT))) {
                return;
            }
            xMLStreamReader.next();
            string = xMLStreamReader.getText();
            if (string == null) {
                return;
            }
            this.outputLength = Integer.parseInt(string);
            if (this.outputLength != 160) {
                throw new MarshalException("Invalid HMACOutputLength: " + string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new MarshalException("Invalid HMACOutputLength: " + string);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to read HMACOutputLength.");
        }
    }

    public void writeParameters(XMLStreamWriter xMLStreamWriter) throws MarshalException {
    }
}

