/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.security.NoSuchAlgorithmException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.dsig.SignatureMethodDSA;
import weblogic.xml.crypto.dsig.SignatureMethodFactory;
import weblogic.xml.crypto.dsig.SignatureMethodHMAC;
import weblogic.xml.crypto.dsig.SignatureMethodRSA;
import weblogic.xml.crypto.dsig.api.SignatureMethod;
import weblogic.xml.crypto.dsig.api.spec.SignatureMethodParameterSpec;
import weblogic.xml.crypto.utils.StaxUtils;

public abstract class SignatureMethodImpl {
    public static final String SIGNATUREMETHOD_ELEMENT = "SignatureMethod";
    public static final String ALGORITHM_ATTRIBUTE = "Algorithm";
    private static final ConcurrentHashMap factories = new ConcurrentHashMap();

    private static final void initFactories() {
        SignatureMethodRSA.init();
        SignatureMethodDSA.init();
        SignatureMethodHMAC.init();
    }

    public static void register(SignatureMethodFactory signatureMethodFactory) {
        factories.put((Object)signatureMethodFactory.getURI(), (Object)signatureMethodFactory);
    }

    public static SignatureMethod newSignatureMethod(String string) throws NoSuchAlgorithmException {
        return SignatureMethodImpl.newSignatureMethod(string, null);
    }

    public static SignatureMethod newSignatureMethod(String string, SignatureMethodParameterSpec signatureMethodParameterSpec) throws NoSuchAlgorithmException {
        SignatureMethodFactory signatureMethodFactory = (SignatureMethodFactory)factories.get((Object)string);
        if (signatureMethodFactory == null) {
            throw new NoSuchAlgorithmException(string + " not supported.");
        }
        return signatureMethodFactory.newSignatureMethod();
    }

    public void write(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2000/09/xmldsig#", SIGNATUREMETHOD_ELEMENT);
            xMLStreamWriter.writeAttribute(ALGORITHM_ATTRIBUTE, this.getAlgorithm());
            this.writeParameters(xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to write element SignatureMethod", xMLStreamException);
        }
    }

    public void read(XMLStreamReader xMLStreamReader) throws MarshalException {
        try {
            this.readParameters(xMLStreamReader);
            StaxUtils.forwardToEndElement("http://www.w3.org/2000/09/xmldsig#", SIGNATUREMETHOD_ELEMENT, xMLStreamReader);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to read SignatureMethod " + this.getAlgorithm() + ".", xMLStreamException);
        }
    }

    public abstract String getAlgorithm();

    public abstract void writeParameters(XMLStreamWriter var1) throws MarshalException;

    public abstract void readParameters(XMLStreamReader var1) throws MarshalException;

    static {
        SignatureMethodImpl.initFactories();
    }
}

