/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.XMLStructure;
import weblogic.xml.crypto.dsig.SignatureMethodFactory;
import weblogic.xml.crypto.dsig.SignatureMethodImpl;
import weblogic.xml.crypto.dsig.WLSignatureMethod;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.dsig.api.SignatureMethod;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.dsig.api.spec.SignatureMethodParameterSpec;
import weblogic.xml.security.utils.Utils;

class SignatureMethodRSA
extends SignatureMethodImpl
implements SignatureMethodFactory,
SignatureMethod,
WLSignatureMethod,
XMLStructure,
WLXMLStructure {
    private static final String ALGORITHM_ID_SHA1 = "SHA1withRSA";
    private final String uri;
    private final String algorithmID;
    private final Signature algorithm;
    private SignatureMethodParameterSpec signatureMethodParameterSpec;

    private SignatureMethodRSA(String string, String string2) throws NoSuchAlgorithmException {
        this.uri = string;
        this.algorithmID = string2;
        this.algorithm = Signature.getInstance(ALGORITHM_ID_SHA1);
    }

    static void init() {
        try {
            SignatureMethodRSA.register(new SignatureMethodRSA("http://www.w3.org/2000/09/xmldsig#rsa-sha1", ALGORITHM_ID_SHA1));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public String getAlgorithm() {
        return this.uri;
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.signatureMethodParameterSpec;
    }

    public String getURI() {
        return this.uri;
    }

    public SignatureMethod newSignatureMethod() {
        try {
            return new SignatureMethodRSA(this.uri, this.algorithmID);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public String sign(Key key, byte[] byArray) throws XMLSignatureException {
        if (!(key instanceof PrivateKey)) {
            throw new XMLSignatureException(this.getURI() + " signing requires private key");
        }
        try {
            this.algorithm.initSign((PrivateKey)key);
            this.algorithm.update(byArray);
            byte[] byArray2 = this.algorithm.sign();
            return Utils.base64(byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException(invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw new XMLSignatureException(signatureException);
        }
    }

    public boolean verify(Key key, byte[] byArray, String string) throws XMLSignatureException {
        if (!(key instanceof PublicKey)) {
            throw new XMLSignatureException(this.getURI() + " verification requires public key");
        }
        try {
            this.algorithm.initVerify((PublicKey)key);
            this.algorithm.update(byArray);
            byte[] byArray2 = Utils.base64(string);
            return this.algorithm.verify(byArray2);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException(invalidKeyException);
        }
        catch (SignatureException signatureException) {
            return false;
        }
    }

    public void readParameters(XMLStreamReader xMLStreamReader) throws MarshalException {
    }

    public void writeParameters(XMLStreamWriter xMLStreamWriter) throws MarshalException {
    }
}

