/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.util.List;
import weblogic.xml.crypto.api.KeySelectorResult;
import weblogic.xml.crypto.dsig.api.Reference;

public class SignatureValidateResult {
    boolean status;
    String signature;
    KeySelectorResult keySelectorResult;
    List refValidateResults;
    boolean refStatus = true;

    protected SignatureValidateResult(boolean bl, String string, KeySelectorResult keySelectorResult, List list) {
        this.status = bl;
        this.signature = string;
        this.keySelectorResult = keySelectorResult;
        this.refValidateResults = list;
        for (Reference.ValidateResult validateResult : list) {
            if (validateResult.status()) continue;
            this.refStatus = false;
            break;
        }
    }

    public boolean status() {
        return this.status;
    }

    public String getSignatureValue() {
        return this.signature;
    }

    public KeySelectorResult getKeySelectorResult() {
        return this.keySelectorResult;
    }

    public List getReferenceValidateResults() {
        return this.refValidateResults;
    }

    public boolean getReferenceValidationStatus() {
        return this.refStatus;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.refValidateResults != null) {
            for (int i = 0; i < this.refValidateResults.size(); ++i) {
                stringBuffer.append("\n" + this.refValidateResults.get(i));
            }
        }
        return "[SignatureValidationResult:\n[status: " + this.status + "]" + "\n[signature: " + this.signature + "]" + "\n[keySelectorResult: " + this.keySelectorResult + "]" + "\n[refValidationResults: " + stringBuffer + "]]";
    }

    public String toFaultString() {
        String string = "";
        if (!this.status) {
            string = "SignatureValue: " + this.signature + " does not validate.";
        }
        for (Reference.ValidateResult validateResult : this.refValidateResults) {
            if (validateResult.status()) continue;
            string = string + " Reference: " + validateResult.getReferenceURI() + " does not validate.\n";
        }
        return string;
    }
}

