/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.io.OutputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.utils.io.UnsyncByteArrayOutputStream;
import weblogic.xml.crypto.api.KeySelector;
import weblogic.xml.crypto.api.KeySelectorException;
import weblogic.xml.crypto.api.KeySelectorResult;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.api.XMLStructure;
import weblogic.xml.crypto.dsig.CanonicalizationMethodImpl;
import weblogic.xml.crypto.dsig.ReferenceImpl;
import weblogic.xml.crypto.dsig.SignatureMethodImpl;
import weblogic.xml.crypto.dsig.WLCanonicalizationMethod;
import weblogic.xml.crypto.dsig.WLSignatureMethod;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.dsig.api.CanonicalizationMethod;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.api.SignatureMethod;
import weblogic.xml.crypto.dsig.api.SignedInfo;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfo;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.utils.StaxUtils;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class SignedInfoImpl
implements SignedInfo,
XMLStructure,
WLXMLStructure {
    public static final String SIGNEDINFO_ELEMENT = "SignedInfo";
    private CanonicalizationMethod c14nMethod;
    private SignatureMethod signatureMethod;
    private List refs;
    private transient String id;
    private KeySelectorResult ksr;

    SignedInfoImpl(CanonicalizationMethod canonicalizationMethod, SignatureMethod signatureMethod, List list) {
        this(canonicalizationMethod, signatureMethod, list, null);
    }

    SignedInfoImpl(CanonicalizationMethod canonicalizationMethod, SignatureMethod signatureMethod, List list, String string) {
        if (canonicalizationMethod == null || signatureMethod == null || list == null) {
            throw new NullPointerException("CanonicalizationMethod, SignatuareMethod, and List references must not be null.");
        }
        this.c14nMethod = canonicalizationMethod;
        this.signatureMethod = signatureMethod;
        this.refs = list;
        this.id = string;
    }

    public SignedInfoImpl() {
        this.refs = new ArrayList();
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public CanonicalizationMethod getCanonicalizationMethod() {
        return this.c14nMethod;
    }

    public String getId() {
        return this.id;
    }

    public List getReferences() {
        return Collections.unmodifiableList(this.refs);
    }

    public SignatureMethod getSignatureMethod() {
        return this.signatureMethod;
    }

    public void addReference(Reference reference) {
        if (null == reference) {
            throw new IllegalArgumentException("Reference is null");
        }
        this.refs.add(reference);
    }

    protected String createSignature(XMLCryptoContext xMLCryptoContext, KeyInfo keyInfo, XMLInputStream xMLInputStream, Map map) throws XMLSignatureException {
        byte[] byArray = this.c14n(xMLInputStream, map);
        Key key = null;
        try {
            key = this.getSignKey(xMLCryptoContext, keyInfo);
        }
        catch (KeySelectorException keySelectorException) {
            throw new XMLSignatureException("Failed to get key for signing.", keySelectorException);
        }
        return ((WLSignatureMethod)((Object)this.signatureMethod)).sign(key, byArray);
    }

    boolean validateSignature(XMLCryptoContext xMLCryptoContext, KeyInfo keyInfo, String string, XMLInputStream xMLInputStream, Map map) throws XMLSignatureException {
        byte[] byArray = this.c14n(xMLInputStream, map);
        Key key = null;
        try {
            key = this.getVerifyKey(xMLCryptoContext, keyInfo);
        }
        catch (KeySelectorException keySelectorException) {
            throw new XMLSignatureException("Failed to get key for validating.", keySelectorException);
        }
        return ((WLSignatureMethod)((Object)this.signatureMethod)).verify(key, byArray, string);
    }

    public void write(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2000/09/xmldsig#", SIGNEDINFO_ELEMENT);
            if (this.id != null) {
                xMLStreamWriter.writeAttribute("Id", this.id);
            }
            ((WLXMLStructure)((Object)this.c14nMethod)).write(xMLStreamWriter);
            ((WLXMLStructure)((Object)this.signatureMethod)).write(xMLStreamWriter);
            if (this.refs != null) {
                Iterator iterator = this.refs.iterator();
                while (iterator.hasNext()) {
                    ((WLXMLStructure)iterator.next()).write(xMLStreamWriter);
                }
            }
            xMLStreamWriter.writeEndElement();
        }
        catch (javax.xml.stream.XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to write element SignedInfo", xMLStreamException);
        }
    }

    public void read(XMLStreamReader xMLStreamReader) throws MarshalException {
        try {
            xMLStreamReader.require(1, "http://www.w3.org/2000/09/xmldsig#", SIGNEDINFO_ELEMENT);
            this.id = StaxUtils.getAttributeValue("http://www.w3.org/2000/09/xmldsig#", "Id", xMLStreamReader);
            xMLStreamReader.nextTag();
            String string = StaxUtils.getAttributeValue("http://www.w3.org/2000/09/xmldsig#", "Algorithm", xMLStreamReader);
            this.c14nMethod = CanonicalizationMethodImpl.newCanonicalizationMethod(string);
            ((WLXMLStructure)((Object)this.c14nMethod)).read(xMLStreamReader);
            xMLStreamReader.nextTag();
            xMLStreamReader.require(1, "http://www.w3.org/2000/09/xmldsig#", "SignatureMethod");
            String string2 = StaxUtils.getAttributeValue("http://www.w3.org/2000/09/xmldsig#", "Algorithm", xMLStreamReader);
            this.signatureMethod = SignatureMethodImpl.newSignatureMethod(string2);
            ((WLXMLStructure)((Object)this.signatureMethod)).read(xMLStreamReader);
            xMLStreamReader.nextTag();
            xMLStreamReader.require(1, "http://www.w3.org/2000/09/xmldsig#", "Reference");
            while ("http://www.w3.org/2000/09/xmldsig#".equals(xMLStreamReader.getNamespaceURI()) && "Reference".equals(xMLStreamReader.getLocalName())) {
                this.readReference(xMLStreamReader);
                xMLStreamReader.nextTag();
            }
            StaxUtils.forwardToEndElement("http://www.w3.org/2000/09/xmldsig#", SIGNEDINFO_ELEMENT, xMLStreamReader);
        }
        catch (javax.xml.stream.XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to read SignedInfoelement.", xMLStreamException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MarshalException("Failed to instantiate object for child of SignedInfo element.", noSuchAlgorithmException);
        }
    }

    private void readReference(XMLStreamReader xMLStreamReader) throws MarshalException {
        ReferenceImpl referenceImpl = new ReferenceImpl();
        referenceImpl.read(xMLStreamReader);
        this.refs.add(referenceImpl);
    }

    private byte[] c14n(XMLInputStream xMLInputStream, Map map) throws XMLSignatureException {
        byte[] byArray;
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        XMLOutputStream xMLOutputStream = ((WLCanonicalizationMethod)this.c14nMethod).canonicalize((OutputStream)unsyncByteArrayOutputStream, map);
        try {
            xMLOutputStream.add(xMLInputStream);
            xMLOutputStream.close(true);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XMLSignatureException("canonicalization error", xMLStreamException);
        }
        final byte[] byArray2 = byArray = unsyncByteArrayOutputStream.toByteArray();
        LogUtils.logDsig(new LogUtils.LogMethod(){

            public String log() {
                return "Canonicalized SignedInfo element: " + new String(byArray2);
            }
        });
        return byArray;
    }

    private Key getSignKey(XMLCryptoContext xMLCryptoContext, KeyInfo keyInfo) throws KeySelectorException {
        KeySelectorResult keySelectorResult = xMLCryptoContext.getKeySelector().select(keyInfo, KeySelector.Purpose.SIGN, this.signatureMethod, xMLCryptoContext);
        return keySelectorResult.getKey();
    }

    private Key getVerifyKey(XMLCryptoContext xMLCryptoContext, KeyInfo keyInfo) throws KeySelectorException {
        this.ksr = xMLCryptoContext.getKeySelector().select(keyInfo, KeySelector.Purpose.VERIFY, this.signatureMethod, xMLCryptoContext);
        return this.ksr.getKey();
    }

    public KeySelectorResult getKeySelectorResult() {
        return this.ksr;
    }
}

