/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.xml.crypto.api.Data;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.dsig.Base64Transform;
import weblogic.xml.crypto.dsig.DOMC14NTransform;
import weblogic.xml.crypto.dsig.EnvelopedSignatureTransform;
import weblogic.xml.crypto.dsig.ExclDOMC14NTransform;
import weblogic.xml.crypto.dsig.TransformFactory;
import weblogic.xml.crypto.dsig.WLTransform;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.dsig.XPathFilter2Transform;
import weblogic.xml.crypto.dsig.XPathTransform;
import weblogic.xml.crypto.dsig.api.Transform;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.dsig.api.spec.TransformParameterSpec;
import weblogic.xml.crypto.utils.StaxUtils;

public abstract class TransformImpl
implements WLXMLStructure,
WLTransform {
    public static final String ALGORITHM_ATTRIBUTE = "Algorithm";
    public static final String TRANSFORM_ELEMENT = "Transform";
    private static final ConcurrentHashMap factories = new ConcurrentHashMap();

    private static final void initTransformFactories() {
        XPathTransform.init();
        XPathFilter2Transform.init();
        DOMC14NTransform.init();
        ExclDOMC14NTransform.init();
        EnvelopedSignatureTransform.init();
        Base64Transform.init();
    }

    public static void register(TransformFactory transformFactory) {
        factories.put((Object)transformFactory.getURI(), (Object)transformFactory);
    }

    static Transform newTransform(String string, TransformParameterSpec transformParameterSpec) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        TransformFactory transformFactory = (TransformFactory)factories.get((Object)string);
        if (transformFactory == null) {
            throw new NoSuchAlgorithmException(string + " not supported");
        }
        return transformFactory.newTransform(transformParameterSpec);
    }

    protected static Transform newTransform(String string) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        return TransformImpl.newTransform(string, null);
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public abstract String getAlgorithm();

    public AlgorithmParameterSpec getParameterSpec() {
        return null;
    }

    public abstract Data transform(Data var1, XMLCryptoContext var2) throws XMLSignatureException;

    public final void write(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2000/09/xmldsig#", TRANSFORM_ELEMENT);
            xMLStreamWriter.writeAttribute(ALGORITHM_ATTRIBUTE, this.getAlgorithm());
            this.writeParameters(xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to write element Transform", xMLStreamException);
        }
    }

    protected void writeParameters(XMLStreamWriter xMLStreamWriter) throws MarshalException {
    }

    public final void read(XMLStreamReader xMLStreamReader) throws MarshalException {
        try {
            xMLStreamReader.require(1, "http://www.w3.org/2000/09/xmldsig#", TRANSFORM_ELEMENT);
            String string = StaxUtils.getAttributeValue("http://www.w3.org/2000/09/xmldsig#", ALGORITHM_ATTRIBUTE, xMLStreamReader);
            this.setAlgorithm(string);
            this.readParameters(xMLStreamReader);
            StaxUtils.forwardToEndElement("http://www.w3.org/2000/09/xmldsig#", TRANSFORM_ELEMENT, xMLStreamReader);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to read Transform " + this.getAlgorithm() + ".", xMLStreamException);
        }
    }

    protected void readParameters(XMLStreamReader xMLStreamReader) throws MarshalException {
    }

    protected void setAlgorithm(String string) {
    }

    public static WLTransform readTransform(XMLStreamReader xMLStreamReader) throws MarshalException {
        String string = StaxUtils.getAttributeValue("http://www.w3.org/2000/09/xmldsig#", ALGORITHM_ATTRIBUTE, xMLStreamReader);
        Transform transform = null;
        try {
            transform = TransformImpl.newTransform(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MarshalException("Failed to instantiate object for " + string + " transform.", noSuchAlgorithmException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new MarshalException("Failed to instantiate object for " + string + " transform.", invalidAlgorithmParameterException);
        }
        ((WLXMLStructure)((Object)transform)).read(xMLStreamReader);
        return (WLTransform)transform;
    }

    static {
        TransformImpl.initTransformFactories();
    }
}

