/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Node;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.dom.DOMStructure;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.dsig.api.XMLObject;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.utils.StaxUtils;
import weblogic.xml.dom.Util;

public class XMLObjectImpl
implements XMLObject,
WLXMLStructure {
    private static final String OBJECT_ELEMENT = "Object";
    private static final String MIMETYPE_ATTRIBUTE = "MimeType";
    private static final String ENCODING_ATTRIBUTE = "Encoding";
    private List content;
    private String id;
    private String mimeType;
    private String encoding;

    public XMLObjectImpl(List list, String string, String string2, String string3) {
        this.content = list;
        this.id = string;
        this.mimeType = string2;
        this.encoding = string3;
    }

    public List getContent() {
        return Collections.unmodifiableList(this.content);
    }

    public String getId() {
        return this.id;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public void write(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2000/09/xmldsig#", OBJECT_ELEMENT);
            if (this.id != null) {
                xMLStreamWriter.writeAttribute("Id", this.id);
            }
            if (this.mimeType != null) {
                xMLStreamWriter.writeAttribute(MIMETYPE_ATTRIBUTE, this.mimeType);
            }
            if (this.encoding != null) {
                xMLStreamWriter.writeAttribute(ENCODING_ATTRIBUTE, this.encoding);
            }
            if (this.content != null && !this.content.isEmpty()) {
                this.writeContent(this.content, xMLStreamWriter);
            }
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to write element Object", xMLStreamException);
        }
    }

    public void read(XMLStreamReader xMLStreamReader) throws MarshalException {
    }

    private void writeContent(List list, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        for (DOMStructure dOMStructure : list) {
            final Node node = dOMStructure.getNode();
            LogUtils.logDsig(new LogUtils.LogMethod(){

                public String log() {
                    return "writing Object content node: " + Util.printNode(node);
                }
            });
            StaxUtils.writeNode(xMLStreamWriter, node);
        }
    }
}

