/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.io.Serializable;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import weblogic.xml.crypto.NodeURIDereferencer;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.URIReferenceException;
import weblogic.xml.crypto.api.dom.DOMSignContext;
import weblogic.xml.crypto.api.dom.DOMValidateContext;
import weblogic.xml.crypto.dom.WLDOMSignContextImpl;
import weblogic.xml.crypto.dom.WLDOMValidateContextImpl;
import weblogic.xml.crypto.dsig.CanonicalizationMethodW3C;
import weblogic.xml.crypto.dsig.ReferenceImpl;
import weblogic.xml.crypto.dsig.SignatureValidateResult;
import weblogic.xml.crypto.dsig.SignedInfoImpl;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.dsig.api.CanonicalizationMethod;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.api.SignedInfo;
import weblogic.xml.crypto.dsig.api.XMLSignContext;
import weblogic.xml.crypto.dsig.api.XMLSignature;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.dsig.api.XMLValidateContext;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfo;
import weblogic.xml.crypto.dsig.keyinfo.KeyInfoImpl;
import weblogic.xml.crypto.encrypt.Utils;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.utils.DebugStreamReader;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.crypto.wss.SignatureInfo;
import weblogic.xml.dom.DOMStreamReader;
import weblogic.xml.dom.DOMStreamWriter;
import weblogic.xml.stax.util.NamespaceContextImpl;
import weblogic.xml.stream.XMLStreamException;

public class XMLSignatureImpl
implements XMLSignature,
SignatureInfo,
Serializable {
    private static final long serialVersionUID = 1946531379486808596L;
    public static final String DEBUG_PROPERTY = "weblogic.xml.crypto.dsig.debug";
    public static final boolean DEBUG = Boolean.getBoolean("weblogic.xml.crypto.dsig.debug");
    public static final String SIGNATURE_ELEMENT = "Signature";
    public static final String SIGNATUREVALUE_ELEMENT = "SignatureValue";
    public static final String ID_ATTRIBUTE = "Id";
    private SignedInfo signedInfo;
    private transient KeyInfo keyInfo;
    private transient List objects;
    private transient String id;
    private transient String signatureValueId;
    private transient String unmarshalledSignatureValue;
    private transient String signatureValue;
    private transient Node signedInfoNode;
    private transient Element signatureNode;
    private transient NamespaceContextImpl namespaceContext;
    private transient Map namespaceMap = new HashMap();
    private SignatureValidateResult signatureValidateResult;

    XMLSignatureImpl(SignedInfo signedInfo, KeyInfo keyInfo) {
        this(signedInfo, keyInfo, null, null, null);
    }

    XMLSignatureImpl(SignedInfo signedInfo, KeyInfo keyInfo, List list, String string, String string2) {
        this.signedInfo = signedInfo;
        this.keyInfo = keyInfo;
        this.objects = list;
        this.id = string;
        this.signatureValueId = string2;
    }

    XMLSignatureImpl(XMLValidateContext xMLValidateContext) throws MarshalException {
        this.unmarshal(xMLValidateContext);
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public String getId() {
        return this.id;
    }

    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public List getObjects() {
        if (this.objects != null) {
            return Collections.unmodifiableList(this.objects);
        }
        return Collections.EMPTY_LIST;
    }

    public byte[] getSignatureValue() {
        if (this.unmarshalledSignatureValue != null) {
            return Utils.base64(this.unmarshalledSignatureValue);
        }
        if (this.signatureValue != null) {
            return Utils.base64(this.signatureValue);
        }
        return null;
    }

    public String getSignatureValueId() {
        return this.signatureValueId;
    }

    public SignedInfo getSignedInfo() {
        return this.signedInfo;
    }

    public Element getSignatureNode() {
        return this.signatureNode;
    }

    public void sign(XMLSignContext xMLSignContext) throws MarshalException, XMLSignatureException {
        if (xMLSignContext == null) {
            throw new NullPointerException("Context must not be null.");
        }
        WLDOMSignContextImpl wLDOMSignContextImpl = (WLDOMSignContextImpl)xMLSignContext;
        wLDOMSignContextImpl.setXMLSignature(this);
        this.ensureURIDereferencer(wLDOMSignContextImpl);
        try {
            Object object = this.createSignatureNode(wLDOMSignContextImpl);
            this.createSignedInfoNode((DOMStreamWriter)((Object)object));
            Node node = wLDOMSignContextImpl.getNextSibling();
            if (node != null) {
                wLDOMSignContextImpl.getParent().insertBefore(this.signatureNode, node);
            } else {
                wLDOMSignContextImpl.getParent().appendChild(this.signatureNode);
            }
            object = this.signedInfo.getReferences().iterator();
            while (object.hasNext()) {
                ((ReferenceImpl)object.next()).createDigest(xMLSignContext);
            }
            wLDOMSignContextImpl.getParent().removeChild(this.signatureNode);
            object = this.createSignatureNode(wLDOMSignContextImpl);
            this.createSignedInfoNode((DOMStreamWriter)((Object)object));
            node = wLDOMSignContextImpl.getNextSibling();
            if (node != null) {
                wLDOMSignContextImpl.getParent().insertBefore(this.signatureNode, node);
            } else {
                wLDOMSignContextImpl.getParent().appendChild(this.signatureNode);
            }
            this.signedInfoNode = this.signatureNode.getFirstChild();
            CanonicalizationMethod canonicalizationMethod = this.signedInfo.getCanonicalizationMethod();
            if (canonicalizationMethod instanceof CanonicalizationMethodW3C) {
                ((CanonicalizationMethodW3C)canonicalizationMethod).setupNonVisiblyUsed(this.signedInfoNode, this.namespaceMap, xMLSignContext);
            }
            this.signatureValue = ((SignedInfoImpl)this.signedInfo).createSignature(xMLSignContext, this.keyInfo, DOMUtils.getXMLInputStream(this.signedInfoNode), this.namespaceMap);
            this.createSignatureValueNode((XMLStreamWriter)object);
            this.createKeyInfoNode((DOMStreamWriter)((Object)object));
            this.createObjectNodes((DOMStreamWriter)((Object)object));
        }
        catch (URIReferenceException uRIReferenceException) {
            throw new XMLSignatureException("Failed to resolve URI reference.", uRIReferenceException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XMLSignatureException("Failed to create signature.", xMLStreamException);
        }
    }

    public boolean validate(XMLValidateContext xMLValidateContext) throws XMLSignatureException {
        if (this.unmarshalledSignatureValue == null) {
            try {
                this.unmarshal(xMLValidateContext);
            }
            catch (MarshalException marshalException) {
                throw new XMLSignatureException("Failed to unmarshal signature element.", marshalException);
            }
        }
        WLDOMValidateContextImpl wLDOMValidateContextImpl = (WLDOMValidateContextImpl)xMLValidateContext;
        wLDOMValidateContextImpl.setSignatureNode(this.signatureNode);
        this.ensureURIDereferencer(wLDOMValidateContextImpl);
        boolean bl = true;
        ArrayList<Reference.ValidateResult> arrayList = new ArrayList<Reference.ValidateResult>();
        for (WLXMLStructure wLXMLStructure : this.signedInfo.getReferences()) {
            Reference.ValidateResult validateResult = ((ReferenceImpl)wLXMLStructure).validate(xMLValidateContext);
            if (!validateResult.status()) {
                bl = false;
            }
            arrayList.add(validateResult);
        }
        boolean bl2 = true;
        try {
            WLXMLStructure wLXMLStructure;
            wLXMLStructure = (SignedInfoImpl)this.signedInfo;
            bl2 = ((SignedInfoImpl)wLXMLStructure).validateSignature(xMLValidateContext, this.keyInfo, this.unmarshalledSignatureValue, DOMUtils.getXMLInputStream(this.signedInfoNode), this.namespaceMap);
            this.signatureValidateResult = new SignatureValidateResult(bl2, this.unmarshalledSignatureValue, ((SignedInfoImpl)wLXMLStructure).getKeySelectorResult(), arrayList);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XMLSignatureException("Failed to canonicalize SignedInfo element.", xMLStreamException);
        }
        LogUtils.logDsig(this.signatureValidateResult);
        return bl && bl2;
    }

    private void unmarshal(XMLValidateContext xMLValidateContext) throws MarshalException {
        Element element;
        WLDOMValidateContextImpl wLDOMValidateContextImpl = (WLDOMValidateContextImpl)xMLValidateContext;
        this.signatureNode = (Element)wLDOMValidateContextImpl.getNode();
        if (this.signatureNode.getNodeType() != 1 || !this.signatureNode.getLocalName().equals(SIGNATURE_ELEMENT) || !this.signatureNode.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) {
            throw new MarshalException("Node on context is not a Signature node.");
        }
        if (this.signatureNode.hasAttributeNS("http://www.w3.org/2000/09/xmldsig#", ID_ATTRIBUTE)) {
            this.signatureValueId = this.signatureNode.getAttributeNS("http://www.w3.org/2000/09/xmldsig#", ID_ATTRIBUTE);
        }
        this.fillNamespaceContext(this.signatureNode, null);
        String string = this.namespaceContext.getPrefix("http://www.w3.org/2000/09/xmldsig#");
        Node node = this.signatureNode.getFirstChild();
        this.signedInfoNode = this.getNextSibling(node, "http://www.w3.org/2000/09/xmldsig#", "SignedInfo", false);
        this.signedInfo = new SignedInfoImpl();
        ((WLXMLStructure)((Object)this.signedInfo)).read(this.getXMLStreamReader(this.signedInfoNode));
        Element element2 = (Element)this.getNextSibling(this.signedInfoNode.getNextSibling(), "http://www.w3.org/2000/09/xmldsig#", SIGNATUREVALUE_ELEMENT, false);
        element2.normalize();
        this.unmarshalledSignatureValue = element2.getFirstChild().getNodeValue();
        if (element2.hasAttributeNS("http://www.w3.org/2000/09/xmldsig#", ID_ATTRIBUTE)) {
            this.signatureValueId = element2.getAttributeNS("http://www.w3.org/2000/09/xmldsig#", ID_ATTRIBUTE);
        }
        if ((element = (Element)this.getNextSibling(element2.getNextSibling(), "http://www.w3.org/2000/09/xmldsig#", "KeyInfo", true)) != null) {
            this.keyInfo = new KeyInfoImpl();
            ((KeyInfoImpl)this.keyInfo).read(this.getXMLStreamReader(element));
        }
    }

    private Node getNextSibling(Node node, String string, String string2, boolean bl) throws MarshalException {
        if (node == null) {
            return null;
        }
        while (node.getNodeType() == 8 || node.getNodeType() == 3) {
            if ((node = node.getNextSibling()) != null) continue;
            return null;
        }
        if (node.getNodeType() != 1 || !node.getLocalName().equals(string2) || !node.getNamespaceURI().equals(string)) {
            if (bl) {
                return null;
            }
            throw new MarshalException("Failed to find expected node: " + string + ":" + string2 + ". " + "Found instead: " + node.getNamespaceURI() + ":" + node.getLocalName());
        }
        return node;
    }

    private XMLStreamReader getXMLStreamReader(Node node) throws MarshalException {
        XMLStreamReader xMLStreamReader = null;
        try {
            xMLStreamReader = new DOMStreamReader(node);
        }
        catch (javax.xml.stream.XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to create XMLStreamReader from " + node.getNodeName(), xMLStreamException);
        }
        if (DEBUG) {
            xMLStreamReader = new DebugStreamReader(xMLStreamReader);
        }
        return xMLStreamReader;
    }

    private void createSignedInfoNode(DOMStreamWriter dOMStreamWriter) throws MarshalException {
        ((SignedInfoImpl)this.signedInfo).write((XMLStreamWriter)((Object)dOMStreamWriter));
    }

    private void createKeyInfoNode(DOMStreamWriter dOMStreamWriter) throws MarshalException {
        if (this.keyInfo != null) {
            ((WLXMLStructure)((Object)this.keyInfo)).write((XMLStreamWriter)((Object)dOMStreamWriter));
        }
    }

    private void createObjectNodes(DOMStreamWriter dOMStreamWriter) throws MarshalException {
        if (this.objects != null) {
            Iterator iterator = this.objects.iterator();
            while (iterator.hasNext()) {
                ((WLXMLStructure)iterator.next()).write((XMLStreamWriter)((Object)dOMStreamWriter));
            }
        }
    }

    private DOMStreamWriter createSignatureNode(DOMSignContext dOMSignContext) throws MarshalException {
        Node node = dOMSignContext.getParent();
        if (node == null) {
            throw new MarshalException("Parent node in DOMSignContext is null.");
        }
        Document document = null;
        document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        this.fillNamespaceContext(node, dOMSignContext);
        String string = this.namespaceContext.getPrefix("http://www.w3.org/2000/09/xmldsig#");
        this.signatureNode = null;
        if (string != null) {
            this.signatureNode = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", string + ":" + SIGNATURE_ELEMENT);
        } else {
            this.signatureNode = document.createElementNS("http://www.w3.org/2000/09/xmldsig#", "dsig:Signature");
            this.signatureNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:dsig", "http://www.w3.org/2000/09/xmldsig#");
            this.addToNamespaceContext("dsig", "http://www.w3.org/2000/09/xmldsig#");
        }
        if (this.id != null) {
            this.signatureNode.setAttributeNS("http://www.w3.org/2000/09/xmldsig#", string + ":" + ID_ATTRIBUTE, this.id);
        }
        DOMStreamWriter dOMStreamWriter = new DOMStreamWriter(document, this.signatureNode);
        try {
            dOMStreamWriter.setNamespaceContext((NamespaceContext)this.namespaceContext);
        }
        catch (javax.xml.stream.XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to set namespace context.", xMLStreamException);
        }
        return dOMStreamWriter;
    }

    private void fillNamespaceContext(Node node, DOMSignContext dOMSignContext) {
        this.namespaceContext = new NamespaceContextImpl();
        this.namespaceMap.clear();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        while (node != null) {
            arrayList.add(node);
            node = node.getParentNode();
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            Node node2 = (Node)arrayList.get(i);
            NamedNodeMap namedNodeMap = node2.getAttributes();
            if (namedNodeMap == null) continue;
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                Attr attr = (Attr)namedNodeMap.item(j);
                String string = attr.getNamespaceURI();
                if (string == null || !string.equals("http://www.w3.org/2000/xmlns/")) continue;
                String string2 = attr.getLocalName();
                if ("xmlns".equals(string2)) {
                    string2 = "";
                }
                String string3 = attr.getValue();
                this.namespaceContext.bindNamespace(string2, string3);
                this.namespaceMap.put(string2, string3);
                if (dOMSignContext == null) continue;
                dOMSignContext.putNamespacePrefix(string2, string3);
            }
        }
    }

    private void addToNamespaceContext(String string, String string2) {
        this.namespaceContext.bindNamespace(string, string2);
        this.namespaceMap.put(string, string2);
    }

    private void createSignatureValueNode(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2000/09/xmldsig#", SIGNATUREVALUE_ELEMENT);
            if (this.signatureValueId != null) {
                xMLStreamWriter.writeAttribute(ID_ATTRIBUTE, this.signatureValueId);
            }
            xMLStreamWriter.writeCharacters(this.signatureValue);
            xMLStreamWriter.writeEndElement();
        }
        catch (javax.xml.stream.XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to write element SignatureValue", xMLStreamException);
        }
    }

    public void read(XMLStreamReader xMLStreamReader) throws MarshalException {
        try {
            xMLStreamReader.nextTag();
            this.id = xMLStreamReader.getAttributeValue("http://www.w3.org/2000/09/xmldsig#", ID_ATTRIBUTE);
            xMLStreamReader.nextTag();
        }
        catch (javax.xml.stream.XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to read element ...", xMLStreamException);
        }
    }

    public SignatureValidateResult getSignatureValidateResult() {
        return this.signatureValidateResult;
    }

    private void ensureURIDereferencer(DOMSignContext dOMSignContext) {
        if (dOMSignContext.getURIDereferencer() == null) {
            dOMSignContext.setURIDereferencer(new NodeURIDereferencer(dOMSignContext.getParent().getOwnerDocument()));
        }
    }

    private void ensureURIDereferencer(DOMValidateContext dOMValidateContext) {
        if (dOMValidateContext.getURIDereferencer() == null) {
            dOMValidateContext.setURIDereferencer(new NodeURIDereferencer(dOMValidateContext.getNode().getOwnerDocument()));
        }
    }

    public Key getKey() {
        return this.getSignatureValidateResult().getKeySelectorResult().getKey();
    }

    public List getReferences() {
        return this.signedInfo.getReferences();
    }

    public String getC14NMethod() {
        return this.signedInfo.getCanonicalizationMethod().getAlgorithm();
    }

    public String getSignatureMethod() {
        return this.signedInfo.getSignatureMethod().getAlgorithm();
    }

    public boolean containsNode(Node node) {
        for (SignatureInfo.Reference reference : this.signedInfo.getReferences()) {
            if (!reference.containsNode(node)) continue;
            return true;
        }
        return false;
    }
}

