/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import javax.xml.xpath.XPathFunctionResolver;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.xml.crypto.NodeSetDataImpl;
import weblogic.xml.crypto.api.Data;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.NodeSetData;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.dsig.NodeTransform;
import weblogic.xml.crypto.dsig.TransformFactory;
import weblogic.xml.crypto.dsig.TransformImpl;
import weblogic.xml.crypto.dsig.api.Transform;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.dsig.api.spec.TransformParameterSpec;
import weblogic.xml.crypto.dsig.api.spec.XPath;
import weblogic.xml.crypto.dsig.api.spec.XPathFilter2ParameterSpec;
import weblogic.xml.crypto.utils.DOMUtils;
import weblogic.xml.crypto.utils.DataUtils;
import weblogic.xml.crypto.utils.DebugStreamReader;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.dom.DOMStreamReader;
import weblogic.xml.dom.DOMStreamWriter;

public class XPathFilter2Transform
extends TransformImpl
implements NodeTransform,
TransformFactory {
    private static final String XPATH_ELEMENT = "XPath";
    private static final String XPATH_NS_PREFIX = "dsxp";
    private static final String XPATH_NS_URI = "http://www.w3.org/2002/06/xmldsig-filter2";
    public static final String FILTER_ATTRIBUTE = "Filter";
    private static final TransformFactory factory = new XPathFilter2Transform();
    private XPathFilter2ParameterSpec params;
    private List hereNodes = new ArrayList();

    protected XPathFilter2Transform() {
    }

    protected XPathFilter2Transform(TransformParameterSpec transformParameterSpec) throws InvalidAlgorithmParameterException {
        if (transformParameterSpec != null) {
            if (transformParameterSpec instanceof XPathFilter2ParameterSpec) {
                this.params = (XPathFilter2ParameterSpec)transformParameterSpec;
            } else {
                throw new InvalidAlgorithmParameterException("expected type: XPathFilter2ParameterSpec");
            }
        }
    }

    public static void init() {
        XPathFilter2Transform.register(factory);
    }

    public String getAlgorithm() {
        return XPATH_NS_URI;
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext) throws XMLSignatureException {
        Object object;
        if (this.params == null) {
            throw new XMLSignatureException("No XPath Filter2 parameter.");
        }
        NodeSetData nodeSetData = DataUtils.extractNodeSetData(data);
        if (!nodeSetData.iterator().hasNext()) {
            LogUtils.logDsig("empty input set, empty output set.");
            return data;
        }
        List list = null;
        try {
            object = (Node)nodeSetData.iterator().next();
            Document document = object instanceof Document ? (Document)object : object.getOwnerDocument();
            list = this.evaluate(this.params, this.hereNodes, document);
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new XMLSignatureException("Failed to evaluate xpath expression.", xPathExpressionException);
        }
        if (list.isEmpty()) {
            LogUtils.logDsig("no xpath filter exists, output set is same as input set.");
            return data;
        }
        if (list.size() == 1) {
            object = (NodeSetFilterBlock)list.get(0);
            if (((NodeSetFilterBlock)object).intersect.isEmpty() && ((NodeSetFilterBlock)object).subtract.isEmpty()) {
                LogUtils.logDsig("only union xpath filters exist, output set is same as input set.");
                return data;
            }
        }
        object = new LinkedHashSet();
        int n = 0;
        Iterator iterator = nodeSetData.iterator();
        block2: while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            ++n;
            for (NodeSetFilterBlock nodeSetFilterBlock : list) {
                if (!nodeSetFilterBlock.filterTest(node)) continue;
                object.add(node);
                continue block2;
            }
        }
        LogUtils.logDsig(n + " nodes in input set, " + object.size() + " nodes in result set");
        return new NodeSetDataImpl((Set)object);
    }

    private List evaluate(XPathFilter2ParameterSpec xPathFilter2ParameterSpec, List list, Document document) throws XPathExpressionException, XMLSignatureException {
        ArrayList<NodeSetFilterBlock> arrayList = new ArrayList<NodeSetFilterBlock>();
        LinkedHashSet<Document> linkedHashSet = new LinkedHashSet<Document>();
        linkedHashSet.add(document);
        NodeSetFilter nodeSetFilter = new NodeSetFilter(1, linkedHashSet);
        NodeSetFilterBlock nodeSetFilterBlock = new NodeSetFilterBlock(nodeSetFilter);
        arrayList.add(nodeSetFilterBlock);
        javax.xml.xpath.XPath xPath = XPathFactory.newInstance().newXPath();
        Iterator iterator = list.iterator();
        NamespaceContextImpl namespaceContextImpl = new NamespaceContextImpl();
        XPathFunctionResolverImpl xPathFunctionResolverImpl = new XPathFunctionResolverImpl();
        for (XPath xPath2 : xPathFilter2ParameterSpec.getXPathList()) {
            Node node = null;
            if (iterator.hasNext()) {
                node = (Node)iterator.next();
            }
            namespaceContextImpl.setNamespaceDeclarations(xPath2.getNamespaceMap());
            xPath.setNamespaceContext(namespaceContextImpl);
            xPathFunctionResolverImpl.setHere(node);
            xPath.setXPathFunctionResolver(xPathFunctionResolverImpl);
            String string = xPath2.getExpression();
            string = XPathFunctionResolverImpl.translateHereFunc(string);
            NodeList nodeList = (NodeList)xPath.evaluate(string, document.getDocumentElement(), XPathConstants.NODESET);
            String string2 = xPath2.getFilter().toString();
            NodeSetFilter nodeSetFilter2 = NodeSetFilter.create(nodeList, string2);
            switch (nodeSetFilter2.operation) {
                case 1: {
                    if (!nodeSetFilterBlock.intersect.isEmpty() || !nodeSetFilterBlock.subtract.isEmpty()) {
                        nodeSetFilterBlock = new NodeSetFilterBlock(nodeSetFilter2);
                        arrayList.add(nodeSetFilterBlock);
                        break;
                    }
                    nodeSetFilterBlock.union.add(nodeSetFilter2);
                    break;
                }
                case 2: {
                    nodeSetFilterBlock.intersect.add(nodeSetFilter2);
                    break;
                }
                case 3: {
                    nodeSetFilterBlock.subtract.add(nodeSetFilter2);
                    break;
                }
                default: {
                    throw new XMLSignatureException("Failed to evaluate: unkown operation");
                }
            }
            xPath.reset();
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println(XPathFactory.newInstance().newXPath().evaluate("string-length('abc')", new Object()));
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
        }
        System.out.println(XPathFunctionResolverImpl.translateHereFunc("a-here ( ) + b"));
    }

    protected void writeParameters(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        this.hereNodes.clear();
        try {
            xMLStreamWriter.writeNamespace(XPATH_NS_PREFIX, XPATH_NS_URI);
            for (XPath xPath : this.params.getXPathList()) {
                xMLStreamWriter.writeStartElement(XPATH_NS_URI, XPATH_ELEMENT);
                if (xMLStreamWriter instanceof DOMStreamWriter) {
                    DOMStreamWriter dOMStreamWriter = (DOMStreamWriter)((Object)xMLStreamWriter);
                    Node node = dOMStreamWriter.getCurrentNode();
                    this.hereNodes.add(node);
                } else {
                    this.hereNodes.add(null);
                }
                xMLStreamWriter.writeAttribute(FILTER_ATTRIBUTE, xPath.getFilter().toString());
                this.writeNamespaces(xPath.getNamespaceMap(), xMLStreamWriter);
                xMLStreamWriter.writeCharacters(xPath.getExpression());
                xMLStreamWriter.writeEndElement();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to write XPath transform element.", xMLStreamException);
        }
    }

    protected void readParameters(XMLStreamReader xMLStreamReader) throws MarshalException {
        this.hereNodes.clear();
        ArrayList<XPath> arrayList = new ArrayList<XPath>();
        try {
            while (true) {
                Object object;
                xMLStreamReader.nextTag();
                xMLStreamReader.require(1, XPATH_NS_URI, XPATH_ELEMENT);
                DOMStreamReader dOMStreamReader = null;
                if (xMLStreamReader instanceof DOMStreamReader) {
                    dOMStreamReader = (DOMStreamReader)xMLStreamReader;
                } else if (xMLStreamReader instanceof DebugStreamReader && (object = ((DebugStreamReader)xMLStreamReader).getDelegate()) instanceof DOMStreamReader) {
                    dOMStreamReader = (DOMStreamReader)object;
                }
                object = null;
                if (dOMStreamReader != null) {
                    object = dOMStreamReader.current();
                    this.hereNodes.add(object);
                } else {
                    this.hereNodes.add(null);
                }
                Map map = this.readNamespaces((Node)object);
                String string = xMLStreamReader.getAttributeValue(null, FILTER_ATTRIBUTE);
                String string2 = xMLStreamReader.getElementText();
                arrayList.add(new XPath(string2, XPathFilter2Transform.getFilter(string), map));
            }
        }
        catch (XMLStreamException xMLStreamException) {
            if (arrayList.size() <= 0) {
                throw new MarshalException("Failed to read XPath transform element.", xMLStreamException);
            }
            this.params = new XPathFilter2ParameterSpec(arrayList);
            return;
        }
    }

    private Map readNamespaces(Node node) {
        if (node != null) {
            return DOMUtils.getNamespaceMap(node);
        }
        return new HashMap();
    }

    private void writeNamespaces(Map map, XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        for (String string : map.keySet()) {
            String string2 = (String)map.get(string);
            xMLStreamWriter.writeNamespace(string, string2);
        }
    }

    public static XPath.Filter getFilter(String string) {
        if (XPath.Filter.INTERSECT.toString().equals(string)) {
            return XPath.Filter.INTERSECT;
        }
        if (XPath.Filter.SUBTRACT.toString().equals(string)) {
            return XPath.Filter.SUBTRACT;
        }
        if (XPath.Filter.UNION.toString().equals(string)) {
            return XPath.Filter.UNION;
        }
        throw new IllegalArgumentException("illegal xpath filter: " + string);
    }

    public Transform newTransform(TransformParameterSpec transformParameterSpec) throws InvalidAlgorithmParameterException {
        return new XPathFilter2Transform(transformParameterSpec);
    }

    public String getURI() {
        return XPATH_NS_URI;
    }

    class NodeSetFilterBlock {
        public List union = new ArrayList();
        public List intersect = new ArrayList();
        public List subtract = new ArrayList();

        public NodeSetFilterBlock(NodeSetFilter nodeSetFilter) {
            this.union.add(nodeSetFilter);
        }

        public NodeSetFilterBlock(List list) {
            this.union.addAll(list);
        }

        public boolean filterTest(Node node) throws XMLSignatureException {
            if (this.union.isEmpty()) {
                throw new XMLSignatureException("Failed to do filter test: at least one union node-set filter must exist.");
            }
            boolean bl = false;
            for (NodeSetFilter nodeSetFilter : this.union) {
                if (!nodeSetFilter.contains(node)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
            bl = true;
            for (NodeSetFilter nodeSetFilter : this.intersect) {
                if (nodeSetFilter.contains(node)) continue;
                bl = false;
                break;
            }
            if (!bl) {
                return false;
            }
            bl = true;
            for (NodeSetFilter nodeSetFilter : this.subtract) {
                if (!nodeSetFilter.contains(node)) continue;
                bl = false;
                break;
            }
            return bl;
        }
    }

    static class NodeSetFilter {
        private static final int UNKOWN = 0;
        public static final int UNION = 1;
        public static final int INTERSECT = 2;
        public static final int SUBTRACT = 3;
        public int operation = 0;
        public Set nodeSet = null;

        public NodeSetFilter(int n, Set set) {
            this.operation = n;
            this.nodeSet = set;
        }

        public static NodeSetFilter create(NodeList nodeList, String string) {
            int n = 0;
            if (XPath.Filter.UNION.toString().equals(string)) {
                n = 1;
            } else if (XPath.Filter.INTERSECT.toString().equals(string)) {
                n = 2;
            } else if (XPath.Filter.SUBTRACT.toString().equals(string)) {
                n = 3;
            }
            LinkedHashSet<Object> linkedHashSet = new LinkedHashSet<Object>();
            if (nodeList instanceof Node) {
                linkedHashSet.add(nodeList);
            } else {
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    linkedHashSet.add(node);
                }
            }
            NodeSetFilter nodeSetFilter = new NodeSetFilter(n, linkedHashSet);
            return nodeSetFilter;
        }

        public boolean contains(Node node) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            while (node != null) {
                if (this.nodeSet.contains(node)) {
                    this.nodeSet.addAll(arrayList);
                    return true;
                }
                arrayList.add(node);
                if (node.getNodeType() == 2) {
                    node = ((Attr)node).getOwnerElement();
                    continue;
                }
                node = node.getParentNode();
            }
            return false;
        }
    }

    static class NodeListImpl
    implements NodeList {
        private List nodes = null;

        public NodeListImpl(List list) {
            this.setNodes(list);
        }

        public NodeListImpl(Node[] nodeArray) {
            this.setNodes(nodeArray);
        }

        public NodeListImpl(Node node) {
            this.setNode(node);
        }

        public void setNodes(List list) {
            this.nodes = new ArrayList(list);
        }

        public void setNodes(Node[] nodeArray) {
            this.setNodes(Arrays.asList(nodeArray));
        }

        public void setNode(Node node) {
            this.setNodes(new Node[]{node});
        }

        public void addNode(Node node) {
            this.nodes.add(node);
        }

        public int getLength() {
            return this.nodes.size();
        }

        public Node item(int n) {
            return (Node)this.nodes.get(n);
        }
    }

    static class HereFunction
    implements XPathFunction {
        private NodeListImpl hereList = null;

        public HereFunction(Node node) throws NullPointerException {
            this.setHere(node);
        }

        public void setHere(Node node) throws NullPointerException {
            if (node == null) {
                throw new NullPointerException("here node must be not null.");
            }
            this.hereList = new NodeListImpl(node);
        }

        public Object evaluate(List list) throws XPathFunctionException {
            if (this.hereList.getLength() == 0) {
                throw new XPathFunctionException("can not evaluate here() function, there is no here node exists.");
            }
            if (!(this.hereList.item(0) instanceof Node)) {
                throw new XPathFunctionException("can not evaluate here() function, the here node is invalid: " + this.hereList.item(0));
            }
            return this.hereList;
        }
    }

    static class XPathFunctionResolverImpl
    implements XPathFunctionResolver {
        public static final String XPATH_FILTER2_BUILT_IN_FUNCTION_NS_PREFIX = "__xpath_filter2_built_in_function";
        public static final String XPATH_FILTER2_BUILT_IN_FUNCTION_NS_URI = "http://www.bea.com/weblogic/xml/crypto/dsig/xpath_filter2_built_in_function";
        private static String here_regex = null;
        private static String here_replacement = null;
        private static Pattern here_pattern = null;
        private Node here = null;

        public XPathFunctionResolverImpl() {
            this(null);
        }

        public XPathFunctionResolverImpl(Node node) {
            this.setHere(node);
        }

        public void setHere(Node node) {
            this.here = node;
        }

        public static String translateHereFunc(String string) {
            Matcher matcher = here_pattern.matcher(string);
            return matcher.replaceAll(here_replacement);
        }

        public XPathFunction resolveFunction(QName qName, int n) {
            QName qName2 = new QName(XPATH_FILTER2_BUILT_IN_FUNCTION_NS_URI, "here", XPATH_FILTER2_BUILT_IN_FUNCTION_NS_PREFIX);
            if (qName2.equals(qName) && n == 0) {
                return new HereFunction(this.here);
            }
            return null;
        }

        static {
            here_regex = "(?<![-:])\\b(here\\s*\\(\\s*\\))";
            here_replacement = "__xpath_filter2_built_in_function:$1";
            here_pattern = Pattern.compile(here_regex);
        }
    }

    static class NamespaceContextImpl
    implements NamespaceContext {
        private Map nsMap = null;

        public NamespaceContextImpl() {
            this(null);
        }

        public NamespaceContextImpl(Map map) {
            this.setNamespaceDeclarations(map);
        }

        public void setNamespaceDeclarations(Map map) {
            if (this.nsMap == null) {
                this.nsMap = new HashMap();
            } else {
                this.nsMap.clear();
            }
            if (map != null) {
                this.nsMap.putAll(map);
            }
            this.nsMap.put("__xpath_filter2_built_in_function", "http://www.bea.com/weblogic/xml/crypto/dsig/xpath_filter2_built_in_function");
        }

        public void addNamespaceDeclaration(String string, String string2) {
            if (this.nsMap == null) {
                this.nsMap = new HashMap();
                this.nsMap.put("__xpath_filter2_built_in_function", "http://www.bea.com/weblogic/xml/crypto/dsig/xpath_filter2_built_in_function");
            }
            this.nsMap.put(string, string2);
        }

        public String getNamespaceURI(String string) {
            if (string == null) {
                throw new IllegalArgumentException("not expected prefix: null");
            }
            if (this.nsMap == null || !this.nsMap.containsKey(string)) {
                if ("xml".equals(string)) {
                    return "http://www.w3.org/XML/1998/namespace";
                }
                if ("xmlns".equals(string)) {
                    return "http://www.w3.org/2000/xmlns/";
                }
                return "";
            }
            return (String)this.nsMap.get(string);
        }

        public String getPrefix(String string) {
            return null;
        }

        public Iterator getPrefixes(String string) {
            return null;
        }
    }
}

