/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig;

import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Iterator;
import java.util.LinkedHashSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Node;
import weblogic.xml.crypto.NodeSetDataImpl;
import weblogic.xml.crypto.api.Data;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.NodeSetData;
import weblogic.xml.crypto.api.XMLCryptoContext;
import weblogic.xml.crypto.dsig.NodeTransform;
import weblogic.xml.crypto.dsig.TransformFactory;
import weblogic.xml.crypto.dsig.TransformImpl;
import weblogic.xml.crypto.dsig.api.Transform;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.dsig.api.spec.TransformParameterSpec;
import weblogic.xml.crypto.dsig.api.spec.XPathFilterParameterSpec;
import weblogic.xml.crypto.utils.DataUtils;
import weblogic.xml.crypto.utils.LogUtils;
import weblogic.xml.xpath.DOMXPath;
import weblogic.xml.xpath.XPathException;

public class XPathTransform
extends TransformImpl
implements NodeTransform,
TransformFactory {
    private static final String XPATH_ELEMENT = "XPath";
    private static final TransformFactory factory = new XPathTransform();
    private XPathFilterParameterSpec params;

    protected XPathTransform() {
    }

    protected XPathTransform(TransformParameterSpec transformParameterSpec) throws InvalidAlgorithmParameterException {
        if (transformParameterSpec != null) {
            if (transformParameterSpec instanceof XPathFilterParameterSpec) {
                this.params = (XPathFilterParameterSpec)transformParameterSpec;
            } else {
                throw new InvalidAlgorithmParameterException();
            }
        }
    }

    public static void init() {
        XPathTransform.register(factory);
    }

    public String getAlgorithm() {
        return "http://www.w3.org/TR/1999/REC-xpath-19991116";
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext) throws XMLSignatureException {
        if (this.params == null) {
            throw new XMLSignatureException("No XPath parameter.");
        }
        LogUtils.logDsig("applying xpath: " + this.params.getXPath());
        try {
            NodeSetData nodeSetData = DataUtils.extractNodeSetData(data);
            DOMXPath dOMXPath = new DOMXPath(this.params.getXPath());
            LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>();
            int n = 0;
            Iterator iterator = nodeSetData.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (dOMXPath.evaluateAsBoolean(node)) {
                    linkedHashSet.add(node);
                }
                ++n;
            }
            LogUtils.logDsig(n + " nodes in input set, " + linkedHashSet.size() + " nodes in result set");
            return new NodeSetDataImpl(linkedHashSet);
        }
        catch (XPathException xPathException) {
            throw new XMLSignatureException("Failed to evaluate xpath.", xPathException);
        }
    }

    protected void writeParameters(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2000/09/xmldsig#", XPATH_ELEMENT);
            xMLStreamWriter.writeCharacters(this.params.getXPath());
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to write XPath transform element.", xMLStreamException);
        }
    }

    protected void readParameters(XMLStreamReader xMLStreamReader) throws MarshalException {
        try {
            xMLStreamReader.nextTag();
            xMLStreamReader.require(1, "http://www.w3.org/2000/09/xmldsig#", XPATH_ELEMENT);
            this.params = new XPathFilterParameterSpec(xMLStreamReader.getElementText());
            if (this.params == null) {
                throw new MarshalException("No parameter for XPath transform found.");
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to read XPath transform element.", xMLStreamException);
        }
    }

    public Transform newTransform(TransformParameterSpec transformParameterSpec) throws InvalidAlgorithmParameterException {
        return new XPathTransform(transformParameterSpec);
    }

    public String getURI() {
        return "http://www.w3.org/TR/1999/REC-xpath-19991116";
    }
}

