/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig.api;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.util.List;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.URIDereferencer;
import weblogic.xml.crypto.dsig.api.CanonicalizationMethod;
import weblogic.xml.crypto.dsig.api.DigestMethod;
import weblogic.xml.crypto.dsig.api.Manifest;
import weblogic.xml.crypto.dsig.api.Reference;
import weblogic.xml.crypto.dsig.api.SignatureMethod;
import weblogic.xml.crypto.dsig.api.SignatureProperties;
import weblogic.xml.crypto.dsig.api.SignatureProperty;
import weblogic.xml.crypto.dsig.api.SignedInfo;
import weblogic.xml.crypto.dsig.api.Transform;
import weblogic.xml.crypto.dsig.api.XMLObject;
import weblogic.xml.crypto.dsig.api.XMLSignature;
import weblogic.xml.crypto.dsig.api.XMLSignatureException;
import weblogic.xml.crypto.dsig.api.XMLValidateContext;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfo;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfoFactory;
import weblogic.xml.crypto.dsig.api.spec.C14NMethodParameterSpec;
import weblogic.xml.crypto.dsig.api.spec.DigestMethodParameterSpec;
import weblogic.xml.crypto.dsig.api.spec.SignatureMethodParameterSpec;
import weblogic.xml.crypto.dsig.api.spec.TransformParameterSpec;

public abstract class XMLSignatureFactory {
    private String mechanismType;
    private Provider provider;
    private static final String defaultFactory = "weblogic.xml.crypto.dsig.XMLSignatureFactoryImpl";

    protected XMLSignatureFactory(String string, Provider provider) {
        this.mechanismType = string;
        this.provider = provider;
    }

    public static XMLSignatureFactory getInstance() throws XMLSignatureException {
        return XMLSignatureFactory.getSignatureFactory(defaultFactory);
    }

    public static XMLSignatureFactory getInstance(String string) throws XMLSignatureException {
        return XMLSignatureFactory.getSignatureFactory(defaultFactory);
    }

    public static XMLSignatureFactory getInstance(String string, Provider provider) throws XMLSignatureException, NoSuchProviderException {
        return XMLSignatureFactory.getSignatureFactory(defaultFactory);
    }

    public static XMLSignatureFactory getInstance(String string, String string2) throws XMLSignatureException {
        return XMLSignatureFactory.getSignatureFactory(defaultFactory);
    }

    private static XMLSignatureFactory getSignatureFactory(String string) throws XMLSignatureException {
        try {
            return (XMLSignatureFactory)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            throw new XMLSignatureException("can't create signature factory " + string, exception);
        }
    }

    public String getMechanismType() {
        return this.mechanismType;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public abstract KeyInfoFactory getKeyInfoFactory();

    public abstract URIDereferencer getURIDereferencer();

    public abstract boolean isFeatureSupported(String var1);

    public abstract CanonicalizationMethod newCanonicalizationMethod(String var1, C14NMethodParameterSpec var2) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException;

    public abstract DigestMethod newDigestMethod(String var1, DigestMethodParameterSpec var2) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException;

    public abstract Manifest newManifest(List var1);

    public abstract Manifest newManifest(List var1, String var2);

    public abstract Reference newReference(String var1, DigestMethod var2);

    public abstract Reference newReference(String var1, DigestMethod var2, List var3, String var4, String var5);

    public abstract SignatureMethod newSignatureMethod(String var1, SignatureMethodParameterSpec var2) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException;

    public abstract SignatureProperties newSignatureProperties(List var1, String var2);

    public abstract SignatureProperty newSignatureProperty(List var1, String var2, String var3);

    public abstract SignedInfo newSignedInfo(CanonicalizationMethod var1, SignatureMethod var2, List var3);

    public abstract SignedInfo newSignedInfo(CanonicalizationMethod var1, SignatureMethod var2, List var3, String var4);

    public abstract Transform newTransform(String var1, TransformParameterSpec var2) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException;

    public abstract XMLObject newXMLObject(List var1, String var2, String var3, String var4);

    public abstract XMLSignature newXMLSignature(SignedInfo var1, KeyInfo var2);

    public abstract XMLSignature newXMLSignature(SignedInfo var1, KeyInfo var2, List var3, String var4, String var5);

    public abstract XMLSignature unmarshalXMLSignature(XMLValidateContext var1) throws MarshalException;
}

