/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig.keyinfo;

import java.security.KeyException;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.XMLStructure;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyValue;
import weblogic.xml.crypto.dsig.keyinfo.KeyValueImpl;
import weblogic.xml.crypto.utils.StaxUtils;
import weblogic.xml.security.utils.Utils;

public final class DSAKeyValue
extends KeyValueImpl
implements KeyValue,
XMLStructure,
WLXMLStructure {
    public static final String DSAKEYVALUE_ELEMENT = "DSAKeyValue";
    private static final String P_ELEMENT = "P";
    private static final String Q_ELEMENT = "Q";
    private static final String G_ELEMENT = "G";
    private static final String Y_ELEMENT = "Y";
    private static final String J_ELEMENT = "J";
    private static final String ALGORITHM_DSA = "DSA";
    private DSAPublicKey publicKey;
    private String p;
    private String q;
    private String g;
    private String y;

    DSAKeyValue() {
    }

    DSAKeyValue(DSAPublicKey dSAPublicKey) {
        this.publicKey = dSAPublicKey;
    }

    public PublicKey getPublicKey() throws KeyException {
        return this.publicKey;
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public void write(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
            xMLStreamWriter.writeStartElement("http://www.w3.org/2000/09/xmldsig#", DSAKEYVALUE_ELEMENT);
            DSAParams dSAParams = this.publicKey.getParams();
            StaxUtils.writeElement(xMLStreamWriter, "http://www.w3.org/2000/09/xmldsig#", P_ELEMENT, Utils.toCryptoBinary(dSAParams.getP()));
            StaxUtils.writeElement(xMLStreamWriter, "http://www.w3.org/2000/09/xmldsig#", Q_ELEMENT, Utils.toCryptoBinary(dSAParams.getQ()));
            StaxUtils.writeElement(xMLStreamWriter, "http://www.w3.org/2000/09/xmldsig#", G_ELEMENT, Utils.toCryptoBinary(dSAParams.getG()));
            StaxUtils.writeElement(xMLStreamWriter, "http://www.w3.org/2000/09/xmldsig#", Y_ELEMENT, Utils.toCryptoBinary(this.publicKey.getY()));
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to write element KeyValue", xMLStreamException);
        }
    }

    public void read(XMLStreamReader xMLStreamReader) throws MarshalException {
        try {
            xMLStreamReader.nextTag();
            String string = xMLStreamReader.getLocalName();
            if (P_ELEMENT.equals(string)) {
                xMLStreamReader.next();
                this.p = xMLStreamReader.getText();
                xMLStreamReader.nextTag();
                xMLStreamReader.nextTag();
                xMLStreamReader.next();
                this.q = xMLStreamReader.getText();
                xMLStreamReader.nextTag();
                xMLStreamReader.nextTag();
            }
            if (G_ELEMENT.equals(string = xMLStreamReader.getLocalName())) {
                xMLStreamReader.next();
                this.g = xMLStreamReader.getText();
                xMLStreamReader.nextTag();
                xMLStreamReader.nextTag();
            }
            xMLStreamReader.require(1, "http://www.w3.org/2000/09/xmldsig#", Y_ELEMENT);
            xMLStreamReader.next();
            this.y = xMLStreamReader.getText();
            StaxUtils.forwardToEndElement("http://www.w3.org/2000/09/xmldsig#", DSAKEYVALUE_ELEMENT, xMLStreamReader);
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(Utils.fromCryptoBinary(this.y), Utils.fromCryptoBinary(this.p), Utils.fromCryptoBinary(this.q), Utils.fromCryptoBinary(this.g));
            this.publicKey = (DSAPublicKey)this.createFromKeySpec(ALGORITHM_DSA, dSAPublicKeySpec);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to read DSAKeyValue element.", xMLStreamException);
        }
    }
}

