/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig.keyinfo;

import java.security.KeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.w3c.dom.Node;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.api.XMLStructure;
import weblogic.xml.crypto.dsig.WLXMLStructure;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyInfo;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyName;
import weblogic.xml.crypto.dsig.api.keyinfo.KeyValue;
import weblogic.xml.crypto.dsig.keyinfo.KeyInfoObjectBase;
import weblogic.xml.crypto.utils.StaxUtils;
import weblogic.xml.crypto.wss.SecurityTokenReferenceImpl;
import weblogic.xml.crypto.wss.provider.SecurityTokenReference;

public class KeyInfoImpl
implements XMLStructure,
KeyInfo,
WLXMLStructure {
    public static final String KEYINFO_ELEMENT = "KeyInfo";
    private List content;
    private String id;
    private List keyNames = new ArrayList();
    private List publicKeys = new ArrayList();
    private List securityTokenRefs = new ArrayList();

    KeyInfoImpl(List list) {
        this(list, null);
    }

    KeyInfoImpl(List list, String string) {
        try {
            this.setContent(list);
        }
        catch (KeyException keyException) {
            throw new IllegalArgumentException(keyException.getMessage());
        }
        this.id = string;
    }

    public KeyInfoImpl() {
        this.content = new ArrayList();
    }

    public List getContent() {
        return Collections.unmodifiableList(this.content);
    }

    private void setContent(List list) throws KeyException {
        this.content = list;
        for (Object e : list) {
            if (e instanceof KeyName) {
                this.keyNames.add(((KeyName)e).getName());
            }
            if (e instanceof KeyValue) {
                this.publicKeys.add(((KeyValue)e).getPublicKey());
            }
            if (!(e instanceof SecurityTokenReference)) continue;
            this.securityTokenRefs.add(e);
        }
    }

    public String getId() {
        return this.id;
    }

    public boolean isFeatureSupported(String string) {
        return false;
    }

    public void write(XMLStreamWriter xMLStreamWriter) throws MarshalException {
        try {
            xMLStreamWriter.writeStartElement("http://www.w3.org/2000/09/xmldsig#", KEYINFO_ELEMENT);
            if (this.id != null) {
                xMLStreamWriter.writeAttribute("Id", this.id);
            }
            for (Object e : this.content) {
                if (e instanceof SecurityTokenReference) {
                    SecurityTokenReference securityTokenReference = (SecurityTokenReference)e;
                    Node node = SecurityTokenReferenceImpl.getStrNode(securityTokenReference);
                    StaxUtils.writeNode(xMLStreamWriter, node);
                    continue;
                }
                ((WLXMLStructure)e).write(xMLStreamWriter);
            }
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to write element KeyInfo", xMLStreamException);
        }
    }

    public void read(XMLStreamReader xMLStreamReader) throws MarshalException {
        try {
            this.id = StaxUtils.getAttributeValue("http://www.w3.org/2000/09/xmldsig#", "Id", xMLStreamReader);
            xMLStreamReader.nextTag();
            while (!KEYINFO_ELEMENT.equals(xMLStreamReader.getLocalName()) || !"http://www.w3.org/2000/09/xmldsig#".equals(xMLStreamReader.getNamespaceURI())) {
                Object object = KeyInfoObjectBase.readKeyInfoObject(xMLStreamReader);
                this.content.add(object);
                if (object instanceof KeyName) {
                    this.keyNames.add(((KeyName)object).getName());
                }
                if (object instanceof KeyValue) {
                    this.publicKeys.add(((KeyValue)object).getPublicKey());
                }
                if (object instanceof SecurityTokenReference) {
                    this.securityTokenRefs.add(object);
                }
                if (!(object instanceof SecurityTokenReference)) {
                    xMLStreamReader.nextTag();
                    continue;
                }
                if (xMLStreamReader.isStartElement() || xMLStreamReader.isEndElement()) continue;
                xMLStreamReader.nextTag();
            }
            StaxUtils.forwardToEndElement("http://www.w3.org/2000/09/xmldsig#", KEYINFO_ELEMENT, xMLStreamReader);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new MarshalException("Failed to instantiate object for child of KeyInfo element.", xMLStreamException);
        }
        catch (KeyException keyException) {
            throw new MarshalException("Failed to get public key from KeyValue object.", keyException);
        }
    }

    public String getKeyName() {
        return (String)this.keyNames.get(0);
    }

    public Iterator getPublicKeys() {
        return this.publicKeys.iterator();
    }

    public Iterator getKeyNames() {
        return this.keyNames.iterator();
    }

    public Iterator getSecurityTokenReferences() {
        return this.securityTokenRefs.iterator();
    }
}

