/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.crypto.dsig.keyinfo;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import weblogic.utils.collections.ConcurrentHashMap;
import weblogic.xml.crypto.api.MarshalException;
import weblogic.xml.crypto.dsig.KeyInfoObjectFactory;
import weblogic.xml.crypto.dsig.keyinfo.KeyNameImpl;
import weblogic.xml.crypto.dsig.keyinfo.KeyValueImpl;
import weblogic.xml.crypto.dsig.keyinfo.RetrievalMethodImpl;
import weblogic.xml.crypto.dsig.keyinfo.X509DataImpl;
import weblogic.xml.crypto.encrypt.WLEncryptedKey;
import weblogic.xml.crypto.wss.SecurityTokenReferenceImpl;

public abstract class KeyInfoObjectBase {
    private static final ConcurrentHashMap factories = new ConcurrentHashMap();

    private static final void initFactories() {
        KeyNameImpl.init();
        KeyValueImpl.init();
        RetrievalMethodImpl.init();
        X509DataImpl.init();
        WLEncryptedKey.init();
        KeyInfoObjectBase.register(new SecurityTokenReferenceImpl());
    }

    public static void register(KeyInfoObjectFactory keyInfoObjectFactory) {
        factories.put((Object)keyInfoObjectFactory.getQName(), (Object)keyInfoObjectFactory);
    }

    public static Object readKeyInfoObject(XMLStreamReader xMLStreamReader) throws MarshalException {
        QName qName = xMLStreamReader.getName();
        KeyInfoObjectFactory keyInfoObjectFactory = (KeyInfoObjectFactory)factories.get((Object)qName);
        if (keyInfoObjectFactory == null) {
            throw new MarshalException("KeyInfo child element " + qName + " not supported.");
        }
        Object object = keyInfoObjectFactory.newKeyInfoObject(xMLStreamReader);
        return object;
    }

    static {
        KeyInfoObjectBase.initFactories();
    }
}

